/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.lifecycle.HttpLifecycleManager;
import com.hjq.http.model.CallProxy;
import com.hjq.http.request.BaseRequest;
import java.io.IOException;
import java.net.SocketTimeoutException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public abstract class BaseCallback
implements Callback {
    private final BaseRequest<?> mBaseRequest;
    private CallProxy mCall;
    private int mRetryCount;

    public BaseCallback(BaseRequest<?> request) {
        this.mBaseRequest = request;
        HttpLifecycleManager.bind(this.mBaseRequest.getLifecycleOwner());
    }

    public BaseCallback setCall(CallProxy call) {
        this.mCall = call;
        return this;
    }

    public void start() {
        this.mCall.enqueue(this);
        this.onStart(this.mCall);
    }

    protected CallProxy getCall() {
        return this.mCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call call, Response response) {
        try {
            this.onResponse(response);
        }
        catch (Exception e) {
            this.onFailure(e);
        }
        finally {
            response.close();
        }
    }

    public void onFailure(Call call, IOException e) {
        if (e instanceof SocketTimeoutException && this.mRetryCount < EasyConfig.getInstance().getRetryCount()) {
            EasyUtils.postDelayed(() -> {
                if (!HttpLifecycleManager.isLifecycleActive(this.mBaseRequest.getLifecycleOwner())) {
                    EasyLog.print("\u5bbf\u4e3b\u5df2\u88ab\u9500\u6bc1\uff0c\u65e0\u6cd5\u5bf9\u8bf7\u6c42\u8fdb\u884c\u91cd\u8bd5");
                    return;
                }
                ++this.mRetryCount;
                Call newCall = call.clone();
                this.mCall.setCall(newCall);
                newCall.enqueue((Callback)this);
                EasyLog.print("\u8bf7\u6c42\u8d85\u65f6\uff0c\u6b63\u5728\u5ef6\u8fdf\u91cd\u8bd5\uff0c\u91cd\u8bd5\u6b21\u6570\uff1a" + this.mRetryCount + "/" + EasyConfig.getInstance().getRetryCount());
            }, EasyConfig.getInstance().getRetryTime());
            return;
        }
        this.onFailure(e);
    }

    protected abstract void onStart(Call var1);

    protected abstract void onResponse(Response var1) throws Exception;

    protected abstract void onFailure(Exception var1);
}

