/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.hjq.http.EasyLog;
import com.hjq.http.annotation.HttpIgnore;
import com.hjq.http.annotation.HttpRename;
import com.hjq.http.body.UpdateBody;
import com.hjq.http.model.FileContentResolver;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okio.Okio;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class EasyUtils {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());

    public static void post(Runnable r) {
        HANDLER.post(r);
    }

    public static void postDelayed(Runnable r, long delayMillis) {
        HANDLER.postDelayed(r, delayMillis);
    }

    public static void closeStream(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            EasyLog.print(e);
        }
    }

    public static boolean isBeanType(Object object) {
        if (object == null) {
            return false;
        }
        return !(object instanceof Number) && !(object instanceof CharSequence) && !(object instanceof Boolean) && !(object instanceof File) && !(object instanceof InputStream) && !(object instanceof RequestBody) && !(object instanceof Character) && !(object instanceof JSONObject) && !(object instanceof JSONArray);
    }

    public static boolean isMultipart(List<Field> fields) {
        for (Field field : fields) {
            field.setAccessible(true);
            Class<?> clazz = field.getType();
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i <= interfaces.length; ++i) {
                Type[] actualTypeArguments;
                Class<?> temp = i == interfaces.length ? clazz : interfaces[i];
                if (!List.class.equals(temp) || (actualTypeArguments = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()).length != 1 || !File.class.equals((Object)actualTypeArguments[0])) continue;
                return true;
            }
            do {
                if (!File.class.equals(clazz) && !InputStream.class.equals(clazz) && !RequestBody.class.equals(clazz) && !MultipartBody.Part.class.equals(clazz)) continue;
                return true;
            } while ((clazz = clazz.getSuperclass()) != null && !Object.class.equals(clazz));
        }
        return false;
    }

    public static boolean isFileList(List<?> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (Object object : list) {
            if (object instanceof File) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof List && ((List)object).isEmpty()) {
            return true;
        }
        return object instanceof Map && ((Map)object).isEmpty();
    }

    public static JSONArray listToJsonArray(List<?> list) {
        JSONArray jsonArray = new JSONArray();
        if (list == null || list.isEmpty()) {
            return jsonArray;
        }
        for (Object value : list) {
            if (EasyUtils.isEmpty(value)) continue;
            if (value instanceof List) {
                jsonArray.put((Object)EasyUtils.listToJsonArray((List)value));
                continue;
            }
            if (value instanceof Map) {
                jsonArray.put((Object)EasyUtils.mapToJsonObject((Map)value));
                continue;
            }
            if (EasyUtils.isBeanType(value)) {
                jsonArray.put((Object)EasyUtils.mapToJsonObject(EasyUtils.beanToHashMap(value)));
                continue;
            }
            jsonArray.put(value);
        }
        return jsonArray;
    }

    public static JSONObject mapToJsonObject(Map<?, ?> map) {
        JSONObject jsonObject = new JSONObject();
        if (map == null || map.isEmpty()) {
            return jsonObject;
        }
        Set<?> keySet = map.keySet();
        for (Object key : keySet) {
            Object value = map.get(key);
            if (EasyUtils.isEmpty(value)) continue;
            try {
                if (value instanceof List) {
                    jsonObject.put(String.valueOf(key), (Object)EasyUtils.listToJsonArray((List)value));
                    continue;
                }
                if (value instanceof Map) {
                    jsonObject.put(String.valueOf(key), (Object)EasyUtils.mapToJsonObject((Map)value));
                    continue;
                }
                if (EasyUtils.isBeanType(value)) {
                    jsonObject.put(String.valueOf(key), (Object)EasyUtils.mapToJsonObject(EasyUtils.beanToHashMap(value)));
                    continue;
                }
                jsonObject.put(String.valueOf(key), value);
            }
            catch (JSONException e) {
                EasyLog.print(e);
            }
        }
        return jsonObject;
    }

    public static HashMap<String, Object> beanToHashMap(Object object) {
        if (object == null) {
            return null;
        }
        Field[] fields = object.getClass().getDeclaredFields();
        HashMap<String, Object> data = new HashMap<String, Object>(fields.length);
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                String key;
                Object value = field.get(object);
                if (EasyUtils.isEmpty(value) || field.isAnnotationPresent(HttpIgnore.class)) continue;
                if (field.isAnnotationPresent(HttpRename.class)) {
                    key = field.getAnnotation(HttpRename.class).value();
                } else {
                    key = field.getName();
                    if (key.matches("this\\$\\d+") || "Companion".equals(key)) continue;
                }
                if (value instanceof List) {
                    data.put(key, EasyUtils.listToJsonArray((List)value));
                    continue;
                }
                if (value instanceof Map) {
                    data.put(key, EasyUtils.mapToJsonObject((Map)value));
                    continue;
                }
                if (EasyUtils.isBeanType(value)) {
                    data.put(key, EasyUtils.beanToHashMap(value));
                    continue;
                }
                data.put(key, value);
            }
            catch (IllegalAccessException e) {
                EasyLog.print(e);
            }
        }
        return data;
    }

    public static Type getReflectType(Object object) {
        if (object == null) {
            return Void.class;
        }
        Type[] types = object.getClass().getGenericInterfaces();
        if (types.length > 0) {
            return ((ParameterizedType)types[0]).getActualTypeArguments()[0];
        }
        return ((ParameterizedType)object.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public static int getProgressProgress(long totalByte, long currentByte) {
        return (int)((double)currentByte / (double)totalByte * 100.0);
    }

    public static String encodeString(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return text;
        }
    }

    public static MultipartBody.Part createPart(String key, File file) {
        String fileName = EasyUtils.encodeString(file.getName());
        if (file instanceof FileContentResolver) {
            try {
                FileContentResolver fileContentResolver = (FileContentResolver)file;
                InputStream inputStream = fileContentResolver.openInputStream();
                if (inputStream == null) {
                    return null;
                }
                String name = fileContentResolver.getFileName();
                if (TextUtils.isEmpty((CharSequence)name)) {
                    name = fileContentResolver.getName();
                }
                return MultipartBody.Part.createFormData((String)key, (String)fileName, (RequestBody)new UpdateBody(Okio.source((InputStream)inputStream), fileContentResolver.getContentType(), name, inputStream.available()));
            }
            catch (IOException e) {
                EasyLog.print(e);
                EasyLog.print("\u6587\u4ef6\u6d41\u8bfb\u53d6\u5931\u8d25\uff0c\u5c06\u88ab\u5ffd\u7565\u4e0a\u4f20\uff1a" + key + " = " + file.getPath());
                return null;
            }
        }
        try {
            return MultipartBody.Part.createFormData((String)key, (String)fileName, (RequestBody)new UpdateBody(file));
        }
        catch (FileNotFoundException e) {
            EasyLog.print("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u5c06\u88ab\u5ffd\u7565\u4e0a\u4f20\uff1a" + key + " = " + file.getPath());
            return null;
        }
    }

    public static MultipartBody.Part createPart(String key, InputStream inputStream) {
        try {
            return MultipartBody.Part.createFormData((String)key, null, (RequestBody)new UpdateBody(inputStream, key));
        }
        catch (IOException e) {
            EasyLog.print(e);
            return null;
        }
    }
}

