/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.device.compat;

import android.annotation.SuppressLint;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hjq.device.compat.SystemPropertyCompat;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DeviceOs {
    static final String SYSTEM_PROPERTY_BUILD_VERSION_INCREMENTAL = "ro.build.version.incremental";
    static final String SYSTEM_PROPERTY_BUILD_DISPLAY_ID = "ro.build.display.id";
    static final String[] OS_VERSION_NAME_UNKNOWN;
    static final String[] OS_REGION_MI;
    static final String OS_NAME_HYPER_OS = "HyperOS";
    static final String OS_VERSION_NAME_HYPER_OS = "ro.mi.os.version.incremental";
    static final String[] OS_CONDITIONS_HYPER_OS;
    static final String[] OS_REGION_HYPER_OS;
    static final String OS_NAME_MIUI = "MIUI";
    static final String OS_VERSION_NAME_MIUI = "ro.build.version.incremental";
    static final String[] OS_CONDITIONS_MIUI;
    static final String[] OS_REGION_MIUI;
    static final String OS_NAME_REALME_UI = "RealmeUI";
    static final String OS_VERSION_NAME_REALME_UI = "ro.build.version.realmeui";
    static final String OS_NAME_COLOR_OS = "ColorOS";
    static final String[] OS_VERSION_NAME_COLOR_OS;
    static final String OS_CONDITIONS_VIVO_OS = "ro.vivo.os.build.display.id";
    static final String OS_NAME_ORIGIN_OS = "OriginOS";
    static final String[] OS_VERSION_NAME_ORIGIN_OS;
    static final String OS_NAME_FUNTOUCH_OS = "FuntouchOS";
    static final String[] OS_VERSION_NAME_FUNTOUCH_OS;
    static final String OS_NAME_MAGIC_OS = "MagicOS";
    static final String[] OS_VERSION_NAME_MAGIC_OS;
    static final String OS_NAME_HARMONY_OS = "HarmonyOS";
    static final String[] OS_VERSION_NAME_HARMONY_OS;
    static final String OS_NAME_EMUI = "EMUI";
    static final String OS_VERSION_NAME_EMUI = "ro.build.version.emui";
    static final String OS_NAME_ONE_UI = "OneUI";
    static final String OS_VERSION_NAME_ONE_UI_NEW = "ro.build.version.oneui";
    static final String OS_VERSION_NAME_ONE_UI_OLD = "extlib.oneui.Version";
    static final String OS_NAME_OXYGEN_OS = "OxygenOS";
    static final String OS_VERSION_NAME_OXYGEN_OS = "ro.oxygen.version";
    static final String OS_NAME_H2_OS = "H2OS";
    static final String OS_VERSION_NAME_H2_OS = "ro.rom.version";
    static final String OS_NAME_FLYME = "Flyme";
    static final String[] OS_VERSION_NAME_FLYME;
    static final String[] OS_CONDITIONS_FLYME;
    static final String OS_VERSION_ZTE_OS = "ro.build.MiFavor_version";
    static final String[] OS_CONDITIONS_ZTE_OS;
    static final String OS_NAME_MY_OS = "MyOS";
    static final String OS_VERSION_NAME_MY_OS = "ro.build.display.id";
    static final String OS_NAME_MIFAVOR_UI = "MifavorUI";
    static final String OS_VERSION_NAME_MIFAVOR_UI = "ro.build.MiFavor_version";
    static final String OS_NAME_SMARTISAN_OS = "SmartisanOS";
    static final String OS_VERSION_NAME_SMARTISAN_OS = "ro.smartisan.version";
    static final String[] OS_CONDITIONS_SMARTISAN_OS;
    static final String OS_NAME_EUI_OS = "EUI";
    static final String OS_VERSION_NAME_EUI_OS = "ro.letv.release.version";
    static final String[] OS_CONDITIONS_EUI_OS;
    static final String OS_NAME_ZUI_OS = "ZUI";
    static final String OS_VERSION_NAME_ZUI_OS = "ro.letv.release.version";
    static final String[] OS_CONDITIONS_ZUI_OS;
    static final String OS_NAME_360_UI = "360UI";
    static final String OS_VERSION_NAME_360_UI = "ro.build.uiversion";
    @Nullable
    private static String sCurrentOsName;
    @Nullable
    private static String sCurrentOriginalOsVersionName;

    private DeviceOs() {
    }

    public static boolean isHyperOs() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_HYPER_OS);
    }

    public static boolean isHyperOsByChina() {
        String[] propertyValues;
        if (!DeviceOs.isHyperOs()) {
            return false;
        }
        for (String propertyValue : propertyValues = SystemPropertyCompat.getSystemPropertyValues(OS_REGION_HYPER_OS)) {
            if (!propertyValue.equalsIgnoreCase("cn")) continue;
            return true;
        }
        return false;
    }

    public static boolean isHyperOsByGlobal() {
        String[] propertyValues;
        if (!DeviceOs.isHyperOs()) {
            return false;
        }
        for (String propertyValue : propertyValues = SystemPropertyCompat.getSystemPropertyValues(OS_REGION_HYPER_OS)) {
            if (!propertyValue.equalsIgnoreCase("global")) continue;
            return true;
        }
        return false;
    }

    public static boolean isHyperOsOptimization() {
        return DeviceOs.isXiaoMiSystemOptimization();
    }

    public static boolean isMiui() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_MIUI);
    }

    public static boolean isMiuiByChina() {
        String[] propertyValues;
        if (!DeviceOs.isMiui()) {
            return false;
        }
        for (String propertyValue : propertyValues = SystemPropertyCompat.getSystemPropertyValues(OS_REGION_MIUI)) {
            if (!propertyValue.equalsIgnoreCase("cn")) continue;
            return true;
        }
        return false;
    }

    public static boolean isMiuiByGlobal() {
        String[] propertyValues;
        if (!DeviceOs.isMiui()) {
            return false;
        }
        for (String propertyValue : propertyValues = SystemPropertyCompat.getSystemPropertyValues(OS_REGION_MIUI)) {
            if (!propertyValue.equalsIgnoreCase("global")) continue;
            return true;
        }
        return false;
    }

    public static boolean isMiuiOptimization() {
        return DeviceOs.isXiaoMiSystemOptimization();
    }

    @SuppressLint(value={"PrivateApi"})
    private static boolean isXiaoMiSystemOptimization() {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method getMethod = clazz.getMethod("get", String.class, String.class);
            String ctsValue = String.valueOf(getMethod.invoke(clazz, "ro.miui.cts", ""));
            Method getBooleanMethod = clazz.getMethod("getBoolean", String.class, Boolean.TYPE);
            return Boolean.parseBoolean(String.valueOf(getBooleanMethod.invoke(clazz, "persist.sys.miui_optimization", !"1".equals(ctsValue))));
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isRealmeUi() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_REALME_UI);
    }

    public static boolean isColorOs() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_COLOR_OS);
    }

    public static boolean isOriginOs() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_ORIGIN_OS);
    }

    public static boolean isFuntouchOs() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_FUNTOUCH_OS);
    }

    public static boolean isMagicOs() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_MAGIC_OS);
    }

    public static boolean isHarmonyOs() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_HARMONY_OS);
    }

    public static boolean isEmui() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_EMUI);
    }

    public static boolean isOneUi() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_ONE_UI);
    }

    public static boolean isOxygenOs() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_OXYGEN_OS);
    }

    public static boolean isH2Os() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_H2_OS);
    }

    public static boolean isFlyme() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_FLYME);
    }

    public static boolean isMyOs() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_MY_OS);
    }

    public static boolean isMifavorUi() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_MIFAVOR_UI);
    }

    public static boolean isSmartisanOs() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_SMARTISAN_OS);
    }

    public static boolean isEui() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_EUI_OS);
    }

    public static boolean isZui() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_ZUI_OS);
    }

    public static boolean is360Ui() {
        return TextUtils.equals((CharSequence)sCurrentOsName, (CharSequence)OS_NAME_360_UI);
    }

    @NonNull
    public static String getOsName() {
        return sCurrentOsName != null ? sCurrentOsName : "";
    }

    @NonNull
    public static String getOsVersionName() {
        String originalOsVersionName = DeviceOs.getOriginalOsVersionName();
        Pattern pattern = Pattern.compile("(\\d+(?:\\.\\d+)+)");
        Matcher matcher = pattern.matcher(originalOsVersionName);
        if (matcher.find()) {
            String result = matcher.group(1);
            return result != null ? result : "";
        }
        pattern = Pattern.compile("(\\d+)");
        matcher = pattern.matcher(originalOsVersionName);
        if (matcher.find()) {
            String result = matcher.group(1);
            return result != null ? result : "";
        }
        return "";
    }

    @NonNull
    public static String getOriginalOsVersionName() {
        return sCurrentOriginalOsVersionName != null ? sCurrentOriginalOsVersionName : "";
    }

    public static int getOsBigVersionCode() {
        String osVersionName = DeviceOs.getOsVersionName();
        if (TextUtils.isEmpty((CharSequence)osVersionName)) {
            return 0;
        }
        String[] array = osVersionName.split("\\.");
        if (array.length == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(array[0]);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @NonNull
    private static String getOneUiVersionNameByVersionCode(int oneUiVersionCode) {
        int oneVersion = oneUiVersionCode / 10000;
        int twoVersion = oneUiVersionCode % 10000;
        int threeVersion = oneUiVersionCode % 100;
        if (threeVersion > 0) {
            return oneVersion + "." + twoVersion / 100 + "." + threeVersion;
        }
        return oneVersion + "." + twoVersion / 100;
    }

    static {
        String osVersion;
        String oneUiVersion;
        String emuiVersion;
        String magicOsVersion;
        String vivoOsName;
        OS_VERSION_NAME_UNKNOWN = new String[]{"ro.build.display.id", "ro.build.version.incremental"};
        OS_REGION_MI = new String[]{"ro.miui.build.region", "ro.miui.region", "ro.vendor.miui.region"};
        OS_CONDITIONS_HYPER_OS = new String[]{"ro.mi.os.version.name", "ro.mi.os.version.code", OS_VERSION_NAME_HYPER_OS};
        OS_REGION_HYPER_OS = OS_REGION_MI;
        OS_CONDITIONS_MIUI = new String[]{"ro.miui.ui.version.name", "ro.miui.ui.version.code"};
        OS_REGION_MIUI = OS_REGION_MI;
        OS_VERSION_NAME_COLOR_OS = new String[]{"ro.build.version.opporom", "ro.build.version.oplusrom.display"};
        OS_VERSION_NAME_ORIGIN_OS = new String[]{OS_CONDITIONS_VIVO_OS};
        OS_VERSION_NAME_FUNTOUCH_OS = new String[]{"ro.vivo.os.version", "ro.vivo.rom.version", "ro.vivo.rom", OS_CONDITIONS_VIVO_OS};
        OS_VERSION_NAME_MAGIC_OS = new String[]{"msc.config.magic.version", "ro.build.version.magic"};
        OS_VERSION_NAME_HARMONY_OS = new String[]{"hw_sc.build.platform.version", "ro.huawei.build.display.id", "hwouc.hwpatch.version", "persist.mygote.build.id", "persist.sys.hiview.base_version", "ro.comp.hl.product_base_version"};
        OS_VERSION_NAME_FLYME = new String[]{"ro.flyme.version.id", "ro.build.display.id"};
        OS_CONDITIONS_FLYME = new String[]{"ro.flyme.published", "ro.flyme.version.id"};
        OS_CONDITIONS_ZTE_OS = new String[]{"ro.build.MiFavor_version", "ro.vendor.mifavor.custom", "ro.vendor.mifavor.mfvkeyguard.type", "ro.vendor.mifavor.voicetotext"};
        OS_CONDITIONS_SMARTISAN_OS = new String[]{"ro.smartisan.sa", OS_VERSION_NAME_SMARTISAN_OS};
        OS_CONDITIONS_EUI_OS = new String[]{"ro.letv.release.version", "ro.letv.release.version_date", "ro.product.letv_model", "ro.product.letv_name", "sys.letv.fmodelaid", "persist.sys.leui.bootreason", "ro.config.leui_ringtone_slot2", "ro.leui_oem_unlock_enable"};
        OS_CONDITIONS_ZUI_OS = new String[]{"ro.letv.release.version", "ro.zui.version.status", "ro.zui.hardware.displayid", "persist.radio.zui.feature", "ro.config.zuisdk.enabled"};
        if (SystemPropertyCompat.isSystemPropertyAnyOneExist(OS_CONDITIONS_HYPER_OS)) {
            sCurrentOsName = OS_NAME_HYPER_OS;
            sCurrentOriginalOsVersionName = SystemPropertyCompat.getSystemPropertyValue(OS_VERSION_NAME_HYPER_OS);
        } else if (SystemPropertyCompat.isSystemPropertyAnyOneExist(OS_CONDITIONS_MIUI)) {
            sCurrentOsName = OS_NAME_MIUI;
            sCurrentOriginalOsVersionName = SystemPropertyCompat.getSystemPropertyValue("ro.build.version.incremental");
        }
        if (sCurrentOsName == null) {
            String realmeUiVersion = SystemPropertyCompat.getSystemPropertyValue(OS_VERSION_NAME_REALME_UI);
            if (!TextUtils.isEmpty((CharSequence)realmeUiVersion)) {
                sCurrentOsName = OS_NAME_REALME_UI;
                sCurrentOriginalOsVersionName = realmeUiVersion;
            } else {
                String colorOsVersion = SystemPropertyCompat.getSystemPropertyAnyOneValue(OS_VERSION_NAME_COLOR_OS);
                if (!TextUtils.isEmpty((CharSequence)colorOsVersion)) {
                    sCurrentOsName = OS_NAME_COLOR_OS;
                    sCurrentOriginalOsVersionName = colorOsVersion;
                }
            }
        }
        if (sCurrentOsName == null && !TextUtils.isEmpty((CharSequence)(vivoOsName = SystemPropertyCompat.getSystemPropertyValue(OS_CONDITIONS_VIVO_OS)))) {
            if (vivoOsName.toLowerCase().contains("origin")) {
                sCurrentOsName = OS_NAME_ORIGIN_OS;
                sCurrentOriginalOsVersionName = SystemPropertyCompat.getSystemPropertyAnyOneValue(OS_VERSION_NAME_ORIGIN_OS);
            } else if (vivoOsName.toLowerCase().contains("funtouch")) {
                sCurrentOsName = OS_NAME_FUNTOUCH_OS;
                sCurrentOriginalOsVersionName = SystemPropertyCompat.getSystemPropertyAnyOneValue(OS_VERSION_NAME_FUNTOUCH_OS);
            }
        }
        if (sCurrentOsName == null && !TextUtils.isEmpty((CharSequence)(magicOsVersion = SystemPropertyCompat.getSystemPropertyAnyOneValue(OS_VERSION_NAME_MAGIC_OS)))) {
            sCurrentOsName = OS_NAME_MAGIC_OS;
            sCurrentOriginalOsVersionName = magicOsVersion;
        }
        if (sCurrentOsName == null) {
            try {
                Class<?> buildExClass = Class.forName("com.huawei.system.BuildEx");
                Object osBrand = buildExClass.getMethod("getOsBrand", new Class[0]).invoke(buildExClass, new Object[0]);
                if ("Harmony".equalsIgnoreCase(String.valueOf(osBrand))) {
                    sCurrentOsName = OS_NAME_HARMONY_OS;
                    sCurrentOriginalOsVersionName = SystemPropertyCompat.getSystemPropertyAnyOneValue(OS_VERSION_NAME_HARMONY_OS);
                }
            }
            catch (ClassNotFoundException buildExClass) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (sCurrentOsName == null && !TextUtils.isEmpty((CharSequence)(emuiVersion = SystemPropertyCompat.getSystemPropertyValue(OS_VERSION_NAME_EMUI)))) {
            sCurrentOsName = OS_NAME_EMUI;
            sCurrentOriginalOsVersionName = emuiVersion;
        }
        if (sCurrentOsName == null && !TextUtils.isEmpty((CharSequence)(oneUiVersion = SystemPropertyCompat.getSystemPropertyValue(OS_VERSION_NAME_ONE_UI_NEW)))) {
            sCurrentOsName = OS_NAME_ONE_UI;
            try {
                int oneUiVersionCode = Integer.parseInt(oneUiVersion);
                sCurrentOriginalOsVersionName = DeviceOs.getOneUiVersionNameByVersionCode(oneUiVersionCode);
            }
            catch (Exception e) {
                sCurrentOriginalOsVersionName = oneUiVersion;
            }
        }
        if (sCurrentOsName == null && !TextUtils.isEmpty((CharSequence)(oneUiVersion = SystemPropertyCompat.getSystemPropertyValue(OS_VERSION_NAME_ONE_UI_OLD)))) {
            sCurrentOsName = OS_NAME_ONE_UI;
            sCurrentOriginalOsVersionName = oneUiVersion;
        }
        if (sCurrentOsName == null) {
            try {
                Field semPlatformIntField = Build.VERSION.class.getDeclaredField("SEM_PLATFORM_INT");
                semPlatformIntField.setAccessible(true);
                int semPlatformVersion = semPlatformIntField.getInt(null);
                sCurrentOsName = OS_NAME_ONE_UI;
                int superfluousValue = 90000;
                if (semPlatformVersion >= superfluousValue) {
                    int oneUiVersionCode = semPlatformVersion - superfluousValue;
                    sCurrentOriginalOsVersionName = DeviceOs.getOneUiVersionNameByVersionCode(oneUiVersionCode);
                } else {
                    sCurrentOriginalOsVersionName = String.valueOf(semPlatformVersion);
                }
            }
            catch (Exception semPlatformIntField) {
                // empty catch block
            }
        }
        if (sCurrentOsName == null) {
            String oxygenOsVersion = SystemPropertyCompat.getSystemPropertyValue(OS_VERSION_NAME_OXYGEN_OS);
            if (!TextUtils.isEmpty((CharSequence)oxygenOsVersion)) {
                sCurrentOsName = OS_NAME_OXYGEN_OS;
                sCurrentOriginalOsVersionName = oxygenOsVersion;
            } else {
                String h2OsVersion = SystemPropertyCompat.getSystemPropertyValue(OS_VERSION_NAME_H2_OS);
                if (!TextUtils.isEmpty((CharSequence)h2OsVersion)) {
                    sCurrentOsName = OS_NAME_H2_OS;
                    sCurrentOriginalOsVersionName = h2OsVersion;
                }
            }
        }
        if (sCurrentOsName == null && SystemPropertyCompat.isSystemPropertyAnyOneExist(OS_CONDITIONS_FLYME)) {
            sCurrentOsName = OS_NAME_FLYME;
            sCurrentOriginalOsVersionName = SystemPropertyCompat.getSystemPropertyAnyOneValue(OS_VERSION_NAME_FLYME);
        }
        if (sCurrentOsName == null && SystemPropertyCompat.isSystemPropertyAnyOneExist(OS_CONDITIONS_ZTE_OS)) {
            String myOsVersion = SystemPropertyCompat.getSystemPropertyValue("ro.build.display.id");
            if (!TextUtils.isEmpty((CharSequence)myOsVersion) && myOsVersion.toLowerCase().contains("myos")) {
                sCurrentOsName = OS_NAME_MY_OS;
                sCurrentOriginalOsVersionName = SystemPropertyCompat.getSystemPropertyValue("ro.build.display.id");
            } else {
                sCurrentOsName = OS_NAME_MIFAVOR_UI;
                sCurrentOriginalOsVersionName = SystemPropertyCompat.getSystemPropertyValue("ro.build.MiFavor_version");
            }
        }
        if (sCurrentOsName == null && SystemPropertyCompat.isSystemPropertyAnyOneExist(OS_CONDITIONS_SMARTISAN_OS)) {
            sCurrentOsName = OS_NAME_SMARTISAN_OS;
            sCurrentOriginalOsVersionName = SystemPropertyCompat.getSystemPropertyValue(OS_VERSION_NAME_SMARTISAN_OS);
        }
        if (sCurrentOsName == null && SystemPropertyCompat.isSystemPropertyAnyOneExist(OS_CONDITIONS_EUI_OS)) {
            sCurrentOsName = OS_NAME_EUI_OS;
            sCurrentOriginalOsVersionName = SystemPropertyCompat.getSystemPropertyValue("ro.letv.release.version");
        }
        if (sCurrentOsName == null && SystemPropertyCompat.isSystemPropertyAnyOneExist(OS_CONDITIONS_ZUI_OS)) {
            sCurrentOsName = OS_NAME_ZUI_OS;
            sCurrentOriginalOsVersionName = SystemPropertyCompat.getSystemPropertyValue("ro.letv.release.version");
        }
        if (sCurrentOsName == null && !TextUtils.isEmpty((CharSequence)(osVersion = SystemPropertyCompat.getSystemPropertyValue(OS_VERSION_NAME_360_UI))) && osVersion.toLowerCase().contains("360ui")) {
            sCurrentOsName = OS_NAME_360_UI;
            sCurrentOriginalOsVersionName = osVersion;
        }
        if (TextUtils.isEmpty((CharSequence)sCurrentOsName)) {
            sCurrentOsName = "";
        }
        if (TextUtils.isEmpty((CharSequence)sCurrentOriginalOsVersionName)) {
            sCurrentOriginalOsVersionName = SystemPropertyCompat.getSystemPropertyAnyOneValue(OS_VERSION_NAME_UNKNOWN);
        }
    }
}

