/*
 * Decompiled with CFR 0.152.
 */
package com.drivemode.spotify;

import android.content.AsyncTaskLoader;
import android.content.Context;
import com.drivemode.spotify.Response;
import com.drivemode.spotify.SpotifyApi;
import com.drivemode.spotify.SpotifyService;

public abstract class SpotifyLoader<D>
extends AsyncTaskLoader<Response<D>> {
    public static final String TAG = SpotifyLoader.class.getSimpleName();
    private final SpotifyApi mApi;
    private Response<D> mCachedResponse;

    public SpotifyLoader(Context context, SpotifyApi api) {
        super(context);
        this.mApi = api;
    }

    public Response<D> loadInBackground() {
        try {
            this.mApi.blockingRefreshTokenIfNeeded();
            D data = this.call(this.mApi.getApiService());
            this.mCachedResponse = Response.ok(data);
        }
        catch (Exception ex) {
            this.mCachedResponse = Response.error(ex);
        }
        return this.mCachedResponse;
    }

    protected void onStartLoading() {
        super.onStartLoading();
        if (this.mCachedResponse != null) {
            this.deliverResult(this.mCachedResponse);
        }
        if (this.takeContentChanged() || this.mCachedResponse == null) {
            this.forceLoad();
        }
    }

    protected void onReset() {
        super.onReset();
        this.mCachedResponse = null;
    }

    public abstract D call(SpotifyService var1) throws Exception;
}

