/*
 * Decompiled with CFR 0.152.
 */
package jp.co.recruit_lifestyle.android.floatingview;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import java.lang.ref.WeakReference;
import jp.co.recruit_lifestyle.android.floatingview.TrashViewListener;

class TrashView
extends FrameLayout
implements ViewTreeObserver.OnPreDrawListener {
    private static final int BACKGROUND_HEIGHT = 164;
    private static final float TARGET_CAPTURE_HORIZONTAL_REGION = 30.0f;
    private static final float TARGET_CAPTURE_VERTICAL_REGION = 4.0f;
    private static final long TRASH_ICON_SCALE_DURATION_MILLIS = 200L;
    static final int ANIMATION_NONE = 0;
    static final int ANIMATION_OPEN = 1;
    static final int ANIMATION_CLOSE = 2;
    static final int ANIMATION_FORCE_CLOSE = 3;
    private static final int LONG_PRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
    private static final int OVERLAY_TYPE = Build.VERSION.SDK_INT <= 25 ? 2007 : 2038;
    private final WindowManager mWindowManager;
    private final WindowManager.LayoutParams mParams;
    private final DisplayMetrics mMetrics;
    private final ViewGroup mRootView;
    private final FrameLayout mTrashIconRootView;
    private final ImageView mFixedTrashIconView;
    private final ImageView mActionTrashIconView;
    private int mActionTrashIconBaseWidth;
    private int mActionTrashIconBaseHeight;
    private float mActionTrashIconMaxScale;
    private final FrameLayout mBackgroundView;
    private ObjectAnimator mEnterScaleAnimator;
    private ObjectAnimator mExitScaleAnimator;
    private final AnimationHandler mAnimationHandler;
    private TrashViewListener mTrashViewListener;
    private boolean mIsEnabled;

    TrashView(Context context) {
        super(context);
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mMetrics = new DisplayMetrics();
        this.mWindowManager.getDefaultDisplay().getMetrics(this.mMetrics);
        this.mAnimationHandler = new AnimationHandler(this);
        this.mIsEnabled = true;
        this.mParams = new WindowManager.LayoutParams();
        this.mParams.width = -1;
        this.mParams.height = -1;
        this.mParams.type = OVERLAY_TYPE;
        this.mParams.flags = 56;
        this.mParams.format = -3;
        this.mParams.gravity = 83;
        this.mRootView = new FrameLayout(context);
        this.mRootView.setClipChildren(false);
        this.mTrashIconRootView = new FrameLayout(context);
        this.mTrashIconRootView.setClipChildren(false);
        this.mFixedTrashIconView = new ImageView(context);
        this.mActionTrashIconView = new ImageView(context);
        this.mBackgroundView = new FrameLayout(context);
        this.mBackgroundView.setAlpha(0.0f);
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{0, 0x50000000});
        if (Build.VERSION.SDK_INT < 16) {
            this.mBackgroundView.setBackgroundDrawable((Drawable)gradientDrawable);
        } else {
            this.mBackgroundView.setBackground((Drawable)gradientDrawable);
        }
        FrameLayout.LayoutParams backgroundParams = new FrameLayout.LayoutParams(-1, (int)(164.0f * this.mMetrics.density));
        backgroundParams.gravity = 80;
        this.mRootView.addView((View)this.mBackgroundView, (ViewGroup.LayoutParams)backgroundParams);
        FrameLayout.LayoutParams actionTrashIconParams = new FrameLayout.LayoutParams(-2, -2);
        actionTrashIconParams.gravity = 17;
        this.mTrashIconRootView.addView((View)this.mActionTrashIconView, (ViewGroup.LayoutParams)actionTrashIconParams);
        FrameLayout.LayoutParams fixedTrashIconParams = new FrameLayout.LayoutParams(-2, -2);
        fixedTrashIconParams.gravity = 17;
        this.mTrashIconRootView.addView((View)this.mFixedTrashIconView, (ViewGroup.LayoutParams)fixedTrashIconParams);
        FrameLayout.LayoutParams trashIconParams = new FrameLayout.LayoutParams(-2, -2);
        trashIconParams.gravity = 81;
        this.mRootView.addView((View)this.mTrashIconRootView, (ViewGroup.LayoutParams)trashIconParams);
        this.addView((View)this.mRootView);
        this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateViewLayout();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateViewLayout();
    }

    public boolean onPreDraw() {
        this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        this.mTrashIconRootView.setTranslationY((float)this.mTrashIconRootView.getMeasuredHeight());
        return true;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mTrashViewListener.onUpdateActionTrashIcon();
    }

    private void updateViewLayout() {
        this.mWindowManager.getDefaultDisplay().getMetrics(this.mMetrics);
        this.mParams.x = (this.mMetrics.widthPixels - this.getWidth()) / 2;
        this.mParams.y = 0;
        this.mTrashViewListener.onUpdateActionTrashIcon();
        this.mAnimationHandler.onUpdateViewLayout();
        this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mParams);
    }

    void dismiss() {
        this.mAnimationHandler.removeMessages(1);
        this.mAnimationHandler.removeMessages(2);
        this.mAnimationHandler.sendAnimationMessage(3);
        this.setScaleTrashIconImmediately(false);
    }

    void getWindowDrawingRect(Rect outRect) {
        ImageView iconView = this.hasActionTrashIcon() ? this.mActionTrashIconView : this.mFixedTrashIconView;
        float iconPaddingLeft = iconView.getPaddingLeft();
        float iconPaddingTop = iconView.getPaddingTop();
        float iconWidth = (float)iconView.getWidth() - iconPaddingLeft - (float)iconView.getPaddingRight();
        float iconHeight = (float)iconView.getHeight() - iconPaddingTop - (float)iconView.getPaddingBottom();
        float x = this.mTrashIconRootView.getX() + iconPaddingLeft;
        float y = (float)this.mRootView.getHeight() - this.mTrashIconRootView.getY() - iconPaddingTop - iconHeight;
        int left = (int)(x - 30.0f * this.mMetrics.density);
        int top = -this.mRootView.getHeight();
        int right = (int)(x + iconWidth + 30.0f * this.mMetrics.density);
        int bottom = (int)(y + iconHeight + 4.0f * this.mMetrics.density);
        outRect.set(left, top, right, bottom);
    }

    void updateActionTrashIcon(float width, float height, float shape) {
        if (!this.hasActionTrashIcon()) {
            return;
        }
        this.mAnimationHandler.mTargetWidth = width;
        this.mAnimationHandler.mTargetHeight = height;
        float newWidthScale = width / (float)this.mActionTrashIconBaseWidth * shape;
        float newHeightScale = height / (float)this.mActionTrashIconBaseHeight * shape;
        this.mActionTrashIconMaxScale = Math.max(newWidthScale, newHeightScale);
        this.mEnterScaleAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)this.mActionTrashIconView, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)ImageView.SCALE_X, (float[])new float[]{this.mActionTrashIconMaxScale}), PropertyValuesHolder.ofFloat((Property)ImageView.SCALE_Y, (float[])new float[]{this.mActionTrashIconMaxScale})});
        this.mEnterScaleAnimator.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        this.mEnterScaleAnimator.setDuration(200L);
        this.mExitScaleAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)this.mActionTrashIconView, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)ImageView.SCALE_X, (float[])new float[]{1.0f}), PropertyValuesHolder.ofFloat((Property)ImageView.SCALE_Y, (float[])new float[]{1.0f})});
        this.mExitScaleAnimator.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        this.mExitScaleAnimator.setDuration(200L);
    }

    float getTrashIconCenterX() {
        ImageView iconView = this.hasActionTrashIcon() ? this.mActionTrashIconView : this.mFixedTrashIconView;
        float iconViewPaddingLeft = iconView.getPaddingLeft();
        float iconWidth = (float)iconView.getWidth() - iconViewPaddingLeft - (float)iconView.getPaddingRight();
        float x = this.mTrashIconRootView.getX() + iconViewPaddingLeft;
        return x + iconWidth / 2.0f;
    }

    float getTrashIconCenterY() {
        ImageView iconView = this.hasActionTrashIcon() ? this.mActionTrashIconView : this.mFixedTrashIconView;
        float iconViewHeight = iconView.getHeight();
        float iconViewPaddingBottom = iconView.getPaddingBottom();
        float iconHeight = iconViewHeight - (float)iconView.getPaddingTop() - iconViewPaddingBottom;
        float y = (float)this.mRootView.getHeight() - this.mTrashIconRootView.getY() - iconViewHeight + iconViewPaddingBottom;
        return y + iconHeight / 2.0f;
    }

    private boolean hasActionTrashIcon() {
        return this.mActionTrashIconBaseWidth != 0 && this.mActionTrashIconBaseHeight != 0;
    }

    void setFixedTrashIconImage(int resId) {
        this.mFixedTrashIconView.setImageResource(resId);
    }

    void setActionTrashIconImage(int resId) {
        this.mActionTrashIconView.setImageResource(resId);
        Drawable drawable = this.mActionTrashIconView.getDrawable();
        if (drawable != null) {
            this.mActionTrashIconBaseWidth = drawable.getIntrinsicWidth();
            this.mActionTrashIconBaseHeight = drawable.getIntrinsicHeight();
        }
    }

    void setFixedTrashIconImage(Drawable drawable) {
        this.mFixedTrashIconView.setImageDrawable(drawable);
    }

    void setActionTrashIconImage(Drawable drawable) {
        this.mActionTrashIconView.setImageDrawable(drawable);
        if (drawable != null) {
            this.mActionTrashIconBaseWidth = drawable.getIntrinsicWidth();
            this.mActionTrashIconBaseHeight = drawable.getIntrinsicHeight();
        }
    }

    private void setScaleTrashIconImmediately(boolean isEnter) {
        this.cancelScaleTrashAnimation();
        this.mActionTrashIconView.setScaleX(isEnter ? this.mActionTrashIconMaxScale : 1.0f);
        this.mActionTrashIconView.setScaleY(isEnter ? this.mActionTrashIconMaxScale : 1.0f);
    }

    void setScaleTrashIcon(boolean isEnter) {
        if (!this.hasActionTrashIcon()) {
            return;
        }
        this.cancelScaleTrashAnimation();
        if (isEnter) {
            this.mEnterScaleAnimator.start();
        } else {
            this.mExitScaleAnimator.start();
        }
    }

    void setTrashEnabled(boolean enabled) {
        if (this.mIsEnabled == enabled) {
            return;
        }
        this.mIsEnabled = enabled;
        if (!this.mIsEnabled) {
            this.dismiss();
        }
    }

    boolean isTrashEnabled() {
        return this.mIsEnabled;
    }

    private void cancelScaleTrashAnimation() {
        if (this.mEnterScaleAnimator != null && this.mEnterScaleAnimator.isStarted()) {
            this.mEnterScaleAnimator.cancel();
        }
        if (this.mExitScaleAnimator != null && this.mExitScaleAnimator.isStarted()) {
            this.mExitScaleAnimator.cancel();
        }
    }

    void setTrashViewListener(TrashViewListener listener) {
        this.mTrashViewListener = listener;
    }

    WindowManager.LayoutParams getWindowLayoutParams() {
        return this.mParams;
    }

    void onTouchFloatingView(MotionEvent event, float x, float y) {
        int action = event.getAction();
        if (action == 0) {
            this.mAnimationHandler.updateTargetPosition(x, y);
            this.mAnimationHandler.removeMessages(2);
            this.mAnimationHandler.sendAnimationMessageDelayed(1, LONG_PRESS_TIMEOUT);
        } else if (action == 2) {
            this.mAnimationHandler.updateTargetPosition(x, y);
            if (!this.mAnimationHandler.isAnimationStarted(1)) {
                this.mAnimationHandler.removeMessages(1);
                this.mAnimationHandler.sendAnimationMessage(1);
            }
        } else if (action == 1 || action == 3) {
            this.mAnimationHandler.removeMessages(1);
            this.mAnimationHandler.sendAnimationMessage(2);
        }
    }

    static class AnimationHandler
    extends Handler {
        private static final long ANIMATION_REFRESH_TIME_MILLIS = 17L;
        private static final long BACKGROUND_DURATION_MILLIS = 200L;
        private static final long TRASH_OPEN_START_DELAY_MILLIS = 200L;
        private static final long TRASH_OPEN_DURATION_MILLIS = 400L;
        private static final long TRASH_CLOSE_DURATION_MILLIS = 200L;
        private static final float OVERSHOOT_TENSION = 1.0f;
        private static final int TRASH_MOVE_LIMIT_OFFSET_X = 22;
        private static final int TRASH_MOVE_LIMIT_TOP_OFFSET = -4;
        private static final int TYPE_FIRST = 1;
        private static final int TYPE_UPDATE = 2;
        private static final float MAX_ALPHA = 1.0f;
        private static final float MIN_ALPHA = 0.0f;
        private long mStartTime;
        private float mStartAlpha;
        private float mStartTransitionY;
        private int mStartedCode;
        private float mTargetPositionX;
        private float mTargetPositionY;
        private float mTargetWidth;
        private float mTargetHeight;
        private final Rect mTrashIconLimitPosition;
        private float mMoveStickyYRange;
        private final OvershootInterpolator mOvershootInterpolator;
        private final WeakReference<TrashView> mTrashView;

        AnimationHandler(TrashView trashView) {
            this.mTrashView = new WeakReference<TrashView>(trashView);
            this.mStartedCode = 0;
            this.mTrashIconLimitPosition = new Rect();
            this.mOvershootInterpolator = new OvershootInterpolator(1.0f);
        }

        public void handleMessage(Message msg) {
            TrashView trashView = (TrashView)((Object)this.mTrashView.get());
            if (trashView == null) {
                this.removeMessages(1);
                this.removeMessages(2);
                this.removeMessages(3);
                return;
            }
            if (!trashView.isTrashEnabled()) {
                return;
            }
            int animationCode = msg.what;
            int animationType = msg.arg1;
            FrameLayout backgroundView = trashView.mBackgroundView;
            FrameLayout trashIconRootView = trashView.mTrashIconRootView;
            TrashViewListener listener = trashView.mTrashViewListener;
            float screenWidth = ((TrashView)trashView).mMetrics.widthPixels;
            float trashViewX = ((TrashView)trashView).mParams.x;
            if (animationType == 1) {
                this.mStartTime = SystemClock.uptimeMillis();
                this.mStartAlpha = backgroundView.getAlpha();
                this.mStartTransitionY = trashIconRootView.getTranslationY();
                this.mStartedCode = animationCode;
                if (listener != null) {
                    listener.onTrashAnimationStarted(this.mStartedCode);
                }
            }
            float elapsedTime = SystemClock.uptimeMillis() - this.mStartTime;
            if (animationCode == 1) {
                float currentAlpha = backgroundView.getAlpha();
                if (currentAlpha < 1.0f) {
                    float alphaTimeRate = Math.min(elapsedTime / 200.0f, 1.0f);
                    float alpha = Math.min(this.mStartAlpha + alphaTimeRate, 1.0f);
                    backgroundView.setAlpha(alpha);
                }
                if (elapsedTime >= 200.0f) {
                    float screenHeight = ((TrashView)trashView).mMetrics.heightPixels;
                    float positionX = trashViewX + (this.mTargetPositionX + this.mTargetWidth) / (screenWidth + this.mTargetWidth) * (float)this.mTrashIconLimitPosition.width() + (float)this.mTrashIconLimitPosition.left;
                    float targetPositionYRate = Math.min(2.0f * (this.mTargetPositionY + this.mTargetHeight) / (screenHeight + this.mTargetHeight), 1.0f);
                    float stickyPositionY = this.mMoveStickyYRange * targetPositionYRate + (float)this.mTrashIconLimitPosition.height() - this.mMoveStickyYRange;
                    float translationYTimeRate = Math.min((elapsedTime - 200.0f) / 400.0f, 1.0f);
                    float positionY = (float)this.mTrashIconLimitPosition.bottom - stickyPositionY * this.mOvershootInterpolator.getInterpolation(translationYTimeRate);
                    trashIconRootView.setTranslationX(positionX);
                    trashIconRootView.setTranslationY(positionY);
                    if (Build.VERSION.SDK_INT <= 17) {
                        AnimationHandler.clearClippedChildren(trashView.mRootView);
                        AnimationHandler.clearClippedChildren((ViewGroup)trashView.mTrashIconRootView);
                    }
                }
                this.sendMessageAtTime(AnimationHandler.newMessage(animationCode, 2), SystemClock.uptimeMillis() + 17L);
            } else if (animationCode == 2) {
                float alphaElapseTimeRate = Math.min(elapsedTime / 200.0f, 1.0f);
                float alpha = Math.max(this.mStartAlpha - alphaElapseTimeRate, 0.0f);
                backgroundView.setAlpha(alpha);
                float translationYTimeRate = Math.min(elapsedTime / 200.0f, 1.0f);
                if (alphaElapseTimeRate < 1.0f || translationYTimeRate < 1.0f) {
                    float position = this.mStartTransitionY + (float)this.mTrashIconLimitPosition.height() * translationYTimeRate;
                    trashIconRootView.setTranslationY(position);
                    this.sendMessageAtTime(AnimationHandler.newMessage(animationCode, 2), SystemClock.uptimeMillis() + 17L);
                } else {
                    trashIconRootView.setTranslationY((float)this.mTrashIconLimitPosition.bottom);
                    this.mStartedCode = 0;
                    if (listener != null) {
                        listener.onTrashAnimationEnd(2);
                    }
                }
            } else if (animationCode == 3) {
                backgroundView.setAlpha(0.0f);
                trashIconRootView.setTranslationY((float)this.mTrashIconLimitPosition.bottom);
                this.mStartedCode = 0;
                if (listener != null) {
                    listener.onTrashAnimationEnd(3);
                }
            }
        }

        private static void clearClippedChildren(ViewGroup viewGroup) {
            viewGroup.setClipChildren(true);
            viewGroup.invalidate();
            viewGroup.setClipChildren(false);
        }

        void sendAnimationMessageDelayed(int animation, long delayMillis) {
            this.sendMessageAtTime(AnimationHandler.newMessage(animation, 1), SystemClock.uptimeMillis() + delayMillis);
        }

        void sendAnimationMessage(int animation) {
            this.sendMessage(AnimationHandler.newMessage(animation, 1));
        }

        private static Message newMessage(int animation, int type) {
            Message message = Message.obtain();
            message.what = animation;
            message.arg1 = type;
            return message;
        }

        boolean isAnimationStarted(int animationCode) {
            return this.mStartedCode == animationCode;
        }

        void updateTargetPosition(float x, float y) {
            this.mTargetPositionX = x;
            this.mTargetPositionY = y;
        }

        void onUpdateViewLayout() {
            TrashView trashView = (TrashView)((Object)this.mTrashView.get());
            if (trashView == null) {
                return;
            }
            float density = ((TrashView)trashView).mMetrics.density;
            float backgroundHeight = trashView.mBackgroundView.getMeasuredHeight();
            float offsetX = 22.0f * density;
            int trashIconHeight = trashView.mTrashIconRootView.getMeasuredHeight();
            int left = (int)(-offsetX);
            int top = (int)(((float)trashIconHeight - backgroundHeight) / 2.0f - -4.0f * density);
            int right = (int)offsetX;
            int bottom = trashIconHeight;
            this.mTrashIconLimitPosition.set(left, top, right, bottom);
            this.mMoveStickyYRange = backgroundHeight * 0.2f;
        }
    }
}

