/*
 * Decompiled with CFR 0.152.
 */
package jp.co.recruit_lifestyle.android.floatingview;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import jp.co.recruit_lifestyle.android.floatingview.FloatingView;
import jp.co.recruit_lifestyle.android.floatingview.FloatingViewListener;
import jp.co.recruit_lifestyle.android.floatingview.FullscreenObserverView;
import jp.co.recruit_lifestyle.android.floatingview.ScreenChangedListener;
import jp.co.recruit_lifestyle.android.floatingview.TrashView;
import jp.co.recruit_lifestyle.android.floatingview.TrashViewListener;

public class FloatingViewManager
implements ScreenChangedListener,
View.OnTouchListener,
TrashViewListener {
    public static final int DISPLAY_MODE_SHOW_ALWAYS = 1;
    public static final int DISPLAY_MODE_HIDE_ALWAYS = 2;
    public static final int DISPLAY_MODE_HIDE_FULLSCREEN = 3;
    public static final int MOVE_DIRECTION_DEFAULT = 0;
    public static final int MOVE_DIRECTION_LEFT = 1;
    public static final int MOVE_DIRECTION_RIGHT = 2;
    public static final int MOVE_DIRECTION_NONE = 3;
    public static final int MOVE_DIRECTION_NEAREST = 4;
    public static final int MOVE_DIRECTION_THROWN = 5;
    public static final float SHAPE_CIRCLE = 1.0f;
    public static final float SHAPE_RECTANGLE = 1.4142f;
    private final Context mContext;
    private final Resources mResources;
    private final WindowManager mWindowManager;
    private final DisplayMetrics mDisplayMetrics;
    private FloatingView mTargetFloatingView;
    private final FullscreenObserverView mFullscreenObserverView;
    private final TrashView mTrashView;
    private final FloatingViewListener mFloatingViewListener;
    private final Rect mFloatingViewRect;
    private final Rect mTrashViewRect;
    private boolean mIsMoveAccept;
    private int mDisplayMode;
    private final ArrayList<FloatingView> mFloatingViewList;

    public FloatingViewManager(Context context, FloatingViewListener listener) {
        this.mContext = context;
        this.mResources = context.getResources();
        this.mWindowManager = (WindowManager)context.getApplicationContext().getSystemService("window");
        this.mDisplayMetrics = new DisplayMetrics();
        this.mFloatingViewListener = listener;
        this.mFloatingViewRect = new Rect();
        this.mTrashViewRect = new Rect();
        this.mIsMoveAccept = false;
        this.mDisplayMode = 3;
        this.mFloatingViewList = new ArrayList();
        this.mFullscreenObserverView = new FullscreenObserverView(context, this);
        this.mTrashView = new TrashView(context);
    }

    private boolean isIntersectWithTrash() {
        if (!this.mTrashView.isTrashEnabled()) {
            return false;
        }
        this.mTrashView.getWindowDrawingRect(this.mTrashViewRect);
        this.mTargetFloatingView.getWindowDrawingRect(this.mFloatingViewRect);
        return Rect.intersects((Rect)this.mTrashViewRect, (Rect)this.mFloatingViewRect);
    }

    public FloatingView getTargetFloatingView() {
        return this.mTargetFloatingView;
    }

    @Override
    public void onScreenChanged(Rect windowRect, int visibility) {
        boolean isHideNavigationBar;
        boolean isFitSystemWindowTop;
        boolean bl = isFitSystemWindowTop = windowRect.top == 0;
        boolean isHideStatusBar = Build.VERSION.SDK_INT <= 15 && visibility != -1 ? isFitSystemWindowTop || (visibility & 1) == 1 : isFitSystemWindowTop;
        if (visibility == -1) {
            this.mWindowManager.getDefaultDisplay().getMetrics(this.mDisplayMetrics);
            isHideNavigationBar = windowRect.width() - this.mDisplayMetrics.widthPixels > 0 || windowRect.height() - this.mDisplayMetrics.heightPixels > 0;
        } else {
            isHideNavigationBar = (visibility & 2) == 2;
        }
        boolean isPortrait = this.mResources.getConfiguration().orientation == 1;
        this.mTargetFloatingView.onUpdateSystemLayout(isHideStatusBar, isHideNavigationBar, isPortrait);
        if (this.mDisplayMode != 3) {
            return;
        }
        this.mIsMoveAccept = false;
        int state = this.mTargetFloatingView.getState();
        if (state == 0) {
            int size = this.mFloatingViewList.size();
            for (int i = 0; i < size; ++i) {
                FloatingView floatingView = this.mFloatingViewList.get(i);
                floatingView.setVisibility(isFitSystemWindowTop ? 8 : 0);
            }
            this.mTrashView.dismiss();
        } else if (state == 1) {
            this.mTargetFloatingView.setFinishing();
            this.mTrashView.dismiss();
        }
    }

    @Override
    public void onUpdateActionTrashIcon() {
        this.mTrashView.updateActionTrashIcon(this.mTargetFloatingView.getMeasuredWidth(), this.mTargetFloatingView.getMeasuredHeight(), this.mTargetFloatingView.getShape());
    }

    @Override
    public void onTrashAnimationStarted(int animationCode) {
        if (animationCode == 2 || animationCode == 3) {
            int size = this.mFloatingViewList.size();
            for (int i = 0; i < size; ++i) {
                FloatingView floatingView = this.mFloatingViewList.get(i);
                floatingView.setDraggable(false);
            }
        }
    }

    @Override
    public void onTrashAnimationEnd(int animationCode) {
        int state = this.mTargetFloatingView.getState();
        if (state == 2) {
            this.removeViewToWindow(this.mTargetFloatingView);
        }
        int size = this.mFloatingViewList.size();
        for (int i = 0; i < size; ++i) {
            FloatingView floatingView = this.mFloatingViewList.get(i);
            floatingView.setDraggable(true);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        int action = event.getAction();
        if (action != 0 && !this.mIsMoveAccept) {
            return false;
        }
        int state = this.mTargetFloatingView.getState();
        this.mTargetFloatingView = (FloatingView)v;
        if (action == 0) {
            this.mIsMoveAccept = true;
        } else if (action == 2) {
            boolean isIntersect;
            boolean isIntersecting = this.isIntersectWithTrash();
            boolean bl = isIntersect = state == 1;
            if (isIntersecting) {
                this.mTargetFloatingView.setIntersecting((int)this.mTrashView.getTrashIconCenterX(), (int)this.mTrashView.getTrashIconCenterY());
            }
            if (isIntersecting && !isIntersect) {
                this.mTargetFloatingView.performHapticFeedback(0);
                this.mTrashView.setScaleTrashIcon(true);
            } else if (!isIntersecting && isIntersect) {
                this.mTargetFloatingView.setNormal();
                this.mTrashView.setScaleTrashIcon(false);
            }
        } else if (action == 1 || action == 3) {
            if (state == 1) {
                this.mTargetFloatingView.setFinishing();
                this.mTrashView.setScaleTrashIcon(false);
            }
            this.mIsMoveAccept = false;
            if (this.mFloatingViewListener != null) {
                boolean isFinishing = this.mTargetFloatingView.getState() == 2;
                WindowManager.LayoutParams params = this.mTargetFloatingView.getWindowLayoutParams();
                this.mFloatingViewListener.onTouchFinished(isFinishing, params.x, params.y);
            }
        }
        if (state == 1) {
            this.mTrashView.onTouchFloatingView(event, this.mFloatingViewRect.left, this.mFloatingViewRect.top);
        } else {
            WindowManager.LayoutParams params = this.mTargetFloatingView.getWindowLayoutParams();
            this.mTrashView.onTouchFloatingView(event, params.x, params.y);
        }
        return false;
    }

    public void setFixedTrashIconImage(@DrawableRes int resId) {
        this.mTrashView.setFixedTrashIconImage(resId);
    }

    public void setActionTrashIconImage(@DrawableRes int resId) {
        this.mTrashView.setActionTrashIconImage(resId);
    }

    public void setFixedTrashIconImage(Drawable drawable) {
        this.mTrashView.setFixedTrashIconImage(drawable);
    }

    public void setActionTrashIconImage(Drawable drawable) {
        this.mTrashView.setActionTrashIconImage(drawable);
    }

    public void setDisplayMode(int displayMode) {
        this.mDisplayMode = displayMode;
        if (this.mDisplayMode == 1 || this.mDisplayMode == 3) {
            for (FloatingView floatingView : this.mFloatingViewList) {
                floatingView.setVisibility(0);
            }
        } else if (this.mDisplayMode == 2) {
            for (FloatingView floatingView : this.mFloatingViewList) {
                floatingView.setVisibility(8);
            }
            this.mTrashView.dismiss();
        }
    }

    public void setTrashViewEnabled(boolean enabled) {
        this.mTrashView.setTrashEnabled(enabled);
    }

    public boolean isTrashViewEnabled() {
        return this.mTrashView.isTrashEnabled();
    }

    public void addViewToWindow(View view, Options options) {
        boolean isFirstAttach = this.mFloatingViewList.isEmpty();
        FloatingView floatingView = new FloatingView(this.mContext);
        floatingView.setInitCoords(options.floatingViewX, options.floatingViewY);
        floatingView.setOnTouchListener(this);
        floatingView.setShape(options.shape);
        floatingView.setOverMargin(options.overMargin);
        floatingView.setMoveDirection(options.moveDirection);
        floatingView.usePhysics(options.usePhysics);
        floatingView.setAnimateInitialMove(options.animateInitialMove);
        FrameLayout.LayoutParams targetParams = new FrameLayout.LayoutParams(options.floatingViewWidth, options.floatingViewHeight);
        view.setLayoutParams((ViewGroup.LayoutParams)targetParams);
        floatingView.addView(view);
        if (this.mDisplayMode == 2) {
            floatingView.setVisibility(8);
        }
        this.mFloatingViewList.add(floatingView);
        this.mTrashView.setTrashViewListener(this);
        this.mWindowManager.addView((View)floatingView, (ViewGroup.LayoutParams)floatingView.getWindowLayoutParams());
        if (isFirstAttach) {
            this.mWindowManager.addView((View)this.mFullscreenObserverView, (ViewGroup.LayoutParams)this.mFullscreenObserverView.getWindowLayoutParams());
            this.mTargetFloatingView = floatingView;
        } else {
            this.mWindowManager.removeViewImmediate((View)this.mTrashView);
        }
        this.mWindowManager.addView((View)this.mTrashView, (ViewGroup.LayoutParams)this.mTrashView.getWindowLayoutParams());
    }

    private void removeViewToWindow(FloatingView floatingView) {
        int matchIndex = this.mFloatingViewList.indexOf((Object)floatingView);
        if (matchIndex != -1) {
            this.mWindowManager.removeViewImmediate((View)floatingView);
            this.mFloatingViewList.remove(matchIndex);
        }
        if (this.mFloatingViewList.isEmpty() && this.mFloatingViewListener != null) {
            this.mFloatingViewListener.onFinishFloatingView();
        }
    }

    public void removeAllViewToWindow() {
        this.mWindowManager.removeViewImmediate((View)this.mFullscreenObserverView);
        this.mWindowManager.removeViewImmediate((View)this.mTrashView);
        int size = this.mFloatingViewList.size();
        for (int i = 0; i < size; ++i) {
            FloatingView floatingView = this.mFloatingViewList.get(i);
            this.mWindowManager.removeViewImmediate((View)floatingView);
        }
        this.mFloatingViewList.clear();
    }

    public static class Options {
        public float shape = 1.0f;
        public int overMargin = 0;
        public int floatingViewX = Integer.MIN_VALUE;
        public int floatingViewY = Integer.MIN_VALUE;
        public int floatingViewWidth = -2;
        public int floatingViewHeight = -2;
        public int moveDirection = 0;
        public boolean usePhysics;
        public boolean animateInitialMove = true;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MoveDirection {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisplayMode {
    }
}

