/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet.printer;

import info.leadinglight.umljavadoclet.model.Model;
import info.leadinglight.umljavadoclet.model.ModelClass;
import info.leadinglight.umljavadoclet.model.ModelPackage;
import info.leadinglight.umljavadoclet.model.ModelRel;
import info.leadinglight.umljavadoclet.printer.DiagramOptions;
import info.leadinglight.umljavadoclet.printer.PumlDiagramPrinter;

public class PackageDiagramPrinter
extends PumlDiagramPrinter {
    private final ModelPackage _modelPackage;

    public PackageDiagramPrinter(Model model, ModelPackage modelPackage, DiagramOptions options) {
        super(model, options);
        this._modelPackage = modelPackage;
    }

    public void generate() {
        this.start();
        if (this.getOptions().getPackageOrientation() == DiagramOptions.Orientation.LEFT_TO_RIGHT) {
            this.leftToRight();
        }
        this.addPackage(this._modelPackage, "lightyellow");
        this.addRelationships(this._modelPackage);
        for (ModelPackage subPackage : this.getModel().childPackages(this._modelPackage)) {
            this.addPackage(subPackage, null);
        }
        this.end();
    }

    public void addPackage(ModelPackage modelPackage, String color) {
        String filepath = this.packageFilepath(this._modelPackage, modelPackage);
        this.packageDefinition(modelPackage, filepath, color);
        for (ModelClass modelClass : modelPackage.classes()) {
            filepath = this.classFilepath(this._modelPackage, modelClass);
            this.classDefinitionNoDetail(modelClass, false, filepath, null);
        }
    }

    public void addRelationships(ModelPackage modelPackage) {
        for (ModelClass modelClass : modelPackage.classes()) {
            for (ModelRel rel : modelClass.relationships()) {
                if (rel.source() != modelClass || rel.destination().modelPackage() != modelPackage) continue;
                this.relationship(rel);
            }
        }
    }
}

