/*
 * Decompiled with CFR 0.152.
 */
package info.leadinglight.umljavadoclet.model;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import info.leadinglight.umljavadoclet.model.ModelClass;
import info.leadinglight.umljavadoclet.model.ModelPackage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Model {
    private final RootDoc _rootDoc;
    private final Map<String, ModelClass> _classes = new LinkedHashMap<String, ModelClass>();
    private final Map<String, ModelPackage> _packages = new LinkedHashMap<String, ModelPackage>();

    public Model(RootDoc rootDoc) {
        this._rootDoc = rootDoc;
    }

    public void map() {
        this.mapClasses();
        this.mapRelationships();
        this.createPackages();
        this.mapPackages();
    }

    public List<ModelClass> classes() {
        return new ArrayList<ModelClass>(this._classes.values());
    }

    public List<ModelClass> internalClasses() {
        ArrayList<ModelClass> internalClasses = new ArrayList<ModelClass>();
        for (ModelClass modelClass : this.classes()) {
            if (!modelClass.isInternal()) continue;
            internalClasses.add(modelClass);
        }
        return internalClasses;
    }

    public ModelClass modelClass(String fullName) {
        return this._classes.get(fullName);
    }

    public List<ModelPackage> packages() {
        return new ArrayList<ModelPackage>(this._packages.values());
    }

    public ModelPackage modelPackage(String fullName) {
        return this._packages.get(fullName);
    }

    public ModelPackage parentPackage(ModelPackage childPackage) {
        String parentPackageName = childPackage.parentPackageFullName();
        if (parentPackageName != null) {
            return this.modelPackage(parentPackageName);
        }
        return null;
    }

    public List<ModelPackage> childPackages(ModelPackage parentPackage) {
        ArrayList<ModelPackage> childPackages = new ArrayList<ModelPackage>();
        for (ModelPackage modelPackage : this.packages()) {
            if (!modelPackage.isChildPackage(parentPackage)) continue;
            childPackages.add(modelPackage);
        }
        return childPackages;
    }

    public List<ModelPackage> rootPackages() {
        ArrayList<ModelPackage> rootPackages = new ArrayList<ModelPackage>();
        for (ModelPackage modelPackage : this.packages()) {
            if (!this.isRootPackage(modelPackage)) continue;
            rootPackages.add(modelPackage);
        }
        return rootPackages;
    }

    public boolean isRootPackage(ModelPackage modelPackage) {
        for (String parentName = modelPackage.parentPackageFullName(); parentName != null; parentName = parentName.substring(0, parentName.lastIndexOf("."))) {
            if (this.modelPackage(parentName) != null) {
                return false;
            }
            if (parentName.lastIndexOf(".") != -1) continue;
            return true;
        }
        return false;
    }

    public ModelClass createClassIfNotExists(Type classType) {
        String fullName = ModelClass.fullName(classType);
        ModelClass modelClass = this._classes.get(fullName);
        if (modelClass == null) {
            modelClass = new ModelClass(this, classType, false);
            modelClass.map();
            this._classes.put(fullName, modelClass);
        }
        return modelClass;
    }

    private void mapClasses() {
        for (ClassDoc classDoc : this._rootDoc.classes()) {
            ModelClass modelClass = new ModelClass(this, (Type)classDoc, true);
            String fullName = ModelClass.fullName((Type)classDoc);
            this._classes.put(fullName, modelClass);
        }
    }

    private void mapRelationships() {
        for (ClassDoc classDoc : this._rootDoc.classes()) {
            String fullName = ModelClass.fullName((Type)classDoc);
            ModelClass modelClass = this._classes.get(fullName);
            modelClass.map();
        }
    }

    private void createPackages() {
        for (ClassDoc classDoc : this._rootDoc.classes()) {
            PackageDoc packageDoc = classDoc.containingPackage();
            String fullName = ModelPackage.fullName(packageDoc);
            ModelPackage modelPackage = this._packages.get(fullName);
            if (modelPackage == null) {
                modelPackage = new ModelPackage(this, packageDoc);
                this._packages.put(fullName, modelPackage);
            }
            String classFullName = ModelClass.fullName((Type)classDoc);
            ModelClass modelClass = this._classes.get(classFullName);
            modelPackage.addClass(modelClass);
        }
    }

    public void mapPackages() {
        for (ModelPackage modelPackage : this._packages.values()) {
            modelPackage.map();
        }
    }
}

