/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import parser.CustomScanner;
import parser.MathExpression;
import parser.Operator;
import parser.Variable;
import util.FunctionManager;
import util.Utils;

public class VariableManager {
    public static final String endOfLine = ";";
    public static final Map<String, Variable> VARIABLES = Collections.synchronizedMap(new HashMap());
    private CommandInterpreter commandParser;

    public VariableManager() {
        VARIABLES.put(Variable.PI.getName(), Variable.PI);
        VARIABLES.put(Variable.ans.getName(), Variable.ans);
        VARIABLES.put(Variable.e.getName(), Variable.e);
        this.commandParser = new CommandInterpreter();
    }

    public CommandInterpreter getCommandParser() {
        return this.commandParser;
    }

    public void setCommandParser(CommandInterpreter commandParser) {
        this.commandParser = commandParser;
    }

    public static String getEndOfLine() {
        return endOfLine;
    }

    public Map<String, Variable> getVarStore() {
        return VARIABLES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(Collection<Variable> variables) {
        Map<String, Variable> map = VARIABLES;
        synchronized (map) {
            for (Variable v : variables) {
                VARIABLES.put(v.getName(), v);
            }
        }
    }

    public static void load(Map<String, Variable> variables) {
        VariableManager.load(variables, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(Map<String, Variable> variables, boolean clearFirst) {
        Map<String, Variable> map = VARIABLES;
        synchronized (map) {
            if (clearFirst) {
                VARIABLES.clear();
            }
            VARIABLES.putAll(variables);
        }
    }

    public boolean contains(String variableName) {
        return VARIABLES.get(variableName) != null;
    }

    public Variable parseSingleCommand(String cmd) {
        String var;
        int indexOfSemiColon = cmd.indexOf(endOfLine);
        if (indexOfSemiColon == -1) {
            return null;
        }
        int indexOfEqual = cmd.indexOf("=");
        if (indexOfEqual != -1 && Variable.isVariableString(var = cmd.substring(0, indexOfEqual))) {
            if (FunctionManager.contains(var)) {
                FunctionManager.delete(var);
            }
            try {
                String value = new MathExpression(cmd.substring(indexOfEqual + 1)).solve();
                Variable vv = new Variable(var, value, false);
                VARIABLES.put(vv.getName(), vv);
                VariableManager.update();
                return vv;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void parseCommand(String cmd) {
        if (this.commandParser == null) {
            this.commandParser = new CommandInterpreter(cmd);
        } else {
            this.commandParser.setCommand(cmd);
        }
        VariableManager.update();
    }

    public static void update() {
    }

    public static void init() {
    }

    public static Variable getVariable(String vName) {
        return VARIABLES.get(vName);
    }

    public static Variable lookUp(String vName) {
        return VariableManager.getVariable(vName);
    }

    public static void delete(String varName) {
        VARIABLES.remove(varName);
        VariableManager.update();
    }

    public static void add(Variable var) {
        if (var != null && !var.isConstant() && !VARIABLES.containsKey(var.getName())) {
            VARIABLES.put(var.getName(), var);
            VariableManager.update();
        }
    }

    public static void add(Variable ... vars) {
        for (Variable v : vars) {
            if (v == null || v.isConstant() || VARIABLES.containsKey(v.getName())) continue;
            VARIABLES.put(v.getName(), v);
        }
        VariableManager.update();
    }

    public static void clearVariables() {
        Iterator<Map.Entry<String, Variable>> it = VARIABLES.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Variable> var = it.next();
            if (var.getValue().isConstant()) continue;
            it.remove();
        }
        VariableManager.update();
    }

    public void clearConstants() {
        Iterator<Map.Entry<String, Variable>> it = VARIABLES.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Variable> var = it.next();
            if (!var.getValue().isConstant()) continue;
            it.remove();
        }
        VariableManager.update();
    }

    public void clearVariablesAndConstants() {
        VARIABLES.clear();
    }

    public static String generateCommandStringFromVariableNamesArray(String[] variableNames) {
        String cmd = "";
        for (String var : variableNames) {
            cmd = cmd.concat(var.concat("=0.0".concat(endOfLine)));
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ArrayList<Variable> getVariables() {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Collection<Variable> vars = VARIABLES.values();
        Map<String, Variable> map = VARIABLES;
        synchronized (map) {
            for (Variable v : vars) {
                if (v == null || v.isConstant()) continue;
                variables.add(v);
            }
        }
        return variables;
    }

    public String toString() {
        return "All Variables = " + VARIABLES;
    }

    public static void main(String[] args) {
        String cmd = "a,b,c,d,e=20.213;const a1=a; a2=6/(9-5.12424a);a=98.90;const t=a+1/2;b12=sin(a+b)/cos(a+b);c1=1/c1;";
        VariableManager manager = new VariableManager();
        manager.parseCommand(cmd);
        System.out.println(" varStore = " + VARIABLES);
        int i = 0;
        try {
            while (true) {
                System.out.println(" Enter Command " + (i + 1));
                String comd = new Scanner(System.in).nextLine();
                manager.parseCommand(comd);
                System.out.println(" varStore = " + VARIABLES);
                ++i;
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public class CommandInterpreter {
        private String command;
        private boolean valid;

        public CommandInterpreter() {
        }

        public CommandInterpreter(String command) {
            this.setCommand(command);
        }

        public void setCommand(String command) {
            this.command = command.trim();
            this.valid = true;
            this.parse();
        }

        public String getCommand() {
            return this.command;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public boolean isValid() {
            return this.valid;
        }

        private String getValue(String expr) throws NullPointerException, InputMismatchException {
            MathExpression func = new MathExpression(expr);
            func.setVariableValuesInFunction(func.getScanner());
            func.setDRG(1);
            return func.solve();
        }

        private List<String> generateLines() {
            CustomScanner customScanner = new CustomScanner(this.command, false, VariableManager.endOfLine);
            List<String> lines = customScanner.scan();
            if (this.command.length() == 0) {
                Utils.logError("No Command Input!");
                this.setValid(false);
            } else {
                if (this.command.length() > 0 && this.command.indexOf(VariableManager.endOfLine) == -1) {
                    Utils.logError("End variable initialization or assignment statements with a ;..\";\"");
                    this.setValid(false);
                }
                if (!this.command.endsWith(VariableManager.endOfLine)) {
                    Utils.logError("End variable initialization or assignment statements with a ;..\";\"");
                    this.setValid(false);
                }
            }
            return lines;
        }

        private boolean isConstant(String name) {
            Variable v = VARIABLES.get(name);
            return v == null ? false : v.isConstant();
        }

        private boolean isVariable(String name) {
            Variable v = VARIABLES.get(name);
            return v == null ? false : !v.isConstant();
        }

        private boolean validateLine(String line) {
            int lastInd;
            int ind = line.indexOf("=");
            if (ind == (lastInd = line.lastIndexOf("=")) && this.valid && ind != -1) {
                String part1 = line.substring(0, ind);
                String part2 = line.substring(ind + 1);
                CustomScanner customScanner = new CustomScanner(part1, true, ",", " ");
                List<String> scan = customScanner.scan();
                ArrayList<String> whitespaceremover = new ArrayList<String>();
                whitespaceremover.add(" ");
                scan.removeAll(whitespaceremover);
                int sz = scan.size();
                if (sz == 1) {
                    return Variable.isVariableString(scan.get(0));
                }
                if (sz > 1) {
                    for (int i = 0; i < sz; ++i) {
                        try {
                            if (Variable.isVariableString(scan.get(i)) && !Operator.isComma(scan.get(i + 1)) || !Variable.isVariableString(scan.get(i)) && Operator.isComma(scan.get(i + 1))) {
                                return false;
                            }
                            if (Operator.isComma(scan.get(i)) && !Variable.isVariableString(scan.get(i + 1)) || !Operator.isComma(scan.get(i)) && Variable.isVariableString(scan.get(i + 1))) {
                                return false;
                            }
                            if (Operator.isComma(scan.get(i)) || Variable.isVariableString(scan.get(i))) continue;
                            return false;
                        }
                        catch (IndexOutOfBoundsException boundsException) {
                            break;
                        }
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        private void analyzeLine(String line) {
            block19: {
                this.setValid(this.validateLine(line));
                if (this.isValid()) {
                    int lastInd;
                    int ind = line.indexOf("=");
                    if (ind == (lastInd = line.lastIndexOf("=")) && this.valid && ind != -1) {
                        String part1 = line.substring(0, ind);
                        String part2 = line.substring(ind + 1);
                        CustomScanner customScanner = new CustomScanner(part1, false, ",", " ");
                        List<String> scan = customScanner.scan();
                        ArrayList<String> whitespaceremover = new ArrayList<String>();
                        whitespaceremover.add(" ");
                        whitespaceremover.add(",");
                        scan.removeAll(whitespaceremover);
                        int sz = scan.size();
                        try {
                            if (!Variable.isVariableString(scan.get(0))) break block19;
                            if (sz > 1) {
                                for (int i = 0; i < sz && this.valid; ++i) {
                                    if (Variable.isVariableString(scan.get(i))) {
                                        try {
                                            boolean variable = this.isVariable(scan.get(i));
                                            if (variable) {
                                                VARIABLES.put(scan.get(i), new Variable(scan.get(i), this.getValue(part2), false));
                                                continue;
                                            }
                                            if (variable || VariableManager.this.contains(scan.get(i))) continue;
                                            boolean isFunction = FunctionManager.contains(scan.get(i));
                                            if (isFunction) {
                                                FunctionManager.delete(scan.get(i));
                                            }
                                            VARIABLES.put(scan.get(i), new Variable(scan.get(i), this.getValue(part2), false));
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            Utils.logError("Syntax Error!!!.\n");
                                            this.setValid(false);
                                        }
                                        continue;
                                    }
                                    Utils.logError("Syntax Error.\nCheck the help menu for valid code\n to use near  " + scan.get(i) + scan.get(i + 1));
                                    this.setValid(false);
                                }
                                break block19;
                            }
                            if (Variable.isVariableString(scan.get(0))) {
                                try {
                                    boolean variable = this.isVariable(scan.get(0));
                                    if (variable) {
                                        VARIABLES.put(scan.get(0), new Variable(scan.get(0), this.getValue(part2), false));
                                    } else if (!variable && !VariableManager.this.contains(scan.get(0))) {
                                        boolean isFunction = FunctionManager.contains(scan.get(0));
                                        if (isFunction) {
                                            FunctionManager.delete(scan.get(0));
                                        }
                                        VARIABLES.put(scan.get(0), new Variable(scan.get(0), this.getValue(part2), false));
                                    }
                                    break block19;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    Utils.logError("Syntax Error.11\n");
                                    this.setValid(false);
                                }
                                break block19;
                            }
                            Utils.logError("Syntax Error.22\n");
                            this.setValid(false);
                        }
                        catch (IndexOutOfBoundsException boundsException) {
                            Utils.logError("Syntax Error.\nPlease Consult The Help File.");
                            this.setValid(false);
                        }
                    } else {
                        Utils.logError("Syntax Error. Each line can only \ncontain one assignment operator!\n");
                        this.setValid(false);
                    }
                }
            }
        }

        private boolean storeHasVariable(String name) {
            return VARIABLES.get(name) != null;
        }

        public void parse() {
            List<String> lines = this.generateLines();
            int size = lines.size();
            for (int i = 0; i < size && this.valid; ++i) {
                this.analyzeLine(lines.get(i));
            }
        }
    }
}

