/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.List;
import parser.CustomScanner;
import parser.Function;
import parser.MathExpression;
import parser.STRING;
import parser.TYPE;
import util.VariableManager;

public class MathExpressionManager {
    private ArrayList<MathExpression> functions = new ArrayList();
    private int maxSize = 200;
    private int drgStatus = 1;

    public MathExpressionManager() {
        this.storeFunction(new MathExpression("1+1"));
    }

    public ArrayList<MathExpression> getFunctions() {
        return this.functions;
    }

    public void setFunctions(ArrayList<MathExpression> functions) {
        this.functions = functions;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setDrgStatus(int drgStatus) {
        this.drgStatus = drgStatus >= 0 && drgStatus < 3 ? drgStatus : 1;
        for (int i = 0; i < this.functions.size(); ++i) {
            this.functions.get(i).setDRG(drgStatus);
        }
    }

    public int getDrgStatus() {
        return this.drgStatus;
    }

    public VariableManager getVariableManager() {
        if (this.functions.size() > 0) {
            return this.functions.get(0).getVariableManager();
        }
        throw new NullPointerException("No function created yet!");
    }

    public boolean canOptimizeFunction(String expression) {
        return this.getFunctionByExpression(expression) != null;
    }

    public void storeFunction(MathExpression function) {
        if (!this.contains(function) && function.isCorrectFunction()) {
            int sz;
            this.functions.add(function);
            while ((sz = this.functions.size()) >= this.maxSize) {
                this.functions.remove(sz - 1);
            }
        }
    }

    public boolean contains(MathExpression func) {
        return this.getFunctionByExpression(func.getExpression()) != null;
    }

    public MathExpression getFunction(MathExpression function) {
        return this.functions.get(this.functions.indexOf(function));
    }

    public MathExpression getFunctionAt(int index) {
        if (index >= 0 && index < this.functions.size()) {
            return this.functions.get(index);
        }
        throw new ArrayIndexOutOfBoundsException("Function Store Access Error");
    }

    public MathExpression getFunctionByExpression(String expression) throws NullPointerException {
        int size = this.functions.size();
        String expr = STRING.purifier(expression);
        for (int i = 0; i < size; ++i) {
            String checkExpr = STRING.purifier(this.functions.get(i).getExpression());
            if (!expr.equals(checkExpr)) continue;
            return this.functions.get(i);
        }
        return null;
    }

    public MathExpression getFunctionByScanner(ArrayList<String> scanner) {
        int size = this.functions.size();
        for (int i = 0; i < size; ++i) {
            if (this.functions.get(i).getScanner() != scanner) continue;
            return this.functions.get(i);
        }
        return null;
    }

    public void removeFunctionAt(int index) {
        if (this.contains(this.functions.get(index))) {
            this.functions.remove(index);
        }
    }

    public void removeFunctionByName(String funcName) {
        int size = this.functions.size();
        for (int i = 0; i < size; ++i) {
            if (!this.functions.get(i).getExpression().equals(funcName)) continue;
            this.functions.remove(i);
        }
    }

    public void removeFunctionByScanner(ArrayList<String> scanner) {
        int size = this.functions.size();
        for (int i = 0; i < size; ++i) {
            if (this.functions.get(i).getScanner() != scanner) continue;
            this.functions.remove(i);
        }
    }

    public MathExpression optimizeFunction(String name) {
        return this.getFunctionByExpression(name);
    }

    public boolean isEmpty() {
        return this.functions.isEmpty() || this == null;
    }

    public MathExpression createFunction(String expr) {
        MathExpression f = new MathExpression(expr);
        f.setDRG(1);
        this.storeFunction(f);
        return f;
    }

    public String solve(String expr) throws NullPointerException {
        try {
            CustomScanner cs = new CustomScanner(STRING.purifier(expr), false, ";");
            List<String> scanned = cs.scan();
            String mathExpr = null;
            int exprCount = 0;
            for (String code : scanned) {
                if (code.contains("=")) {
                    boolean success = Function.assignObject(code + ";");
                    if (success) continue;
                    throw new Exception("Bad Variable or Function assignment!");
                }
                mathExpr = code;
                ++exprCount;
            }
            MathExpression f = null;
            if (mathExpr != null && !mathExpr.isEmpty() && exprCount == 1) {
                f = this.getFunctionByExpression(mathExpr);
                if (f != null) {
                    f.setDRG(this.drgStatus);
                } else {
                    f = new MathExpression("(" + mathExpr + ")");
                    f.setDRG(this.drgStatus);
                    this.storeFunction(f);
                }
            }
            if (f != null) {
                return MathExpressionManager.analyzeSolution(f);
            }
            return "0";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Syntax Error!";
        }
    }

    public static String analyzeSolution(MathExpression expr) {
        try {
            String token;
            String val = expr.solve();
            TYPE type = expr.getReturnType();
            if (val.contains(",") || val.contains("%")) {
                return val;
            }
            for (int i = 0; i < val.length() && !STRING.isNumberComponent(token = val.substring(i, i + 1)); ++i) {
            }
            if (type == TYPE.MATRIX) {
                return val;
            }
            double v = Double.parseDouble(val);
            return val;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof NumberFormatException || e instanceof InputMismatchException) {
                return "Syntax Error!";
            }
            if (e instanceof ArithmeticException) {
                return "Valid Range Error";
            }
            return "Math Input Error";
        }
    }
}

