/*
 * Decompiled with CFR 0.152.
 */
package parser.methods;

import java.util.InputMismatchException;
import java.util.List;
import math.Maths;
import math.matrix.expressParser.Matrix;
import parser.CustomScanner;
import parser.Function;
import parser.Number;
import parser.Operator;
import parser.STRING;
import parser.Set;
import parser.TYPE;
import util.FunctionManager;

public class Method {
    private String name;
    private String[] parameters;
    private int DRG = 1;
    public static final String SIN = "sin";
    public static final String COS = "cos";
    public static final String TAN = "tan";
    public static final String SINH = "sinh";
    public static final String COSH = "cosh";
    public static final String TANH = "tanh";
    public static final String ARC_SIN = "sin-\u00b9";
    public static final String ARC_COS = "cos-\u00b9";
    public static final String ARC_TAN = "tan-\u00b9";
    public static final String ARC_SINH = "sinh-\u00b9";
    public static final String ARC_COSH = "cosh-\u00b9";
    public static final String ARC_TANH = "tanh-\u00b9";
    public static final String SEC = "sec";
    public static final String COSEC = "csc";
    public static final String COT = "cot";
    public static final String SECH = "sech";
    public static final String COSECH = "csch";
    public static final String COTH = "coth";
    public static final String ARC_SEC = "sec-\u00b9";
    public static final String ARC_COSEC = "csc-\u00b9";
    public static final String ARC_COT = "cot-\u00b9";
    public static final String ARC_SECH = "sech-\u00b9";
    public static final String ARC_COSECH = "csch-\u00b9";
    public static final String ARC_COTH = "coth-\u00b9";
    public static final String EXP = "exp";
    public static final String LN = "ln";
    public static final String LG = "lg";
    public static final String LOG = "log";
    public static final String LN_INV = "ln-\u00b9";
    public static final String LG_INV = "lg-\u00b9";
    public static final String LOG_INV = "log-\u00b9";
    public static final String ARC_SIN_ALT = "asin";
    public static final String ARC_COS_ALT = "acos";
    public static final String ARC_TAN_ALT = "atan";
    public static final String ARC_SINH_ALT = "asinh";
    public static final String ARC_COSH_ALT = "acosh";
    public static final String ARC_TANH_ALT = "atanh";
    public static final String ARC_SEC_ALT = "asec";
    public static final String ARC_COSEC_ALT = "acsc";
    public static final String ARC_COT_ALT = "acot";
    public static final String ARC_SECH_ALT = "asech";
    public static final String ARC_COSECH_ALT = "acsch";
    public static final String ARC_COTH_ALT = "acoth";
    public static final String LN_INV_ALT = "aln";
    public static final String LG_INV_ALT = "alg";
    public static final String LOG_INV_ALT = "alog";
    public static final String FLOOR = "floor";
    public static final String CEIL = "ceil";
    public static final String SQRT = "sqrt";
    public static final String CBRT = "cbrt";
    public static final String INVERSE = "inverse";
    public static final String SQUARE = "square";
    public static final String CUBE = "cube";
    public static final String POW = "pow";
    public static final String FACT = "fact";
    public static final String COMBINATION = "comb";
    public static final String PERMUTATION = "perm";
    public static final String SUM = "sum";
    public static final String PROD = "prod";
    public static final String AVG = "avg";
    public static final String MEDIAN = "med";
    public static final String MODE = "mode";
    public static final String RANGE = "rng";
    public static final String MID_RANGE = "mrng";
    public static final String ROOT_MEAN_SQUARED = "rms";
    public static final String COEFFICIENT_OF_VARIATION = "cov";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String STD_DEV = "s_d";
    public static final String VARIANCE = "variance";
    public static final String STD_ERR = "st_err";
    public static final String RANDOM = "rnd";
    public static final String SORT = "sort";
    public static final String PLOT = "plot";
    public static final String DIFFERENTIATION = "diff";
    public static final String INTEGRATION = "intg";
    public static final String QUADRATIC = "quad";
    public static final String TARTAGLIA_ROOTS = "t_root";
    public static final String GENERAL_ROOT = "root";
    public static final String LINEAR_SYSTEM = "linear_sys";
    public static final String DETERMINANT = "det";
    public static final String INVERSE_MATRIX = "invert";
    public static final String TRIANGULAR_MATRIX = "tri_mat";
    public static final String ECHELON_MATRIX = "echelon";
    public static final String MATRIX_MULTIPLY = "matrix_mul";
    public static final String MATRIX_DIVIDE = "matrix_div";
    public static final String MATRIX_ADD = "matrix_add";
    public static final String MATRIX_SUBTRACT = "matrix_sub";
    public static final String MATRIX_POWER = "matrix_pow";
    public static final String MATRIX_TRANSPOSE = "transpose";
    public static final String MATRIX_EDIT = "matrix_edit";
    public static final String[] inbuiltMethods = new String[]{"sin", "cos", "tan", "sinh", "cosh", "tanh", "sin-\u00b9", "cos-\u00b9", "tan-\u00b9", "sinh-\u00b9", "cosh-\u00b9", "tanh-\u00b9", "sec", "csc", "cot", "sech", "csch", "coth", "sec-\u00b9", "csc-\u00b9", "cot-\u00b9", "sech-\u00b9", "csch-\u00b9", "coth-\u00b9", "exp", "ln", "lg", "log", "ln-\u00b9", "lg-\u00b9", "log-\u00b9", "asin", "acos", "atan", "asinh", "acosh", "atanh", "asec", "acsc", "acot", "asech", "acsch", "acoth", "aln", "alg", "alog", "floor", "ceil", "sqrt", "cbrt", "inverse", "square", "cube", "pow", "fact", "comb", "perm", "sum", "prod", "avg", "med", "mode", "rng", "mrng", "rms", "cov", "min", "max", "s_d", "variance", "st_err", "rnd", "sort", "plot", "diff", "intg", "quad", "t_root", "root", "linear_sys", "det", "invert", "tri_mat", "echelon", "matrix_mul", "matrix_div", "matrix_add", "matrix_sub", "matrix_pow", "transpose", "matrix_edit"};

    public Method(String name, String ... parameters) {
        this.name = Method.isMethodName(name) ? name : "";
        this.parameters = parameters;
        if (this.name.isEmpty()) {
            throw new InputMismatchException("Invalid Method Name!");
        }
    }

    public static String returnTypeDef(String typeName) {
        switch (typeName) {
            case "sin": {
                return TYPE.NUMBER.toString();
            }
            case "cos": {
                return TYPE.NUMBER.toString();
            }
            case "tan": {
                return TYPE.NUMBER.toString();
            }
            case "sinh": {
                return TYPE.NUMBER.toString();
            }
            case "cosh": {
                return TYPE.NUMBER.toString();
            }
            case "tanh": {
                return TYPE.NUMBER.toString();
            }
            case "sin-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "cos-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "tan-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "sinh-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "cosh-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "tanh-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "sec": {
                return TYPE.NUMBER.toString();
            }
            case "csc": {
                return TYPE.NUMBER.toString();
            }
            case "cot": {
                return TYPE.NUMBER.toString();
            }
            case "sech": {
                return TYPE.NUMBER.toString();
            }
            case "csch": {
                return TYPE.NUMBER.toString();
            }
            case "coth": {
                return TYPE.NUMBER.toString();
            }
            case "sec-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "csc-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "cot-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "sech-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "csch-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "coth-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "exp": {
                return TYPE.NUMBER.toString();
            }
            case "ln": {
                return TYPE.NUMBER.toString();
            }
            case "lg": {
                return TYPE.NUMBER.toString();
            }
            case "log": {
                return TYPE.NUMBER.toString();
            }
            case "ln-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "lg-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "log-\u00b9": {
                return TYPE.NUMBER.toString();
            }
            case "asin": {
                return TYPE.NUMBER.toString();
            }
            case "acos": {
                return TYPE.NUMBER.toString();
            }
            case "atan": {
                return TYPE.NUMBER.toString();
            }
            case "asinh": {
                return TYPE.NUMBER.toString();
            }
            case "acosh": {
                return TYPE.NUMBER.toString();
            }
            case "atanh": {
                return TYPE.NUMBER.toString();
            }
            case "asec": {
                return TYPE.NUMBER.toString();
            }
            case "acsc": {
                return TYPE.NUMBER.toString();
            }
            case "acot": {
                return TYPE.NUMBER.toString();
            }
            case "asech": {
                return TYPE.NUMBER.toString();
            }
            case "acsch": {
                return TYPE.NUMBER.toString();
            }
            case "acoth": {
                return TYPE.NUMBER.toString();
            }
            case "aln": {
                return TYPE.NUMBER.toString();
            }
            case "alg": {
                return TYPE.NUMBER.toString();
            }
            case "alog": {
                return TYPE.NUMBER.toString();
            }
            case "floor": {
                return TYPE.NUMBER.toString();
            }
            case "ceil": {
                return TYPE.NUMBER.toString();
            }
            case "sqrt": {
                return TYPE.NUMBER.toString();
            }
            case "cbrt": {
                return TYPE.NUMBER.toString();
            }
            case "inverse": {
                return TYPE.NUMBER.toString();
            }
            case "square": {
                return TYPE.NUMBER.toString();
            }
            case "cube": {
                return TYPE.NUMBER.toString();
            }
            case "pow": {
                return TYPE.NUMBER.toString();
            }
            case "fact": {
                return TYPE.NUMBER.toString();
            }
            case "comb": {
                return TYPE.NUMBER.toString();
            }
            case "perm": {
                return TYPE.NUMBER.toString();
            }
            case "sum": {
                return TYPE.NUMBER.toString();
            }
            case "prod": {
                return TYPE.NUMBER.toString();
            }
            case "avg": {
                return TYPE.NUMBER.toString();
            }
            case "med": {
                return TYPE.NUMBER.toString();
            }
            case "mode": {
                return TYPE.LIST.toString();
            }
            case "rng": {
                return TYPE.NUMBER.toString();
            }
            case "mrng": {
                return TYPE.NUMBER.toString();
            }
            case "rms": {
                return TYPE.NUMBER.toString();
            }
            case "cov": {
                return TYPE.NUMBER.toString();
            }
            case "min": {
                return TYPE.NUMBER.toString();
            }
            case "max": {
                return TYPE.NUMBER.toString();
            }
            case "s_d": {
                return TYPE.NUMBER.toString();
            }
            case "variance": {
                return TYPE.NUMBER.toString();
            }
            case "st_err": {
                return TYPE.NUMBER.toString();
            }
            case "rnd": {
                return TYPE.LIST.toString();
            }
            case "sort": {
                return TYPE.NUMBER.toString();
            }
            case "plot": {
                return TYPE.VOID.toString();
            }
            case "diff": {
                return TYPE.NUMBER.toString();
            }
            case "intg": {
                return TYPE.NUMBER.toString();
            }
            case "quad": {
                return TYPE.LIST.toString();
            }
            case "t_root": {
                return TYPE.LIST.toString();
            }
            case "root": {
                return TYPE.NUMBER.toString();
            }
            case "linear_sys": {
                return TYPE.ALGEBRAIC_EXPRESSION.toString();
            }
            case "det": {
                return TYPE.NUMBER.toString();
            }
            case "invert": {
                return TYPE.ALGEBRAIC_EXPRESSION.toString();
            }
            case "tri_mat": {
                return TYPE.ALGEBRAIC_EXPRESSION.toString();
            }
            case "echelon": {
                return TYPE.ALGEBRAIC_EXPRESSION.toString();
            }
            case "matrix_mul": {
                return TYPE.ALGEBRAIC_EXPRESSION.toString();
            }
            case "matrix_div": {
                return TYPE.ALGEBRAIC_EXPRESSION.toString();
            }
            case "matrix_add": {
                return TYPE.ALGEBRAIC_EXPRESSION.toString();
            }
            case "matrix_sub": {
                return TYPE.ALGEBRAIC_EXPRESSION.toString();
            }
            case "matrix_pow": {
                return TYPE.ALGEBRAIC_EXPRESSION.toString();
            }
            case "transpose": {
                return TYPE.ALGEBRAIC_EXPRESSION.toString();
            }
            case "matrix_edit": {
                return TYPE.VOID.toString();
            }
        }
        return TYPE.NUMBER.toString();
    }

    public static boolean isFunctionOperatingMethod(String methodName) {
        return methodName.equals(DIFFERENTIATION) || methodName.equals(INTEGRATION) || methodName.equals(QUADRATIC) || methodName.equals(GENERAL_ROOT) || methodName.equals(TARTAGLIA_ROOTS) || methodName.equals(PLOT) || methodName.equals(MATRIX_MULTIPLY) || methodName.equals(MATRIX_DIVIDE) || methodName.equals(MATRIX_ADD) || methodName.equals(MATRIX_SUBTRACT) || methodName.equals(MATRIX_POWER) || methodName.equals(MATRIX_EDIT) || methodName.equals(MATRIX_TRANSPOSE) || methodName.equals(DETERMINANT);
    }

    public Method(String expression) {
        this.parseExpression(expression);
    }

    public static String[] getAllFunctions() {
        int sz = FunctionManager.FUNCTIONS.size();
        String[] userDefined = new String[sz + inbuiltMethods.length];
        String[] keyset = FunctionManager.FUNCTIONS.keySet().toArray(new String[0]);
        System.arraycopy(keyset, 0, userDefined, 0, keyset.length);
        int sz1 = userDefined.length;
        int pass = 0;
        int i = sz;
        while (i < sz1) {
            userDefined[i] = inbuiltMethods[pass];
            ++i;
            ++pass;
        }
        return userDefined;
    }

    public final void parseExpression(String expression) {
        CustomScanner cs = new CustomScanner(expression, false, "(", ")", ",");
        List<String> l = cs.scan();
        int sz = l.size();
        if (!Method.isMethodName(l.get(0))) {
            throw new InputMismatchException("Invalid Method Name!");
        }
        String[] params = new String[sz - 1];
        params = l.subList(1, sz).toArray(params);
        this.setParameters(params);
        this.setName(l.get(0));
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setParameters(String[] parameters) {
        this.parameters = parameters;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setDRG(int DRG) {
        this.DRG = DRG;
    }

    public int getDRG() {
        return this.DRG;
    }

    public static boolean isListReturningStatsMethod(String op) {
        return op.equals(SORT) || op.equals(MODE) || op.equals(RANDOM) || op.equals(QUADRATIC) || op.equals(TARTAGLIA_ROOTS) || op.equals(INVERSE_MATRIX) || op.equals(LINEAR_SYSTEM) || op.equals(TRIANGULAR_MATRIX) || op.equals(ECHELON_MATRIX) || op.equals(MATRIX_MULTIPLY) || op.equals(MATRIX_DIVIDE) || op.equals(MATRIX_ADD) || op.equals(MATRIX_SUBTRACT) || op.equals(MATRIX_POWER) || op.equals(MATRIX_TRANSPOSE) || op.equals(MATRIX_EDIT);
    }

    public static boolean isNumberReturningStatsMethod(String op) {
        return Method.isStatsMethod(op) && !Method.isListReturningStatsMethod(op);
    }

    public static boolean isRandom(String op) {
        return op.equals(RANDOM);
    }

    public static boolean isLogToAnyBase(String op) {
        return op.equals(LOG);
    }

    public static boolean isAntiLogToAnyBase(String op) {
        return op.equals(LOG_INV) || op.equals(LOG_INV_ALT);
    }

    public static boolean isNaturalLog(String op) {
        return op.equals(LN);
    }

    public static boolean isInverseNaturalLog(String op) {
        return op.equals(LN_INV) || op.equals(LN_INV_ALT);
    }

    public static boolean isExpMethod(String op) {
        return op.equals(EXP);
    }

    public static boolean isLogOrAntiLogToAnyBase(String op) {
        return Method.isLogToAnyBase(op) || Method.isAntiLogToAnyBase(op);
    }

    public boolean isDeterminant(String op) {
        return op.equals(DETERMINANT);
    }

    public boolean isMatrixInvert(String op) {
        return op.equals(INVERSE_MATRIX);
    }

    public boolean isLinearSys(String op) {
        return op.equals(LINEAR_SYSTEM);
    }

    public boolean isTriMat(String op) {
        return op.equals(TRIANGULAR_MATRIX);
    }

    public boolean isEchelon(String op) {
        return op.equals(ECHELON_MATRIX);
    }

    public static boolean isStatsMethod(String op) {
        return op.equals(SUM) || op.equals(PROD) || op.equals(AVG) || op.equals(MEDIAN) || op.equals(MODE) || op.equals(RANGE) || op.equals(MID_RANGE) || op.equals(ROOT_MEAN_SQUARED) || op.equals(COEFFICIENT_OF_VARIATION) || op.equals(MIN) || op.equals(MAX) || op.equals(STD_DEV) || op.equals(VARIANCE) || op.equals(STD_ERR) || op.equals(RANDOM) || op.equals(SORT) || Method.isUserDefinedFunction(op) || Method.isLogOrAntiLogToAnyBase(op) || op.equals(POW) || op.equals(DIFFERENTIATION) || op.equals(INTEGRATION) || op.equals(GENERAL_ROOT) || op.equals(QUADRATIC) || op.equals(TARTAGLIA_ROOTS) || op.equals(PERMUTATION) || op.equals(COMBINATION) || op.equals(LOG) || op.equals(LOG_INV) || op.equals(LOG_INV_ALT) || Method.isMatrixMethod(op);
    }

    public static boolean isMatrixMethod(String op) {
        return op.equals(LINEAR_SYSTEM) || op.equals(DETERMINANT) || op.equals(INVERSE_MATRIX) || op.equals(TRIANGULAR_MATRIX) || op.equals(ECHELON_MATRIX) || op.equals(MATRIX_MULTIPLY) || op.equals(MATRIX_DIVIDE) || op.equals(MATRIX_ADD) || op.equals(MATRIX_SUBTRACT) || op.equals(MATRIX_POWER) || op.equals(MATRIX_EDIT) || op.equals(MATRIX_TRANSPOSE);
    }

    public static boolean isMatrixMul(String op) {
        return op.equals(MATRIX_MULTIPLY);
    }

    public static boolean isMatrixDiv(String op) {
        return op.equals(MATRIX_DIVIDE);
    }

    public static boolean isMatrixAdd(String op) {
        return op.equals(MATRIX_ADD);
    }

    public static boolean isMatrixSub(String op) {
        return op.equals(MATRIX_SUBTRACT);
    }

    public static boolean isMatrixPow(String op) {
        return op.equals(MATRIX_POWER);
    }

    public static boolean isTranspose(String op) {
        return op.equals(MATRIX_TRANSPOSE);
    }

    public static boolean isMatrixEdit(String op) {
        return op.equals(MATRIX_EDIT);
    }

    public static boolean isUserDefinedFunction(String op) {
        return FunctionManager.lookUp(op) != null;
    }

    public static List<String> run(List<String> list, int DRG) {
        String name = list.get(0);
        String result = "";
        list.subList(0, 2).clear();
        list.remove(list.size() - 1);
        int sz = list.size();
        if (Method.isStatsMethod(name)) {
            if (name.equals(SUM)) {
                Set set = new Set(list);
                result = String.valueOf(set.sum());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(PROD)) {
                Set set = new Set(list);
                result = String.valueOf(set.prod());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(AVG)) {
                Set set = new Set(list);
                result = String.valueOf(set.avg());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(MEDIAN)) {
                Set set = new Set(list);
                result = String.valueOf(set.median());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(RANGE)) {
                Set set = new Set(list);
                result = String.valueOf(set.rng());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(MID_RANGE)) {
                Set set = new Set(list);
                result = String.valueOf(set.mrng());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(MAX)) {
                Set set = new Set(list);
                result = String.valueOf(set.max());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(MIN)) {
                Set set = new Set(list);
                result = String.valueOf(set.min());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(ROOT_MEAN_SQUARED)) {
                Set set = new Set(list);
                result = String.valueOf(set.rms());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(COEFFICIENT_OF_VARIATION)) {
                Set set = new Set(list);
                result = String.valueOf(set.cov());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(STD_DEV)) {
                Set set = new Set(list);
                result = String.valueOf(set.std_dev());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(VARIANCE)) {
                Set set = new Set(list);
                result = String.valueOf(set.var());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(STD_ERR)) {
                Set set = new Set(list);
                result = String.valueOf(set.std_err());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(DIFFERENTIATION)) {
                Set set = new Set(list);
                result = String.valueOf(set.differentiate());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(INTEGRATION)) {
                Set set = new Set(list);
                result = String.valueOf(set.integrate());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(GENERAL_ROOT)) {
                Set set = new Set(list);
                result = String.valueOf(set.rootOfEquation());
                list.clear();
                list.add(result);
                return list;
            }
            if (name.equals(DETERMINANT)) {
                Set set = new Set(list);
                result = String.valueOf(set.determinant());
                list.clear();
                list.add(result);
                return list;
            }
            if (Method.isUserDefinedFunction(name)) {
                try {
                    Set set = new Set(list);
                    result = String.valueOf(set.evaluateUserDefinedFunction(name));
                    list.clear();
                    list.add(result);
                    return list;
                }
                catch (ClassNotFoundException set) {}
            } else {
                if (name.equals(LOG)) {
                    if (sz == 1) {
                        result = String.valueOf(Maths.logToAnyBase(Double.valueOf(list.get(0)), 10.0));
                        list.clear();
                        list.add(result);
                    } else if (sz == 2) {
                        result = String.valueOf(Maths.logToAnyBase(Double.valueOf(list.get(0)), Double.valueOf(list.get(1))));
                        list.clear();
                        list.add(result);
                    }
                    return list;
                }
                if (name.equals(LOG_INV) || name.equals(LOG_INV_ALT)) {
                    if (sz == 1) {
                        result = String.valueOf(Maths.antiLogToAnyBase(Double.valueOf(list.get(0)), 10.0));
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (sz == 2) {
                        result = String.valueOf(Maths.antiLogToAnyBase(Double.valueOf(list.get(0)), Double.valueOf(list.get(1))));
                        list.clear();
                        list.add(result);
                        return list;
                    }
                } else {
                    if (name.equals(QUADRATIC)) {
                        Set set = new Set(list);
                        result = set.quadraticRoots();
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals(TARTAGLIA_ROOTS)) {
                        Set set = new Set(list);
                        result = set.tartaglianRoots();
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals(POW) && sz == 2) {
                        Set set = new Set(list);
                        result = String.valueOf(set.power());
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals(PERMUTATION) && sz == 2) {
                        Set set = new Set(list);
                        result = String.valueOf(set.permutation());
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals(COMBINATION) && sz == 2) {
                        Set set = new Set(list);
                        result = String.valueOf(set.combination());
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals(MODE)) {
                        Set set = new Set(list);
                        result = String.valueOf(set.mode());
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals(RANDOM) && sz >= 0 && sz <= 2) {
                        Set set = new Set(list);
                        result = String.valueOf(set.random());
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals(SORT)) {
                        Set set = new Set(list);
                        result = String.valueOf(set.sort());
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals(INVERSE_MATRIX)) {
                        Set set = new Set(list);
                        Matrix matrix = set.invert();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals(LINEAR_SYSTEM)) {
                        Set set = new Set(list);
                        Matrix matrix = set.solveSystem();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals(TRIANGULAR_MATRIX)) {
                        Set set = new Set(list);
                        Matrix matrix = set.triMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals(ECHELON_MATRIX)) {
                        Set set = new Set(list);
                        Matrix matrix = set.echelon();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals(MATRIX_MULTIPLY)) {
                        Set set = new Set(list);
                        Matrix matrix = set.multiplyMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals(MATRIX_DIVIDE)) {
                        Set set = new Set(list);
                        Matrix matrix = set.divideMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals(MATRIX_ADD)) {
                        Set set = new Set(list);
                        Matrix matrix = set.addMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals(MATRIX_SUBTRACT)) {
                        Set set = new Set(list);
                        Matrix matrix = set.subtractMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals(MATRIX_POWER)) {
                        Set set = new Set(list);
                        Matrix matrix = set.powerMatrix();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                    if (name.equals(MATRIX_TRANSPOSE)) {
                        Set set = new Set(list);
                        result = String.valueOf(set.transpose());
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (name.equals(MATRIX_EDIT)) {
                        Set set = new Set(list);
                        Matrix matrix = set.transpose();
                        list.clear();
                        String ref = Function.storeAnonymousMatrixFunction(matrix);
                        list.add(ref);
                        return list;
                    }
                }
            }
        } else if (sz == 1) {
            try {
                if (!list.get(0).equals("Infinity") && Number.isNumber(list.get(0))) {
                    if (DRG == 0) {
                        if (name.equals(SIN)) {
                            result = String.valueOf(Maths.sinDegToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals(SINH)) {
                            result = String.valueOf(Math.sinh(Double.valueOf(list.get(0))));
                        } else if (name.equals(COS)) {
                            result = String.valueOf(Maths.cosDegToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals(COSH)) {
                            result = String.valueOf(Math.cosh(Double.valueOf(list.get(0))));
                        } else if (name.equals(TAN)) {
                            result = String.valueOf(Maths.tanDegToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals(TANH)) {
                            result = String.valueOf(Math.tanh(Double.valueOf(list.get(0))));
                        } else if (name.equals(SEC)) {
                            result = String.valueOf(1.0 / Maths.cosDegToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals(SECH)) {
                            result = String.valueOf(1.0 / Math.cosh(Double.valueOf(list.get(0))));
                        } else if (name.equals(COSEC)) {
                            result = String.valueOf(1.0 / Maths.sinDegToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals(COSECH)) {
                            result = String.valueOf(1.0 / Math.sinh(Double.valueOf(list.get(0))));
                        } else if (name.equals(COT)) {
                            result = String.valueOf(1.0 / Maths.tanDegToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals(COTH)) {
                            result = String.valueOf(Math.tanh(Double.valueOf(list.get(0))));
                        } else if (name.equals(EXP) || name.equals(LN_INV_ALT) || name.equals(LN_INV)) {
                            result = String.valueOf(Math.exp(Double.valueOf(list.get(0))));
                        } else if (name.equals(LN)) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0))));
                        } else if (name.equals(LG)) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0))) / Math.log(10.0));
                        } else if (name.equals(ARC_SIN) || name.equals(ARC_SIN_ALT)) {
                            result = String.valueOf(Maths.asinRadToDeg(Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_COS) || name.equals(ARC_COS_ALT)) {
                            result = String.valueOf(Maths.acosRadToDeg(Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_TAN) || name.equals(ARC_TAN_ALT)) {
                            result = String.valueOf(Maths.atanRadToDeg(Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_SINH) || name.equals(ARC_SINH_ALT)) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0)) + Math.sqrt(Math.pow(Double.valueOf(list.get(0)), 2.0) + 1.0)));
                        } else if (name.equals(ARC_COSH) || name.equals(ARC_COSH_ALT)) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0)) + Math.sqrt(Math.pow(Double.valueOf(list.get(0)), 2.0) - 1.0)));
                        } else if (name.equals(ARC_TANH) || name.equals(ARC_TANH_ALT)) {
                            result = String.valueOf(0.5 * Math.log((1.0 + Double.valueOf(list.get(0))) / (1.0 - Double.valueOf(list.get(0)))));
                        } else if (name.equals(ARC_SEC) || name.equals(ARC_SEC_ALT)) {
                            result = String.valueOf(Maths.acosRadToDeg(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_COSEC) || name.equals(ARC_COSEC_ALT)) {
                            result = String.valueOf(Maths.asinRadToDeg(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_COT) || name.equals(ARC_COT_ALT)) {
                            result = String.valueOf(Maths.atanRadToDeg(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_SECH) || name.equals(ARC_SECH_ALT)) {
                            result = String.valueOf(Math.log((1.0 + Math.sqrt(1.0 - Math.pow(Double.valueOf(list.get(0)), 2.0))) / Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_COSECH) || name.equals(ARC_COSECH_ALT)) {
                            result = String.valueOf(Math.log((1.0 + Math.sqrt(1.0 + Math.pow(Double.valueOf(list.get(0)), 2.0))) / Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_COTH) || name.equals(ARC_COTH_ALT)) {
                            result = String.valueOf(0.5 * Math.log((Double.valueOf(list.get(0)) + 1.0) / (Double.valueOf(list.get(0)) - 1.0)));
                        } else if (name.equals(LG_INV) || name.equals(LG_INV_ALT)) {
                            result = String.valueOf(Math.pow(10.0, Double.valueOf(list.get(0))));
                        } else if (name.equals(CEIL)) {
                            result = String.valueOf(Math.ceil(Double.valueOf(list.get(0))));
                        } else if (name.equals(FLOOR)) {
                            result = String.valueOf(Math.floor(Double.valueOf(list.get(0))));
                        } else if (name.equals(SQRT)) {
                            result = String.valueOf(Math.sqrt(Double.valueOf(list.get(0))));
                        } else if (name.equals(CBRT)) {
                            result = String.valueOf(Math.cbrt(Double.valueOf(list.get(0))));
                        } else if (name.equals(SQUARE)) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(val * val);
                        } else if (name.equals(CUBE)) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(val * val * val);
                        } else if (name.equals(INVERSE)) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(1.0 / val);
                        } else if (name.equals(FACT)) {
                            result = Maths.fact(list.get(0));
                        }
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (DRG == 1) {
                        if (name.equals(SIN)) {
                            result = String.valueOf(Math.sin(Double.valueOf(list.get(0))));
                        } else if (name.equals(SINH)) {
                            result = String.valueOf(Math.sinh(Double.valueOf(list.get(0))));
                        } else if (name.equals(COS)) {
                            result = String.valueOf(Math.cos(Double.valueOf(list.get(0))));
                        } else if (name.equals(COSH)) {
                            result = String.valueOf(Math.cosh(Double.valueOf(list.get(0))));
                        } else if (name.equals(TAN)) {
                            result = String.valueOf(Math.tan(Double.valueOf(list.get(0))));
                        } else if (name.equals(TANH)) {
                            result = String.valueOf(Math.tanh(Double.valueOf(list.get(0))));
                        } else if (name.equals(SEC)) {
                            result = String.valueOf(1.0 / Math.cos(Double.valueOf(list.get(0))));
                        } else if (name.equals(SECH)) {
                            result = String.valueOf(1.0 / Math.cosh(Double.valueOf(list.get(0))));
                        } else if (name.equals(COSEC)) {
                            result = String.valueOf(1.0 / Math.sin(Double.valueOf(list.get(0))));
                        } else if (name.equals(COSECH)) {
                            result = String.valueOf(1.0 / Math.sinh(Double.valueOf(list.get(0))));
                        } else if (name.equals(COT)) {
                            result = String.valueOf(1.0 / Math.tan(Double.valueOf(list.get(0))));
                        } else if (name.equals(COTH)) {
                            result = String.valueOf(Math.tanh(Double.valueOf(list.get(0))));
                        } else if (name.equals(EXP) || name.equals(LN_INV_ALT) || name.equals(LN_INV)) {
                            result = String.valueOf(Math.exp(Double.valueOf(list.get(0))));
                        } else if (name.equals(LN)) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0))));
                        } else if (name.equals(LG)) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0))) / Math.log(10.0));
                        } else if (name.equals(ARC_SIN) || name.equals(ARC_SIN_ALT)) {
                            result = String.valueOf(Math.asin(Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_COS) || name.equals(ARC_COS_ALT)) {
                            result = String.valueOf(Math.acos(Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_TAN) || name.equals(ARC_TAN_ALT)) {
                            result = String.valueOf(Math.atan(Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_SINH) || name.equals(ARC_SINH_ALT)) {
                            result = String.valueOf(Maths.asinh(Double.parseDouble(list.get(0))));
                        } else if (name.equals(ARC_COSH) || name.equals(ARC_COSH_ALT)) {
                            result = String.valueOf(Maths.acosh(Double.parseDouble(list.get(0))));
                        } else if (name.equals(ARC_TANH) || name.equals(ARC_TANH_ALT)) {
                            result = String.valueOf(Maths.atanh(Double.parseDouble(list.get(0))));
                        } else if (name.equals(ARC_SEC) || name.equals(ARC_SEC_ALT)) {
                            result = String.valueOf(Math.acos(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_COSEC) || name.equals(ARC_COSEC_ALT)) {
                            result = String.valueOf(Math.asin(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_COT) || name.equals(ARC_COT_ALT)) {
                            result = String.valueOf(Math.atan(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_SECH) || name.equals(ARC_SECH_ALT)) {
                            result = String.valueOf(Maths.asech(Double.parseDouble(list.get(0))));
                        } else if (name.equals(ARC_COSECH) || name.equals(ARC_COSECH_ALT)) {
                            result = String.valueOf(Maths.acsch(Double.parseDouble(list.get(0))));
                        } else if (name.equals(ARC_COTH) || name.equals(ARC_COTH_ALT)) {
                            result = String.valueOf(Maths.acoth(Double.parseDouble(list.get(0))));
                        } else if (name.equals(LG_INV) || name.equals(LG_INV_ALT)) {
                            result = String.valueOf(Math.pow(10.0, Double.valueOf(list.get(0))));
                        } else if (name.equals(CEIL)) {
                            result = String.valueOf(Math.ceil(Double.valueOf(list.get(0))));
                        } else if (name.equals(FLOOR)) {
                            result = String.valueOf(Math.floor(Double.valueOf(list.get(0))));
                        } else if (name.equals(SQRT)) {
                            result = String.valueOf(Math.sqrt(Double.valueOf(list.get(0))));
                        } else if (name.equals(CBRT)) {
                            result = String.valueOf(Math.cbrt(Double.valueOf(list.get(0))));
                        } else if (name.equals(SQUARE)) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(val * val);
                        } else if (name.equals(CUBE)) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(val * val * val);
                        } else if (name.equals(INVERSE)) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(1.0 / val);
                        } else if (name.equals(FACT)) {
                            result = Maths.fact(list.get(0));
                        }
                        list.clear();
                        list.add(result);
                        return list;
                    }
                    if (DRG == 2) {
                        if (name.equals(SIN)) {
                            result = String.valueOf(Maths.sinGradToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals(SINH)) {
                            result = String.valueOf(Math.sinh(Double.valueOf(list.get(0))));
                        } else if (name.equals(COS)) {
                            result = String.valueOf(Maths.cosGradToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals(COSH)) {
                            result = String.valueOf(Math.cosh(Double.valueOf(list.get(0))));
                        } else if (name.equals(TAN)) {
                            result = String.valueOf(Maths.tanGradToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals(TANH)) {
                            result = String.valueOf(Math.tanh(Double.valueOf(list.get(0))));
                        } else if (name.equals(SEC)) {
                            result = String.valueOf(1.0 / Maths.cosGradToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals(SECH)) {
                            result = String.valueOf(1.0 / Math.cosh(Double.valueOf(list.get(0))));
                        } else if (name.equals(COSEC)) {
                            result = String.valueOf(1.0 / Maths.sinGradToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals(COSECH)) {
                            result = String.valueOf(1.0 / Math.sinh(Double.valueOf(list.get(0))));
                        } else if (name.equals(COT)) {
                            result = String.valueOf(1.0 / Maths.tanGradToRad(Double.valueOf(list.get(0))));
                        } else if (name.equals(COTH)) {
                            result = String.valueOf(Math.tanh(Double.valueOf(list.get(0))));
                        } else if (name.equals(EXP) || name.equals(LN_INV_ALT) || name.equals(LN_INV)) {
                            result = String.valueOf(Math.exp(Double.valueOf(list.get(0))));
                        } else if (name.equals(LN)) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0))));
                        } else if (name.equals(LG)) {
                            result = String.valueOf(Math.log(Double.valueOf(list.get(0))) / Math.log(10.0));
                        } else if (name.equals(ARC_SIN) || name.equals(ARC_SIN_ALT)) {
                            result = String.valueOf(Maths.asinRadToGrad(Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_COS) || name.equals(ARC_COS_ALT)) {
                            result = String.valueOf(Maths.acosRadToGrad(Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_TAN) || name.equals(ARC_TAN_ALT)) {
                            result = String.valueOf(Maths.atanRadToGrad(Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_SINH) || name.equals(ARC_SINH_ALT)) {
                            result = String.valueOf(Maths.asinh(Double.parseDouble(list.get(0))));
                        } else if (name.equals(ARC_COSH) || name.equals(ARC_COSH_ALT)) {
                            result = String.valueOf(Maths.acosh(Double.parseDouble(list.get(0))));
                        } else if (name.equals(ARC_TANH) || name.equals(ARC_TANH_ALT)) {
                            result = String.valueOf(Maths.atanh(Double.parseDouble(list.get(0))));
                        } else if (name.equals(ARC_SEC) || name.equals(ARC_SEC_ALT)) {
                            result = String.valueOf(Maths.acosRadToGrad(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_COSEC) || name.equals(ARC_COSEC_ALT)) {
                            result = String.valueOf(Maths.asinRadToGrad(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_COT) || name.equals(ARC_COT_ALT)) {
                            result = String.valueOf(Maths.atanRadToGrad(1.0 / Double.valueOf(list.get(0))));
                        } else if (name.equals(ARC_SECH) || name.equals(ARC_SECH_ALT)) {
                            result = String.valueOf(Maths.asech(Double.parseDouble(list.get(0))));
                        } else if (name.equals(ARC_COSECH) || name.equals(ARC_COSECH_ALT)) {
                            result = String.valueOf(Maths.acsch(Double.parseDouble(list.get(0))));
                        } else if (name.equals(ARC_COTH) || name.equals(ARC_COTH_ALT)) {
                            result = String.valueOf(Maths.acoth(Double.parseDouble(list.get(0))));
                        } else if (name.equals(LG_INV) || name.equals(LG_INV_ALT)) {
                            result = String.valueOf(Math.pow(10.0, Double.valueOf(list.get(0))));
                        } else if (name.equals(CEIL)) {
                            result = String.valueOf(Math.ceil(Double.valueOf(list.get(0))));
                        } else if (name.equals(FLOOR)) {
                            result = String.valueOf(Math.floor(Double.valueOf(list.get(0))));
                        } else if (name.equals(SQRT)) {
                            result = String.valueOf(Math.sqrt(Double.valueOf(list.get(0))));
                        } else if (name.equals(CBRT)) {
                            result = String.valueOf(Math.cbrt(Double.valueOf(list.get(0))));
                        } else if (name.equals(SQUARE)) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(val * val);
                        } else if (name.equals(CUBE)) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(val * val * val);
                        } else if (name.equals(INVERSE)) {
                            double val = Double.valueOf(list.get(0));
                            result = String.valueOf(1.0 / val);
                        } else if (name.equals(FACT)) {
                            result = Maths.fact(list.get(0));
                        }
                        list.clear();
                        list.add(result);
                        return list;
                    }
                } else if (list.get(0).equals("Infinity")) {
                    list.add("Infinity");
                    return list;
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            list.add("Syntax Error!");
            return list;
        }
        throw new IllegalArgumentException(" Unknown function: " + name);
    }

    public static boolean isUnaryPreOperatorORDefinedMethod(String methodName) {
        return Method.isDefinedMethod(methodName) || Operator.isUnaryPreOperator(methodName);
    }

    public static boolean isDefinedMethod(String methodName) {
        return Method.arrayContains(inbuiltMethods, methodName) || FunctionManager.contains(methodName);
    }

    public static boolean isInBuiltMethod(String methodName) {
        return Method.arrayContains(inbuiltMethods, methodName);
    }

    public static boolean arrayContains(String[] array, String str) {
        for (String s : array) {
            if (!s.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMethodName(String name) {
        try {
            String end = "";
            if (name.equals("-\u00b9")) {
                return false;
            }
            if (name.endsWith("-\u00b9") && !name.equals("-\u00b9")) {
                end = "-\u00b9";
                name = name.substring(0, name.length() - 2);
            }
            if (Method.isMethodNameBeginner(name.substring(0, 1))) {
                int len = name.length();
                for (int i = 0; i < len; ++i) {
                    if (Method.isMethodNameBuilder(name.substring(i, i + 1))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        catch (IndexOutOfBoundsException boundsException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static boolean isMethodNameBuilder(String name) {
        return Method.isMethodNameBeginner(name) || STRING.isDigit(name);
    }

    public static boolean isMethodNameBeginner(String name) {
        return !Operator.isPermOrComb(name) && Character.isLetter(name.toCharArray()[0]) || name.equals("_") || name.equals("$");
    }

    public String toString() {
        String out = this.name.concat("(");
        int sz = this.parameters.length;
        for (int i = 0; i < sz; ++i) {
            out = out.concat(this.parameters[i].concat(","));
        }
        out = out.substring(0, out.length());
        out = out.concat(")");
        return out;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Method) {
            Method m = (Method)obj;
            return m.name.equals(this.name) && m.parameters.length == this.parameters.length;
        }
        return false;
    }

    private static String[] join(String[] arr1, String[] arr2) {
        String[] larger = new String[arr1.length + arr2.length];
        int len = larger.length;
        int subLen1 = arr1.length;
        int subLen2 = arr2.length;
        for (int i = 0; i < len; ++i) {
            larger[i] = i < subLen1 ? arr1[i] : arr2[i];
        }
        return larger;
    }

    public static String[] getStatsMethods() {
        return new String[]{SUM, PROD, AVG, MEDIAN, MODE, RANGE, MID_RANGE, ROOT_MEAN_SQUARED, COEFFICIENT_OF_VARIATION, MIN, MAX, STD_DEV, VARIANCE, STD_ERR, RANDOM, SORT};
    }

    public static boolean hasStatsMethod(String expr) {
        String[] statsoperators = new String[]{SUM, PROD, AVG, MEDIAN, MODE, RANGE, MID_RANGE, ROOT_MEAN_SQUARED, COEFFICIENT_OF_VARIATION, MIN, MAX, STD_DEV, VARIANCE, STD_ERR, RANDOM, SORT};
        CustomScanner cs = new CustomScanner(expr, true, statsoperators);
        List<String> scan = cs.scan();
        int size = scan.size();
        for (int i = 0; i < size; ++i) {
            try {
                if (!Method.isStatsMethod(scan.get(i)) || !scan.get(i + 1).startsWith("(")) continue;
                return true;
            }
            catch (IndexOutOfBoundsException boundsException) {
                return false;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        Method m = new Method("F(x,y,z)");
        System.out.println(Method.isMethodName("F"));
        System.out.println(Method.isMethodNameBeginner("\u010c"));
        StringBuilder builder = new StringBuilder();
        for (String name : inbuiltMethods) {
            builder.append(name).append(",");
        }
        System.out.println(builder);
    }
}

