/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import parser.Bracket;
import parser.Operator;
import parser.Validatable;
import parser.methods.Method;

public final class ListReturningStatsOperator
extends Operator
implements Validatable {
    private boolean superParent;
    private int index;
    private Bracket openBracket;
    private Bracket closeBracket;
    private ListReturningStatsOperator parent;
    private static String errorMessage = "";

    public ListReturningStatsOperator(String op, int index, ArrayList<String> scan) {
        super(op);
        this.index = scan.get(index).equals(op) ? index : -1;
        this.openBracket = new Bracket("(");
        this.openBracket.setIndex(index + 1);
        int compIndex = Bracket.getComplementIndex(true, index + 1, scan);
        this.closeBracket = new Bracket(")");
        this.closeBracket.setIndex(compIndex);
        this.openBracket.setComplement(this.closeBracket);
        this.closeBracket.setComplement(this.openBracket);
        this.determineSuperParentStatus(scan);
        this.hasParent(scan);
        if (this.index == -1) {
            throw new ArrayIndexOutOfBoundsException("PARSER COULD NOT FIND\n '" + op + "' AT INDEX " + index + ".\nFOUND '" + scan.get(index) + "' INSTEAD OF '" + op + "'");
        }
    }

    private void determineSuperParentStatus(ArrayList<String> scan) {
        int i;
        boolean isSuper = true;
        int scanStartIndex = this.getCloseBracket().getIndex();
        for (i = scanStartIndex + 1; i < scan.size(); ++i) {
            if (ListReturningStatsOperator.isClosingBracket(scan.get(i))) continue;
            isSuper = false;
            break;
        }
        for (i = this.index - 1; i >= 0; --i) {
            if (ListReturningStatsOperator.isOpeningBracket(scan.get(i))) continue;
            isSuper = false;
            break;
        }
        this.setSuperParent(isSuper);
    }

    public void setOpenBracket(Bracket openBracket) {
        this.openBracket = openBracket;
    }

    public Bracket getOpenBracket() {
        return this.openBracket;
    }

    public void setCloseBracket(Bracket closeBracket) {
        this.closeBracket = closeBracket;
    }

    public Bracket getCloseBracket() {
        return this.closeBracket;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setSuperParent(boolean superParent) {
        this.superParent = superParent;
    }

    public boolean isSuperParent() {
        return this.superParent;
    }

    public void setParent(ListReturningStatsOperator parent) {
        this.parent = parent;
    }

    public ListReturningStatsOperator getParent() {
        return this.parent;
    }

    public static void setErrorMessage(String errorMessage) {
        ListReturningStatsOperator.errorMessage = errorMessage;
    }

    public static String getErrorMessage() {
        return errorMessage;
    }

    public boolean hasParent(ArrayList<String> scan) {
        int compIndex;
        boolean isEnveloped = false;
        int i = this.index;
        boolean foundLikelyEncloser = false;
        for (i = this.index - 1; i >= 0; --i) {
            if (!Method.isListReturningStatsMethod(scan.get(i))) continue;
            foundLikelyEncloser = true;
            break;
        }
        if (foundLikelyEncloser && (compIndex = Bracket.getComplementIndex(true, i + 1, scan)) > this.closeBracket.getIndex()) {
            isEnveloped = true;
            ListReturningStatsOperator listType = new ListReturningStatsOperator(scan.get(i), i, scan);
            this.setParent(listType);
        }
        return isEnveloped;
    }

    @Override
    public boolean validate(ArrayList<String> scan) {
        boolean valid = true;
        if (!this.isSuperParent()) {
            try {
                if (ListReturningStatsOperator.isBinaryOperator(scan.get(this.index - 1)) || Method.isUnaryPreOperatorORDefinedMethod(scan.get(this.index - 1))) {
                    valid = false;
                    errorMessage = errorMessage + "\n Bad Syntax! Do Not Concatenate operator " + scan.get(this.index - 1) + " With " + this.getName();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            try {
                if (ListReturningStatsOperator.isBinaryOperator(scan.get(this.closeBracket.getIndex() + 1)) || ListReturningStatsOperator.isUnaryPostOperator(scan.get(this.closeBracket.getIndex() + 1))) {
                    valid = false;
                    errorMessage = errorMessage + "\n Bad Syntax! Do Not Append operator " + scan.get(this.index - 1) + " To " + this.getName();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (valid) {
                int i;
                boolean openBracsOnly = true;
                for (i = this.index - 1; i >= 0; --i) {
                    int compIndex;
                    if (ListReturningStatsOperator.isOpeningBracket(scan.get(i)) && Method.isUnaryPreOperatorORDefinedMethod(scan.get(i - 1)) && (compIndex = Bracket.getComplementIndex(true, i, scan)) > this.closeBracket.getIndex()) {
                        valid = false;
                        errorMessage = errorMessage + "\n Bad Syntax! Do Not Embed " + this.getName() + " In Parentheses Belonging To " + scan.get(i - 1);
                        break;
                    }
                    if (ListReturningStatsOperator.isClosingBracket(scan.get(i)) || Method.isStatsMethod(scan.get(i))) {
                        errorMessage = errorMessage + "\n Ending Backwards Validation For " + this.getName();
                        break;
                    }
                    if (!ListReturningStatsOperator.isOpeningBracket(scan.get(i))) {
                        openBracsOnly = false;
                        errorMessage = errorMessage + "\n MBracket Sequence Established. Trend Finished. Apllying Other Validation Techniques.";
                    }
                    if ((!openBracsOnly || !ListReturningStatsOperator.isBinaryOperator(scan.get(i - 1))) && !Method.isUnaryPreOperatorORDefinedMethod(scan.get(i - 1))) continue;
                    valid = false;
                    errorMessage = errorMessage + "\n Bad Syntax For Data Set Returning Operator " + this.getName() + "\nREASON:::Cannot Perform Binary Operations On Data Set.";
                    break;
                }
                boolean closeBracsOnly = true;
                for (i = this.closeBracket.getIndex() + 1; i < scan.size() && !ListReturningStatsOperator.isOpeningBracket(scan.get(i)) && !Method.isStatsMethod(scan.get(i)); ++i) {
                    if (!ListReturningStatsOperator.isClosingBracket(scan.get(i))) {
                        closeBracsOnly = false;
                    }
                    try {
                        if ((!closeBracsOnly || !ListReturningStatsOperator.isBinaryOperator(scan.get(i + 1))) && !ListReturningStatsOperator.isUnaryPostOperator(scan.get(i + 1))) continue;
                        valid = false;
                        break;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        } else if (this.isSuperParent()) {
            return true;
        }
        return valid;
    }

    public static boolean validateFunction(ArrayList<String> scan) {
        boolean validity = true;
        for (int i = 0; i < scan.size(); ++i) {
            if (!Method.isListReturningStatsMethod(scan.get(i))) continue;
            ListReturningStatsOperator list = new ListReturningStatsOperator(scan.get(i), i, scan);
            validity = list.validate(scan);
            i = list.getCloseBracket().getIndex();
            if (!validity) break;
        }
        return validity;
    }

    public String toString() {
        String objectName = "ListReturningStatsOperator \"" + this.getName() + "\" located @ index " + this.index + " has its opening bracket @ " + this.openBracket.getIndex() + " and its closing bracket at " + this.closeBracket.getIndex() + (this.isSuperParent() ? " and is the root parent of this data set " : " and is not the root parent of this data set ");
        return objectName;
    }
}

