/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.List;
import parser.Bracket;
import parser.CustomScanner;
import parser.LISTS;
import parser.Number;
import parser.Variable;
import parser.methods.Method;

public class DataSetFormatter {
    private List<String> dataset = new ArrayList<String>();
    public static final String COMMA_MASK = "?";
    public static final String OPEN_BRACKET_MASK = "<<<<";
    public static final String CLOSE_BRACKET_MASK = ">>>>";

    public DataSetFormatter(String datastring) {
        this.scanCommaSeparatedData(datastring);
    }

    public void setDataset(ArrayList<String> dataset) {
        this.dataset = dataset;
    }

    public List<String> getDataset() {
        return this.dataset;
    }

    public String getFormattedDataSet() {
        StringBuilder formatted = new StringBuilder();
        for (String c : this.dataset) {
            formatted.append(c);
        }
        return formatted.toString();
    }

    private void processCommasInSingleBracketPair(List<String> sbpList) {
        int indexOfComma = 0;
        int lastIndexCursor = 0;
        while ((indexOfComma = LISTS.nextIndexOf(sbpList, indexOfComma, ",")) != -1) {
            int spaceWidth = indexOfComma - lastIndexCursor;
            sbpList.set(indexOfComma, COMMA_MASK);
            String token = sbpList.get(lastIndexCursor);
            if (!(Bracket.isAtOperator(token) || Method.isListReturningStatsMethod(token) || Method.isFunctionOperatingMethod(token) || spaceWidth <= 2 && (Number.validNumber(token) || Variable.isVariableString(token)))) {
                sbpList.add(indexOfComma, CLOSE_BRACKET_MASK);
                sbpList.add(lastIndexCursor, OPEN_BRACKET_MASK);
                lastIndexCursor = indexOfComma + 3;
                continue;
            }
            lastIndexCursor = indexOfComma + 1;
        }
        int sz = sbpList.size();
        int spaceWidth = sz - lastIndexCursor;
        String token = sbpList.get(lastIndexCursor);
        if (!(Bracket.isAtOperator(token) || Method.isListReturningStatsMethod(token) || Method.isFunctionOperatingMethod(token) || spaceWidth <= 2 && (Number.validNumber(token) || Variable.isVariableString(token)))) {
            sbpList.add(sz, CLOSE_BRACKET_MASK);
            sbpList.add(lastIndexCursor, OPEN_BRACKET_MASK);
        }
    }

    public final void scanCommaSeparatedData(String myStr) {
        int i;
        CustomScanner csc = new CustomScanner(myStr, true, Method.getAllFunctions(), new String[]{",", "(", ")"});
        this.dataset = csc.scan();
        for (i = 0; i < this.dataset.size(); ++i) {
            if (!Bracket.isCloseBracket(this.dataset.get(i))) continue;
            int close = i;
            int open = Bracket.getComplementIndex(false, close, this.dataset);
            this.dataset.set(open, OPEN_BRACKET_MASK);
            this.dataset.set(close, CLOSE_BRACKET_MASK);
            this.processCommasInSingleBracketPair(this.dataset.subList(open + 1, close));
        }
        block11: for (i = 0; i < this.dataset.size(); ++i) {
            String token;
            switch (token = this.dataset.get(i)) {
                case "?": {
                    this.dataset.set(i, ",");
                    continue block11;
                }
                case "<<<<": {
                    this.dataset.set(i, "(");
                    continue block11;
                }
                case ">>>>": {
                    this.dataset.set(i, ")");
                    continue block11;
                }
            }
        }
    }

    public static void main(String[] args) {
        String func = "sum(@(x)x^3+2*x+1,3,@(x)cos(x+4),5,-6,7,-8,8)";
        DataSetFormatter f = new DataSetFormatter(func);
        System.out.println("Before scan-processing, the data = " + func);
        System.out.println("After scan-processing, the dataset = " + f.dataset);
        System.out.println("After scan-processing, the processed string  = " + f.getFormattedDataSet());
    }
}

