/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CustomScannerOld {
    private StringBuilder input;
    private List<String> splittingTokens = new ArrayList<String>();
    private int firstTokenIndex;
    private boolean includeTokensInOutput;

    public CustomScannerOld(String input, boolean includeTokensInOutput, String ... splitterTokens) {
        this.input = new StringBuilder(input);
        this.splittingTokens = Arrays.asList(splitterTokens);
        this.includeTokensInOutput = includeTokensInOutput;
    }

    public CustomScannerOld(String input, boolean includeTokensInOutput, String[] splitterTokens1, String ... splitterTokens2) {
        this.input = new StringBuilder(input);
        this.splittingTokens.addAll(Arrays.asList(splitterTokens1));
        this.splittingTokens.addAll(Arrays.asList(splitterTokens2));
        this.includeTokensInOutput = includeTokensInOutput;
    }

    public CustomScannerOld(String input, boolean includeTokensInOutput, String[] splitterTokens, String[] splitterTokens1, String ... splitterTokens2) {
        this.input = new StringBuilder(input);
        this.splittingTokens.addAll(Arrays.asList(splitterTokens));
        this.splittingTokens.addAll(Arrays.asList(splitterTokens1));
        this.splittingTokens.addAll(Arrays.asList(splitterTokens2));
        this.includeTokensInOutput = includeTokensInOutput;
    }

    private int getLongestSplitterTokenLength() {
        int max = this.splittingTokens.get(0).length();
        int size = this.splittingTokens.size();
        for (int i = 0; i < size; ++i) {
            int newmax = this.splittingTokens.get(i).length();
            if (max >= newmax) continue;
            max = newmax;
        }
        return max;
    }

    private boolean isSplittingToken(String testToken) {
        return this.splittingTokens.indexOf(testToken) != -1;
    }

    private String getFirstSplittingTokenInString() {
        String opString = "";
        int longestSplittingToken = this.getLongestSplitterTokenLength();
        for (int i = 0; i < this.input.length(); ++i) {
            for (int j = longestSplittingToken; j >= 0; --j) {
                try {
                    if (i + j > this.input.length() || !this.isSplittingToken(this.input.substring(i, i + j))) continue;
                    opString = this.input.substring(i, i + j);
                    this.setFirstTokenIndex(i);
                    return opString;
                }
                catch (IndexOutOfBoundsException ind) {
                    ind.printStackTrace();
                }
            }
        }
        return opString;
    }

    public List<String> getFoundTokens() {
        ArrayList<String> split = new ArrayList<String>();
        while (this.input.length() > 0) {
            String op = this.getFirstSplittingTokenInString();
            if (!op.equals("")) {
                split.add(op);
                this.input = new StringBuilder(this.input.substring(this.input.indexOf(op) + op.length()));
                continue;
            }
            if (!op.equals("")) continue;
            break;
        }
        return split;
    }

    public void setFirstTokenIndex(int firstTokenIndex) {
        this.firstTokenIndex = firstTokenIndex;
    }

    public int getFirstTokenIndex() {
        return this.firstTokenIndex;
    }

    public void setIncludeTokensInOutput(boolean includeTokensInOutput) {
        this.includeTokensInOutput = includeTokensInOutput;
    }

    public boolean isIncludeTokensInOutput() {
        return this.includeTokensInOutput;
    }

    public void setInput(String input) {
        this.input = new StringBuilder(input);
    }

    public String getInput() {
        return this.input.toString();
    }

    public void setSplittingTokens(List<String> splittingTokens) {
        this.splittingTokens = splittingTokens;
    }

    public void addSplittingTokens(String ... splittingTokens) {
        this.splittingTokens.addAll(Arrays.asList(splittingTokens));
    }

    public void addSplittingToken(String splittingTokens) {
        this.splittingTokens.add(splittingTokens);
    }

    public void setSplittingTokens(String ... splittingTokens) {
        this.splittingTokens = Arrays.asList(splittingTokens);
    }

    public void setSplittingTokens(String[] splittingTokens, String ... splittingTokens1) {
        this.splittingTokens = Arrays.asList(splittingTokens);
        this.splittingTokens.addAll(Arrays.asList(splittingTokens1));
    }

    public List<String> getSplittingTokens() {
        return this.splittingTokens;
    }

    public List<String> scan() {
        ArrayList<String> scanner = new ArrayList<String>();
        ArrayList<String> filter = new ArrayList<String>();
        filter.add("");
        int opIndex = 2;
        String op = "<><./?>";
        int pass = 0;
        if (this.includeTokensInOutput) {
            while (!op.equals("")) {
                op = this.getFirstSplittingTokenInString();
                opIndex = this.getFirstTokenIndex();
                if (opIndex == 0) {
                    scanner.add(op);
                    this.input = new StringBuilder(this.input.substring(opIndex + op.length()));
                } else {
                    scanner.add(this.input.substring(0, opIndex));
                    scanner.add(op);
                    this.input = new StringBuilder(this.input.substring(opIndex + op.length()));
                }
                op = this.getFirstSplittingTokenInString();
                if (op.equals("")) {
                    scanner.add(this.input.toString());
                }
                ++pass;
            }
            scanner.removeAll(filter);
        } else {
            while (!op.equals("")) {
                op = this.getFirstSplittingTokenInString();
                opIndex = this.getFirstTokenIndex();
                if (opIndex == 0) {
                    this.input = new StringBuilder(this.input.substring(opIndex + op.length()));
                } else {
                    scanner.add(this.input.substring(0, opIndex));
                    this.input = new StringBuilder(this.input.substring(opIndex + op.length()));
                }
                op = this.getFirstSplittingTokenInString();
                if (op.equals("")) {
                    scanner.add(this.input.toString());
                }
                ++pass;
            }
            scanner.removeAll(filter);
        }
        return scanner;
    }

    public static void main(String[] args) {
        String code = "28+32+11-9E12+sin(3.2E9/cos(-3))-sinsinh(5)";
        CustomScannerOld customScanner = new CustomScannerOld(code, true, "sinh", "+", "-", ")", "(", "sin", "cos", "/");
        System.out.println(customScanner.scan());
        customScanner.setInput("3sin2-8cos9/7+12");
        customScanner.setSplittingTokens("sin", "cos", "-", "+", "/");
        customScanner.setIncludeTokensInOutput(false);
        System.out.println(customScanner.scan());
    }
}

