/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import parser.Number;
import parser.Operator;
import parser.Precedence;
import parser.Validatable;
import parser.Variable;
import parser.methods.Method;
import util.Utils;

public class BinaryOperator
extends Operator
implements Validatable {
    private final Precedence precedence;
    private int index;

    public BinaryOperator(String name, int index, ArrayList<String> scan) {
        super(BinaryOperator.isBinaryOperator(name) ? name : "");
        if (this.getName().equals("")) {
            throw new IndexOutOfBoundsException("Invalid Name For Binary Operator.");
        }
        this.index = index >= 0 && scan.get(index).equals(name) ? index : -1;
        this.precedence = Operator.getPrecedence(name);
        if (this.index == -1) {
            throw new IndexOutOfBoundsException("Invalid Index");
        }
    }

    public Precedence getPrecedence() {
        return this.precedence;
    }

    public void setIndex(int index, ArrayList<String> scan) {
        int n = this.index = index >= 0 && scan.get(index).equals(this.getName()) ? index : -1;
        if (this.index == -1) {
            throw new IndexOutOfBoundsException("Invalid Index");
        }
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean validate(ArrayList<String> scan) {
        boolean correct = true;
        try {
            if (BinaryOperator.isPlusOrMinus(scan.get(this.index))) {
                if (!(Number.isNumber(scan.get(this.index - 1)) || Variable.isVariableString(scan.get(this.index - 1)) || BinaryOperator.isUnaryPostOperator(scan.get(this.index - 1)) || BinaryOperator.isClosingBracket(scan.get(this.index - 1)) || BinaryOperator.isOpeningBracket(scan.get(this.index - 1)))) {
                    Utils.logError("ParserNG Does Not Allow " + this.getName() + " To Combine The Function Members \"" + scan.get(this.index - 1) + "\" And \"" + scan.get(this.index) + "\" As You Have Done.ParserNG Error Detector For Binary Operators!");
                    System.out.println(scan);
                    correct = false;
                    scan.clear();
                }
                if (!(Number.isNumber(scan.get(this.index + 1)) || Variable.isVariableString(scan.get(this.index + 1)) || BinaryOperator.isOpeningBracket(scan.get(this.index + 1)) || Method.isUnaryPreOperatorORDefinedMethod(scan.get(this.index + 1)) || Method.isNumberReturningStatsMethod(scan.get(this.index + 1)) || Method.isLogToAnyBase(scan.get(this.index + 1)) || Method.isAntiLogToAnyBase(scan.get(this.index + 1)))) {
                    Utils.logError("ParserNG Does Not Allow " + this.getName() + " To Combine The Function Members \"" + scan.get(this.index) + "\" And \"" + scan.get(this.index + 1) + "\" As You Have Done.ParserNG Error Detector For Binary Operators!");
                    System.out.println(scan);
                    correct = false;
                    scan.clear();
                }
            } else if (!BinaryOperator.isPlusOrMinus(scan.get(this.index))) {
                if (!(Number.isNumber(scan.get(this.index - 1)) || Variable.isVariableString(scan.get(this.index - 1)) || BinaryOperator.isUnaryPostOperator(scan.get(this.index - 1)) || BinaryOperator.isClosingBracket(scan.get(this.index - 1)))) {
                    Utils.logError("ParserNG Does Not Allow " + this.getName() + " To Combine The Function Members \"" + scan.get(this.index - 1) + "\" And \"" + scan.get(this.index) + "\" As You Have Done.ParserNG Error Detector For Binary Operators!");
                    System.out.println(scan);
                    correct = false;
                    scan.clear();
                }
                if (!(Number.isNumber(scan.get(this.index + 1)) || Variable.isVariableString(scan.get(this.index + 1)) || BinaryOperator.isOpeningBracket(scan.get(this.index + 1)) || Method.isUnaryPreOperatorORDefinedMethod(scan.get(this.index + 1)) || Method.isNumberReturningStatsMethod(scan.get(this.index + 1)) || Method.isLogToAnyBase(scan.get(this.index + 1)) || Method.isAntiLogToAnyBase(scan.get(this.index + 1)))) {
                    Utils.logError("ParserNG Does Not Allow " + this.getName() + " To Combine The Function Members \"" + scan.get(this.index) + "\" And \"" + scan.get(this.index + 1) + "\" As You Have Done.ParserNG Error Detector For Binary Operators!");
                    System.out.println(scan);
                    correct = false;
                    scan.clear();
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return correct;
    }
}

