/*
 * Decompiled with CFR 0.152.
 */
package math.tartaglia;

import java.util.ArrayList;
import math.tartaglia.TartagliaExpressionParser;
import math.tartaglia.TartagliaSolver;

public class Tartaglia_Equation {
    private TartagliaExpressionParser parser;
    private TartagliaSolver algorithm;

    public Tartaglia_Equation(String equation) {
        this.parser = new TartagliaExpressionParser(equation);
        ArrayList<Double> coeffs = this.parser.getCoefficients();
        this.algorithm = new TartagliaSolver(coeffs.get(0), coeffs.get(1), coeffs.get(2));
    }

    public void setParser(TartagliaExpressionParser parser) {
        this.parser = parser;
    }

    public TartagliaExpressionParser getParser() {
        return this.parser;
    }

    public void setAlgorithm(TartagliaSolver algorithm) {
        this.algorithm = algorithm;
    }

    public TartagliaSolver getAlgorithm() {
        return this.algorithm;
    }

    public String interpretedSystem() {
        return this.parser.interpretedSystem();
    }

    public String solutions() {
        return this.algorithm.solve();
    }

    public static void main(String[] args) {
        Tartaglia_Equation eqn = new Tartaglia_Equation("-X^3-5X-7=0");
        System.out.println(eqn.solutions());
    }
}

