/*
 * Decompiled with CFR 0.152.
 */
package math.matrix.expressParser;

import math.matrix.expressParser.Matrix;
import math.matrix.expressParser.MatrixValueParser;
import parser.STRING;
import parser.Variable;
import util.Utils;

public class MatrixVariable {
    private String name;
    private Matrix matrix;

    public MatrixVariable(String name, Matrix matrix) {
        if (MatrixVariable.isMatrixVariableName(name)) {
            this.name = name;
            this.matrix = matrix;
        } else {
            Utils.logError("Error In Matrix Name Format.");
        }
    }

    public MatrixVariable(String name, String expression) {
        MatrixValueParser parser = new MatrixValueParser(expression);
        this.name = name;
        this.matrix = parser.getMatrix();
    }

    public void setMatrixVariable(String expression) {
        MatrixValueParser parser = new MatrixValueParser(expression);
        this.matrix = parser.getMatrix();
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreatingExpression() {
        double[][] matArray = this.matrix.getArray();
        String stringvalue = this.name + " = [";
        for (int rows = 0; rows < this.matrix.getRows(); ++rows) {
            for (int cols = 0; cols < this.matrix.getCols(); ++cols) {
                stringvalue = cols < this.matrix.getCols() - 1 ? stringvalue + matArray[rows][cols] + "," : stringvalue + matArray[rows][cols] + ":";
            }
        }
        return stringvalue + "]";
    }

    public static boolean isMatrixVariableName(String name) {
        String n = STRING.purifier(name);
        try {
            if (n.substring(0, 1).equals("#") && n.substring(1).length() > 0) {
                return n.substring(0, 1).equals("#") && Variable.isVariableString(n.substring(1));
            }
            return false;
        }
        catch (IndexOutOfBoundsException indexErr) {
            return false;
        }
    }

    public String toString() {
        return this.name + " = " + this.matrix;
    }

    public static void main(String[] args) {
        MatrixVariable var = new MatrixVariable("#A", "[2,3,7,9,3,4:89,2,-28,12,4,5:,1,1,0,1,0,1:]");
        System.out.println(var);
        MatrixVariable reduced = new MatrixVariable("#B", var.getMatrix().reduceToTriangularMatrix());
        System.out.println(reduced);
        System.out.println(var.getCreatingExpression() + "\n" + reduced.getCreatingExpression());
    }
}

