/*
 * Decompiled with CFR 0.152.
 */
package math.matrix.expressParser;

import java.util.ArrayList;
import math.matrix.expressParser.MUnaryPostOperator;
import parser.MathExpression;
import parser.Precedence;
import parser.UnaryPreOperator;

public class MOperator {
    private String name;

    public MOperator(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static boolean isOperatorString(String op) {
        return op.equals("+") || op.equals("-") || op.equals("*") || op.equals("^") || op.equals("=") || op.equals("(") || op.equals(")") || op.equals("rowJoin") || op.equals("colJoin") || op.equals("tri") || op.equals("|") || op.equals("unit") || op.equals("det") || op.equals(":") || op.equals("-\u00b9") || op.equals("\u00b2") || op.equals("\u00b3") || op.equals(",") || op.equals("[") || op.equals("]");
    }

    public static boolean isRowJoin(String op) {
        return op.equals("rowJoin");
    }

    public static boolean isColJoin(String op) {
        return op.equals("colJoin");
    }

    public boolean isColon(String op) {
        return op.equals(":");
    }

    public static boolean isTri(String op) {
        return op.equals("tri");
    }

    public static boolean isUnit(String op) {
        return op.equals("unit");
    }

    public static boolean isOpeningBrace(String op) {
        return op.equals("[");
    }

    public static boolean isClosingBrace(String op) {
        return op.equals("]");
    }

    public static boolean isAssignmentOperator(String op) {
        return op.equals("=");
    }

    public static boolean isBinaryOperator(String op) {
        return op.equals("+") || op.equals("-") || op.equals("*") || op.equals("^") || op.equals("rowJoin") || op.equals("colJoin");
    }

    public static boolean isPlusOrMinus(String op) {
        return op.equals("+") || op.equals("-");
    }

    public static boolean isMul(String op) {
        return op.equals("*");
    }

    public static boolean isPower(String op) {
        return op.equals("^");
    }

    public static boolean isBracket(String op) {
        return op.equals("(") || op.equals(")");
    }

    public static boolean isOpeningBracket(String op) {
        return op.equals("(");
    }

    public static boolean isClosingBracket(String op) {
        return op.equals(")");
    }

    public static boolean isInverse(String op) {
        return op.equals("-\u00b9");
    }

    public static boolean isDetHalfSymbol(String op) {
        return op.equals("|");
    }

    public static boolean isDet(String op) {
        return op.equals("det");
    }

    public static boolean isSquare(String op) {
        return op.equals("\u00b2");
    }

    public static boolean isCube(String op) {
        return op.equals("\u00b3");
    }

    public static boolean isUnaryPreOperator(String op) {
        return op.equals("det") || op.equals("tri") || op.equals("unit");
    }

    public static boolean isUnaryPostOperator(String op) {
        return op.equals("-\u00b9") || op.equals("\u00b2") || op.equals("\u00b3");
    }

    public static Precedence getPrecedence(String name) {
        if (MOperator.isUnaryPostOperator(name)) {
            return new Precedence(10000);
        }
        if (MOperator.isPower(name)) {
            return new Precedence(9999);
        }
        if (MOperator.isUnaryPreOperator(name)) {
            return new Precedence(9998);
        }
        if (MOperator.isMul(name)) {
            return new Precedence(9997);
        }
        if (MOperator.isPlusOrMinus(name)) {
            return new Precedence(9995);
        }
        return null;
    }

    public static void orderCompoundTokens(MathExpression function) {
        ArrayList<String> scanner = function.getScanner();
        for (int i = 0; i < scanner.size(); ++i) {
            if (!MOperator.isPower(scanner.get(i))) continue;
        }
    }

    public static boolean validateAll(ArrayList<String> scan) {
        boolean correct = true;
        for (int i = 0; i < scan.size(); ++i) {
            if (MOperator.isUnaryPostOperator(scan.get(i))) {
                correct = new MUnaryPostOperator(scan.get(i), i, scan).validate(scan);
                continue;
            }
            if (!MOperator.isUnaryPreOperator(scan.get(i))) continue;
            correct = new UnaryPreOperator(scan.get(i), i, scan).validate(scan);
        }
        return correct;
    }
}

