/*
 * Decompiled with CFR 0.152.
 */
package math.differentialcalculus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import math.differentialcalculus.ExpressionSimplifier;
import math.differentialcalculus.Utilities;
import parser.Number;
import parser.Operator;
import parser.Variable;

public class Formula {
    private String name;
    private List<String> data;
    HashMap<String, List<String>> tokenExponentMap = new HashMap();

    public Formula(String name, List<String> data) {
        this.name = name;
        this.data = data;
    }

    public void setData(List<String> data) {
        this.data = data;
    }

    public List<String> getData() {
        return this.data;
    }

    public static boolean approxEquals(double num1, double num2) {
        return Math.abs((num1 - num2) / num2) <= 1.0E-11;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<String> getVariables() {
        ArrayList<String> vars = new ArrayList<String>();
        for (String s : this.data) {
            if (!Variable.isVariableString(s) || vars.contains(s)) continue;
            vars.add(s);
        }
        return vars;
    }

    public boolean hasSameVariables(Formula formula) {
        ArrayList<String> vars = new ArrayList<String>(this.getVariables());
        ArrayList<String> vars1 = new ArrayList<String>(formula.getVariables());
        vars.removeAll(vars1);
        return vars.isEmpty();
    }

    public double getFactor(Formula formula) {
        boolean sameVariables;
        boolean same = true;
        if (this.data.size() == formula.data.size()) {
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get(i).equals(formula.data.get(i))) continue;
                same = false;
                break;
            }
            if (same) {
                return 1.0;
            }
        }
        if (!(sameVariables = this.hasSameVariables(formula))) {
            return Double.NaN;
        }
        ArrayList<String> vars = this.getVariables();
        ArrayList<String> otherVars = formula.getVariables();
        MultivaluedVariable[] variables = new MultivaluedVariable[vars.size()];
        if (vars.isEmpty() != otherVars.isEmpty()) {
            return Double.NaN;
        }
        if (vars.isEmpty() && otherVars.isEmpty()) {
            ArrayList<String> thisImage = new ArrayList<String>(this.data);
            ArrayList<String> formulaImage = new ArrayList<String>(formula.data);
            String v1 = ExpressionSimplifier.solve(thisImage).get(0);
            String v2 = ExpressionSimplifier.solve(formulaImage).get(0);
            return Double.parseDouble(v1) / Double.parseDouble(v2);
        }
        double[][] values = new double[vars.size()][4];
        Random rnd = new Random();
        for (int rows = 0; rows < values.length; ++rows) {
            for (int cols = 0; cols < values[rows].length; ++cols) {
                values[rows][cols] = (double)(1 + rnd.nextInt(20)) + rnd.nextDouble();
            }
            variables[rows] = new MultivaluedVariable(rows, vars.get(rows), values[rows]);
        }
        boolean sameValue = true;
        double[] ratios = new double[4];
        for (int j = 0; j < variables[0].values.length && sameValue; ++j) {
            int ind;
            int i;
            ArrayList<String> thisImage = new ArrayList<String>(this.data);
            ArrayList<String> formulaImage = new ArrayList<String>(formula.data);
            for (i = 0; i < thisImage.size(); ++i) {
                if (!Variable.isVariableString(thisImage.get(i))) continue;
                for (ind = 0; ind < variables.length && !variables[ind].name.equals(thisImage.get(i)); ++ind) {
                }
                thisImage.set(i, "" + variables[ind].currentValue());
            }
            for (i = 0; i < formulaImage.size(); ++i) {
                if (!Variable.isVariableString(formulaImage.get(i))) continue;
                for (ind = 0; ind < variables.length && !variables[ind].name.equals(formulaImage.get(i)); ++ind) {
                }
                formulaImage.set(i, "" + variables[ind].currentValue());
            }
            String v1 = ExpressionSimplifier.solve(thisImage).get(0);
            String v2 = ExpressionSimplifier.solve(formulaImage).get(0);
            try {
                double thisresult = Double.parseDouble(v1);
                double formularesult = Double.parseDouble(v2);
                ratios[j] = thisresult / formularesult;
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (MultivaluedVariable mv : variables) {
                mv.nextValue();
            }
        }
        for (int i = 1; i < ratios.length; ++i) {
            if (Formula.approxEquals(ratios[i - 1], ratios[i])) continue;
            return Double.NaN;
        }
        return ratios[0];
    }

    public boolean isEquivalentTo(Formula formula) {
        boolean sameVariables;
        boolean same = true;
        if (this.data.size() == formula.data.size()) {
            for (int i = 0; i < this.data.size(); ++i) {
                if (this.data.get(i).equals(formula.data.get(i))) continue;
                same = false;
                break;
            }
            if (same) {
                return same;
            }
        }
        if (!(sameVariables = this.hasSameVariables(formula))) {
            return sameVariables;
        }
        ArrayList<String> vars = this.getVariables();
        MultivaluedVariable[] variables = new MultivaluedVariable[vars.size()];
        if (vars.isEmpty()) {
            String v2;
            ArrayList<String> thisImage = new ArrayList<String>(this.data);
            ArrayList<String> formulaImage = new ArrayList<String>(formula.data);
            String v1 = ExpressionSimplifier.solve(thisImage).get(0);
            if (v1.equals(v2 = ExpressionSimplifier.solve(formulaImage).get(0))) {
                return true;
            }
            try {
                double thisresult = Double.parseDouble(v1);
                double formularesult = Double.parseDouble(v2);
                return Formula.approxEquals(thisresult, formularesult);
            }
            catch (Exception e) {
                return false;
            }
        }
        double[][] values = new double[vars.size()][4];
        Random rnd = new Random();
        for (int rows = 0; rows < values.length; ++rows) {
            for (int cols = 0; cols < values[rows].length; ++cols) {
                values[rows][cols] = (double)(1 + rnd.nextInt(20)) + rnd.nextDouble();
            }
            variables[rows] = new MultivaluedVariable(rows, vars.get(rows), values[rows]);
        }
        boolean sameValue = true;
        for (int j = 0; j < variables[0].values.length && sameValue; ++j) {
            String v2;
            int ind;
            int i;
            ArrayList<String> thisImage = new ArrayList<String>(this.data);
            ArrayList<String> formulaImage = new ArrayList<String>(formula.data);
            for (i = 0; i < thisImage.size(); ++i) {
                if (!Variable.isVariableString(thisImage.get(i))) continue;
                for (ind = 0; ind < variables.length && !variables[ind].name.equals(thisImage.get(i)); ++ind) {
                }
                thisImage.set(i, "" + variables[ind].currentValue());
            }
            for (i = 0; i < formulaImage.size(); ++i) {
                if (!Variable.isVariableString(formulaImage.get(i))) continue;
                for (ind = 0; ind < variables.length && !variables[ind].name.equals(formulaImage.get(i)); ++ind) {
                }
                formulaImage.set(i, "" + variables[ind].currentValue());
            }
            String v1 = ExpressionSimplifier.solve(thisImage).get(0);
            if (v1.equals(v2 = ExpressionSimplifier.solve(formulaImage).get(0))) {
                sameValue = true;
            } else {
                try {
                    double thisresult = Double.parseDouble(v1);
                    double formularesult = Double.parseDouble(v2);
                    sameValue = Formula.approxEquals(thisresult, formularesult);
                }
                catch (Exception e) {
                    sameValue = false;
                }
            }
            for (MultivaluedVariable mv : variables) {
                mv.nextValue();
            }
        }
        return sameValue;
    }

    static void simplifyCompoundTokens(List<String> list) {
        int i;
        if (list.contains("^")) {
            if (list.size() == 3 && Number.isNumber(list.get(0)) && Number.isNumber(list.get(2))) {
                String eval = "" + Math.pow(Double.parseDouble(list.get(0)), Double.parseDouble(list.get(2)));
                list.clear();
                list.add(eval);
                return;
            }
            if (list.size() == 3 && (Variable.isVariableString(list.get(0)) || Number.isNumber(list.get(0))) && (Number.isNumber(list.get(2)) || Variable.isVariableString(list.get(2)))) {
                return;
            }
        } else if (list.size() <= 2) {
            return;
        }
        for (i = 0; i < list.size(); ++i) {
            try {
                if (!Number.isNumber(list.get(i)) || Double.parseDouble(list.get(i)) != 0.0) continue;
                switch (list.get(i - 1)) {
                    case "*": {
                        list.clear();
                        list.add("0");
                        return;
                    }
                    case "/": {
                        list.clear();
                        list.add("Infinity");
                        return;
                    }
                    case "^": {
                        List<String> sub = list.subList(i - 2, i + 1);
                        sub.clear();
                        sub.add("1");
                    }
                }
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        for (i = 0; i < list.size(); ++i) {
            try {
                if (!Number.isNumber(list.get(i)) || !Operator.isPower(list.get(i + 1)) || !Number.isNumber(list.get(i + 2))) continue;
                String eval = "" + Math.pow(Double.parseDouble(list.get(i)), Double.parseDouble(list.get(i + 2)));
                List<String> sub = list.subList(i, i + 3);
                sub.clear();
                sub.add(eval);
                continue;
            }
            catch (IndexOutOfBoundsException eval) {
                // empty catch block
            }
        }
        HashMap<String, ArrayList<String>> powerChainPatterns = new HashMap<String, ArrayList<String>>();
        boolean powerFound = false;
        String recordPatternVariable = "";
        int count = 0;
        int indexOfProductionStart = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String operator = list.get(i2);
            if (Operator.isPower(operator) && !powerFound) {
                powerFound = true;
                recordPatternVariable = "temp_var_" + powerChainPatterns.size();
                indexOfProductionStart = i2 + 1;
                ++count;
                continue;
            }
            if (Operator.isOperatorString(operator) && !Operator.isPower(operator) || i2 == list.size() - 1) {
                powerFound = false;
                List<String> portionOfPattern = list.subList(indexOfProductionStart, i2 == list.size() - 1 ? i2 + 1 : i2);
                if (count >= 2) {
                    powerChainPatterns.put(recordPatternVariable, new ArrayList<String>(portionOfPattern));
                    portionOfPattern.clear();
                    portionOfPattern.add(recordPatternVariable);
                    i2 = indexOfProductionStart + 1;
                }
                recordPatternVariable = "";
                count = 0;
                continue;
            }
            if (!powerFound || !Operator.isPower(operator)) continue;
            ++count;
        }
        HashMap varMap = new HashMap();
        varMap.put("coeff", new ArrayList<String>(Arrays.asList("1")));
        for (int i3 = 0; i3 < list.size(); ++i3) {
            String exponent;
            List value;
            String var;
            List coeff = (List)varMap.get("coeff");
            if (i3 == 0) {
                if (Operator.isPower(list.get(1))) {
                    var = list.get(0);
                    String exponent2 = list.get(2);
                    if (!varMap.containsKey(var)) {
                        varMap.put(var, new ArrayList());
                    }
                    if ((value = (List)varMap.get(var)).isEmpty()) {
                        if (Number.isNumber(exponent2)) {
                            value.add(exponent2);
                            continue;
                        }
                        value.add(exponent2);
                        value.add("1");
                        continue;
                    }
                    if (Number.isNumber(exponent2)) {
                        if (Number.isNumber((String)value.get(0))) {
                            value.set(0, String.valueOf(Double.parseDouble((String)value.get(0)) + Double.parseDouble(exponent2)));
                            continue;
                        }
                        value.add(0, exponent2);
                        continue;
                    }
                    int index = value.indexOf(exponent2);
                    if (index != -1) {
                        String coeffOfExponent = (String)value.get(index + 1);
                        value.set(index + 1, String.valueOf(Double.parseDouble(coeffOfExponent) + 1.0));
                        continue;
                    }
                    value.add(exponent2);
                    value.add("1");
                    continue;
                }
                if (!Operator.isMulOrDiv(list.get(1)) || 1 >= list.size()) continue;
                if (Number.isNumber(list.get(0))) {
                    coeff.set(0, String.valueOf(Double.parseDouble((String)coeff.get(0)) * Double.parseDouble(list.get(0))));
                    continue;
                }
                if (!Variable.isVariableString(list.get(0))) continue;
                var = list.get(0);
                String exponent3 = "1";
                if (!varMap.containsKey(var)) {
                    varMap.put(var, new ArrayList());
                }
                if ((value = (List)varMap.get(var)).isEmpty()) {
                    value.add(exponent3);
                    continue;
                }
                if (Number.isNumber((String)value.get(0))) {
                    value.set(0, String.valueOf(Double.parseDouble((String)value.get(0)) + Double.parseDouble(exponent3)));
                    continue;
                }
                value.add(0, exponent3);
                continue;
            }
            if (i3 == 0) continue;
            if (Operator.isPower(list.get(i3))) {
                String operator = i3 - 2 < 0 ? "" : list.get(i3 - 2);
                String var2 = list.get(i3 - 1);
                String exponent4 = list.get(i3 + 1);
                if (!varMap.containsKey(var2)) {
                    varMap.put(var2, new ArrayList());
                }
                List value2 = (List)varMap.get(var2);
                switch (operator) {
                    case "": {
                        break;
                    }
                    case "*": {
                        String coeffOfExponent;
                        if (value2.isEmpty()) {
                            if (Number.isNumber(exponent4)) {
                                value2.add(exponent4);
                                break;
                            }
                            value2.add(exponent4);
                            value2.add("1");
                            break;
                        }
                        if (Number.isNumber(exponent4)) {
                            if (Number.isNumber((String)value2.get(0))) {
                                value2.set(0, String.valueOf(Double.parseDouble((String)value2.get(0)) + Double.parseDouble(exponent4)));
                                break;
                            }
                            value2.add(0, exponent4);
                            break;
                        }
                        int index = value2.indexOf(exponent4);
                        if (index != -1) {
                            coeffOfExponent = (String)value2.get(index + 1);
                            value2.set(index + 1, String.valueOf(Double.parseDouble(coeffOfExponent) + 1.0));
                            break;
                        }
                        value2.add(exponent4);
                        value2.add("1");
                        break;
                    }
                    case "/": {
                        String coeffOfExponent;
                        if (value2.isEmpty()) {
                            if (Number.isNumber(exponent4)) {
                                value2.add(-1.0 * Double.parseDouble(exponent4) + "");
                                break;
                            }
                            value2.add(exponent4);
                            value2.add("-1");
                            break;
                        }
                        if (Number.isNumber(exponent4)) {
                            if (Number.isNumber((String)value2.get(0))) {
                                value2.set(0, String.valueOf(Double.parseDouble((String)value2.get(0)) - Double.parseDouble(exponent4)));
                                break;
                            }
                            value2.add(0, String.valueOf(0.0 - Double.parseDouble(exponent4)));
                            break;
                        }
                        int index = value2.indexOf(exponent4);
                        if (index != -1) {
                            coeffOfExponent = (String)value2.get(index + 1);
                            value2.set(index + 1, String.valueOf(Double.parseDouble(coeffOfExponent) - 1.0));
                            break;
                        }
                        value2.add(exponent4);
                        value2.add("-1");
                        break;
                    }
                }
                continue;
            }
            if (!Operator.isMulOrDiv(list.get(i3))) continue;
            if (Number.isNumber(list.get(i3 + 1))) {
                if ((i3 + 2 >= list.size() || !Operator.isMulOrDiv(list.get(i3 + 2))) && i3 + 1 != list.size() - 1) continue;
                switch (list.get(i3)) {
                    case "*": {
                        coeff.set(0, String.valueOf(Double.parseDouble((String)coeff.get(0)) * Double.parseDouble(list.get(i3 + 1))));
                        break;
                    }
                    case "/": {
                        coeff.set(0, String.valueOf(Double.parseDouble((String)coeff.get(0)) / Double.parseDouble(list.get(i3 + 1))));
                        break;
                    }
                }
                continue;
            }
            if (!Variable.isVariableString(list.get(i3 + 1)) || (i3 + 2 >= list.size() || !Operator.isMulOrDiv(list.get(i3 + 2))) && i3 + 1 != list.size() - 1) continue;
            var = list.get(i3 + 1);
            String string = exponent = list.get(i3).equals("*") ? "1" : "-1";
            if (!varMap.containsKey(var)) {
                varMap.put(var, new ArrayList());
            }
            if ((value = (List)varMap.get(var)).isEmpty()) {
                value.add(exponent);
                continue;
            }
            if (Number.isNumber((String)value.get(0))) {
                value.set(0, String.valueOf(Double.parseDouble((String)value.get(0)) + Double.parseDouble(exponent)));
                continue;
            }
            value.add(0, exponent);
        }
        Utilities.print("varMap: " + varMap);
        list.clear();
        if (Double.parseDouble((String)((List)varMap.get("coeff")).get(0)) == 0.0) {
            list.add("0");
            return;
        }
        if (Double.parseDouble((String)((List)varMap.get("coeff")).get(0)) == 1.0) {
            list.add("1");
            list.add("*");
        } else {
            list.add((String)((List)varMap.get("coeff")).get(0));
            list.add("*");
        }
        for (Map.Entry entrySet : varMap.entrySet()) {
            double multiplier;
            int i4;
            String key = (String)entrySet.getKey();
            List value = (List)entrySet.getValue();
            if (value.size() == 1 && Double.parseDouble((String)value.get(0)) == 0.0 || key.equals("coeff")) continue;
            list.add(key);
            list.add("^");
            list.add("(");
            boolean hasConstantExp = Number.isNumber((String)value.get(0));
            if (hasConstantExp) {
                i4 = 0;
                while (i4 < value.size()) {
                    if (i4 == 0) {
                        if (Double.parseDouble((String)value.get(0)) != 0.0) {
                            list.add((String)value.get(0));
                        }
                        ++i4;
                        continue;
                    }
                    if (i4 % 2 != 1) continue;
                    multiplier = Double.parseDouble((String)value.get(i4 + 1));
                    if (multiplier < 0.0) {
                        list.add("-");
                        list.add(String.valueOf(Math.abs(multiplier)));
                        list.add("*");
                        list.add((String)value.get(i4));
                    } else if (multiplier > 0.0) {
                        if (!list.get(list.size() - 1).equals("(")) {
                            list.add("+");
                        }
                        if (multiplier == 1.0) {
                            list.add((String)value.get(i4));
                        } else {
                            list.add(String.valueOf(Math.abs(multiplier)));
                            list.add("*");
                            list.add((String)value.get(i4));
                        }
                    }
                    i4 += 2;
                }
            } else {
                for (i4 = 0; i4 < value.size(); i4 += 2) {
                    multiplier = Double.parseDouble((String)value.get(i4 + 1));
                    if (multiplier < 0.0) {
                        list.add("-");
                        list.add(String.valueOf(Math.abs(multiplier)));
                        list.add("*");
                        list.add((String)value.get(i4));
                        continue;
                    }
                    if (!(multiplier > 0.0)) continue;
                    if (!list.get(list.size() - 1).equals("(")) {
                        list.add("+");
                    }
                    if (multiplier == 1.0) {
                        list.add((String)value.get(i4));
                        continue;
                    }
                    list.add(String.valueOf(Math.abs(multiplier)));
                    list.add("*");
                    list.add((String)value.get(i4));
                }
            }
            list.add(")");
            list.add("*");
        }
        list.remove(list.size() - 1);
        for (int i5 = 0; i5 < list.size(); ++i5) {
            String var = list.get(i5);
            if (Operator.isPower(var) && Number.isNumber(list.get(i5 + 1)) && Double.parseDouble(list.get(i5 + 1)) == 1.0) {
                list.remove(i5 + 1);
                list.remove(i5);
                --i5;
            }
            if (Variable.isVariableString(var)) {
                List powerPattern = (List)powerChainPatterns.get(var);
                if (powerPattern == null) continue;
                List<String> sub = list.subList(i5, i5 + 1);
                sub.clear();
                sub.addAll(powerPattern);
                i5 += powerPattern.size() - 1;
                continue;
            }
            if (i5 + 2 >= list.size() || !Operator.isOpeningBracket(var) || !Operator.isClosingBracket(list.get(i5 + 2))) continue;
            list.remove(i5 + 2);
            list.remove(i5);
            i5 -= 2;
        }
    }

    public static void simplify(List<String> list) {
        int i;
        block12: for (int i2 = 0; i2 < list.size(); ++i2) {
            switch (list.get(i2)) {
                case "-\u00b9": {
                    List<String> sub = list.subList(i2, i2 + 1);
                    sub.clear();
                    sub.add("^");
                    sub.add("-1");
                    continue block12;
                }
                case "\u00b2": {
                    List<String> sub = list.subList(i2, i2 + 1);
                    sub.clear();
                    sub.add("^");
                    sub.add("2");
                    continue block12;
                }
                case "\u00b3": {
                    List<String> sub = list.subList(i2, i2 + 1);
                    sub.clear();
                    sub.add("^");
                    sub.add("3");
                }
            }
        }
        if (list.get(0).equals("-") && Number.isNumber(list.get(1))) {
            list.remove(0);
            list.set(0, "" + -1.0 * Double.parseDouble(list.get(0)));
        }
        if (!list.contains("+") && !list.contains("-")) {
            Formula.simplifyCompoundTokens(list);
            return;
        }
        ArrayList<ArrayList<String>> compoundTokens = new ArrayList<ArrayList<String>>();
        String lastOperator = "";
        for (int i3 = 0; i3 < list.size(); ++i3) {
            List<String> subList;
            String operator = list.get(i3);
            if (Operator.isPlusOrMinus(operator)) {
                if (lastOperator.equals("")) {
                    subList = list.subList(0, i3);
                    compoundTokens.add(new ArrayList<String>(subList));
                    subList.clear();
                    i3 = 0;
                } else {
                    subList = list.subList(1, i3);
                    compoundTokens.add(new ArrayList<String>(subList));
                    if (lastOperator.equals("-")) {
                        ((List)compoundTokens.get(compoundTokens.size() - 1)).addAll(0, Arrays.asList("-1", "*"));
                    }
                    list.subList(0, i3).clear();
                    i3 = 0;
                }
                lastOperator = operator;
                continue;
            }
            if (i3 != list.size() - 1) continue;
            if (lastOperator.equals("")) {
                compoundTokens.add(new ArrayList<String>(list));
                list.clear();
                break;
            }
            subList = list.subList(1, list.size());
            compoundTokens.add(new ArrayList<String>(subList));
            if (lastOperator.equals("-")) {
                ((List)compoundTokens.get(compoundTokens.size() - 1)).addAll(0, Arrays.asList("-1", "*"));
            }
            list.clear();
            break;
        }
        ArrayList<List<String>> simplifiedCompoundTokens = new ArrayList<List<String>>();
        for (i = 0; i < compoundTokens.size(); ++i) {
            List compoundToken = (List)compoundTokens.get(i);
            if (compoundToken.isEmpty()) continue;
            Formula f = new Formula("myForm_1", compoundToken);
            double coeff = 1.0;
            for (int j = i + 1; j < compoundTokens.size(); ++j) {
                try {
                    if (((List)compoundTokens.get(j)).isEmpty()) continue;
                    Formula fj = new Formula("myForm_2", (List)compoundTokens.get(j));
                    if (f.isEquivalentTo(fj)) {
                        coeff += 1.0;
                        compoundTokens.remove(j);
                        --j;
                        continue;
                    }
                    double factor = fj.getFactor(f);
                    if (Double.isNaN(factor)) continue;
                    coeff += factor;
                    compoundTokens.remove(j);
                    --j;
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (coeff != 1.0) {
                f.data.add(0, "*");
                f.data.add(0, "" + coeff);
            }
            Formula.simplifyCompoundTokens(f.data);
            simplifiedCompoundTokens.add(f.data);
        }
        list.clear();
        for (i = 0; i < simplifiedCompoundTokens.size(); ++i) {
            if (((List)simplifiedCompoundTokens.get(i)).size() == 1 && Number.isNumber((String)((List)simplifiedCompoundTokens.get(i)).get(0)) && Double.parseDouble((String)((List)simplifiedCompoundTokens.get(i)).get(0)) == 0.0) continue;
            List lst = (List)simplifiedCompoundTokens.get(i);
            if (!lst.isEmpty() && (((String)lst.get(0)).equals("-1") || ((String)lst.get(0)).equals("-1.0"))) {
                if (lst.size() == 1) {
                    lst.add(0, "+");
                    list.addAll(lst);
                    continue;
                }
                if (!((String)lst.get(1)).equals("*")) continue;
                lst.subList(0, 2).clear();
                lst.add(0, "-");
                list.addAll(lst);
                continue;
            }
            if (i != 0) {
                lst.add(0, "+");
            }
            list.addAll(lst);
        }
        for (i = 0; i < list.size(); ++i) {
            if (list.get(i).equals("+") && list.get(i + 1).substring(0, 1).equals("-")) {
                list.set(i, "-");
                list.set(i + 1, list.get(i + 1).substring(1));
                continue;
            }
            if (!list.get(i).equals("-") || !list.get(i + 1).substring(0, 1).equals("-")) continue;
            list.set(i, "+");
            list.set(i + 1, list.get(i + 1).substring(1));
        }
    }

    public String toString() {
        return "(name:" + this.name + ",data:" + this.data + ")";
    }

    private class MultivaluedVariable {
        int index;
        String name;
        int cursor = 0;
        double[] values;

        public MultivaluedVariable(int index, String name, double[] values) {
            this.index = index;
            this.name = name;
            this.values = values;
        }

        public void setCursor(int cursor) {
            this.cursor = cursor;
        }

        public double currentValue() {
            return this.values[this.cursor];
        }

        public double nextValue() {
            this.cursor = this.cursor < this.values.length - 1 ? ++this.cursor : 0;
            return this.values[this.cursor];
        }
    }
}

