/*
 * Decompiled with CFR 0.152.
 */
package math.differentialcalculus;

import java.util.ArrayList;
import java.util.List;
import math.Maths;
import math.differentialcalculus.Formula;
import math.differentialcalculus.FormulaManager;
import math.differentialcalculus.Utilities;
import parser.Bracket;
import parser.Number;
import parser.Operator;
import parser.Variable;

public class ExpressionSimplifier {
    ArrayList<String> scanned;
    FormulaManager manager = new FormulaManager();

    public ExpressionSimplifier(ArrayList<String> scanned) {
        this.scanned = scanned;
        ArrayList<String> duplicate = new ArrayList<String>(scanned);
        for (int i = 0; i < duplicate.size(); ++i) {
            if (duplicate.get(i).equals(")")) {
                int open = Bracket.getComplementIndex(false, i, duplicate);
                List<String> subList = duplicate.subList(open, i + 1);
                subList.remove(0);
                subList.remove(subList.size() - 1);
                Object[] info = this.manager.comparisonData(subList);
                if (Double.parseDouble(info[0].toString()) == 0.0) {
                    int indexOfFormula = (int)Double.parseDouble(info[1].toString());
                    if (Double.parseDouble(info[2].toString()) == 1.0) {
                        try {
                            Formula stored = this.manager.getFormula(indexOfFormula);
                            subList.clear();
                            subList.add(stored.getName());
                        }
                        catch (ClassNotFoundException stored) {}
                    } else {
                        try {
                            double factor = Double.parseDouble(info[2].toString());
                            Formula stored = this.manager.getFormula(indexOfFormula);
                            subList.clear();
                            subList.add("(");
                            subList.add("" + factor);
                            subList.add("*");
                            subList.add(stored.getName());
                            subList.add(")");
                        }
                        catch (ClassNotFoundException factor) {}
                    }
                } else {
                    String name = this.generateName();
                    Formula.simplify(subList);
                    Formula f = new Formula(name, new ArrayList<String>(subList));
                    subList.clear();
                    subList.add(f.getName());
                    this.manager.add(f);
                }
            }
            Utilities.print(duplicate);
        }
    }

    public ArrayList<String> getSimplifiedExpression() {
        this.scanned = this.translateToBaseTerms(this.manager.lastFormula());
        return this.scanned;
    }

    private ArrayList<String> translateToBaseTerms(Formula f) {
        ArrayList<String> data = new ArrayList<String>(f.getData());
        for (int i = 0; i < data.size(); ++i) {
            if (!Utilities.isFormula(data.get(i))) continue;
            String name = data.get(i);
            List<String> temp = data.subList(i, i + 1);
            temp.clear();
            temp.addAll(this.manager.lookUp(name).getData());
            if (temp.size() <= 1) continue;
            temp.add(0, "(");
            temp.add(")");
        }
        return data;
    }

    public static void simplifyCompoundBrackets(List<String> list) {
        ArrayList<String> vars = new ArrayList<String>();
        vars.add("1");
        for (int i = 0; i < list.size(); ++i) {
            if (!Variable.isVariableString(list.get(i)) || vars.contains(list.get(i))) continue;
            vars.add(list.get(i));
            vars.add("0");
        }
    }

    public static List<String> solve(List<String> list) {
        int i;
        boolean isHasPostNumberOperators = false;
        boolean isHasPowerOperators = false;
        boolean isHasPreNumberOperators = false;
        boolean isHasPermOrCombOperators = false;
        boolean isHasMulOrDivOperators = false;
        boolean isHasRemainderOperators = false;
        boolean isHasLogicOperators = false;
        boolean isHasPlusOrMinusOperators = false;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (Operator.isPlusOrMinus(list.get(i2))) {
                isHasPlusOrMinusOperators = true;
                continue;
            }
            if (Operator.isUnaryPreOperator(list.get(i2))) {
                isHasPreNumberOperators = true;
                continue;
            }
            if (Operator.isUnaryPostOperator(list.get(i2))) {
                isHasPostNumberOperators = true;
                continue;
            }
            if (Operator.isMulOrDiv(list.get(i2))) {
                isHasMulOrDivOperators = true;
                continue;
            }
            if (Operator.isPermOrComb(list.get(i2))) {
                isHasPermOrCombOperators = true;
                continue;
            }
            if (Operator.isRemainder(list.get(i2))) {
                isHasRemainderOperators = true;
                continue;
            }
            if (Operator.isPower(list.get(i2))) {
                isHasPowerOperators = true;
                continue;
            }
            if (!Operator.isLogicOperator(list.get(i2))) continue;
            isHasLogicOperators = true;
        }
        if (list.get(0).equals("(") && list.get(1).equals("-") && Number.isNumber(list.get(2))) {
            list.set(1, "");
            if (list.get(2).substring(0, 1).equals("-")) {
                list.set(2, list.get(2).substring(1));
            } else {
                list.set(2, "-" + list.get(2));
            }
        }
        if (list.get(0).equals("-") && Number.isNumber(list.get(1))) {
            list.remove(0);
            list.set(0, "" + -1.0 * Double.parseDouble(list.get(0)));
        }
        ArrayList<String> real = new ArrayList<String>();
        real.add("");
        real.add("(");
        real.add(")");
        list.removeAll(real);
        if (isHasPostNumberOperators) {
            for (i = 0; i < list.size(); ++i) {
                try {
                    if (Operator.isFactorial(list.get(i + 1))) {
                        if (Number.isNumber(list.get(i))) {
                            list.set(i + 1, String.valueOf(Double.valueOf(Maths.fact(list.get(i)))));
                            list.set(i, "");
                            continue;
                        }
                        if (!list.get(i).equals("Infinity")) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i, "");
                        continue;
                    }
                    if (Operator.isSquare(list.get(i + 1))) {
                        if (Number.isNumber(list.get(i))) {
                            list.set(i + 1, String.valueOf(Math.pow(Double.valueOf(list.get(i)), 2.0)));
                            list.set(i, "");
                            continue;
                        }
                        if (!list.get(i).equals("Infinity")) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i, "");
                        continue;
                    }
                    if (Operator.isCube(list.get(i + 1))) {
                        if (Number.isNumber(list.get(i))) {
                            list.set(i + 1, String.valueOf(Math.pow(Double.valueOf(list.get(i)), 3.0)));
                            list.set(i, "");
                            continue;
                        }
                        if (!list.get(i).equals("Infinity")) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i, "");
                        continue;
                    }
                    if (!Operator.isInverse(list.get(i + 1))) continue;
                    if (Number.isNumber(list.get(i))) {
                        list.set(i + 1, String.valueOf(1.0 / Double.valueOf(list.get(i))));
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i).equals("Infinity")) continue;
                    list.set(i + 1, "0.0");
                    list.set(i, "");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        if (isHasPowerOperators) {
            for (i = 0; i < list.size(); ++i) {
                try {
                    if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (!list.get(i).equals("^") || !Number.isNumber(list.get(i - 1)) || !Number.isNumber(list.get(i + 1))) continue;
                        list.set(i + 1, String.valueOf(Math.pow(Double.valueOf(list.get(i - 1)), Double.valueOf(list.get(i + 1)))));
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (Double.valueOf(list.get(i + 1)) > 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) == 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) < 1.0 && Double.valueOf(list.get(i + 1)) > 0.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) < 1.0 && Double.valueOf(list.get(i + 1)) == 0.0) {
                            list.set(i + 1, "1.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!(Double.valueOf(list.get(i + 1)) < 1.0) || !(Double.valueOf(list.get(i + 1)) < 0.0)) continue;
                        list.set(i + 1, "0.0");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                        if (Double.valueOf(list.get(i - 1)) > 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) == 1.0) {
                            list.set(i + 1, "1.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) < 1.0 && Double.valueOf(list.get(i - 1)) > 0.0) {
                            list.set(i + 1, "0.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) < 1.0 && Double.valueOf(list.get(i - 1)) == 0.0) {
                            list.set(i + 1, "0.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!(Double.valueOf(list.get(i - 1)) < 1.0) || !(Double.valueOf(list.get(i - 1)) < 0.0)) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                    list.set(i + 1, "Infinity");
                    list.set(i - 1, "");
                    list.set(i, "");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        if (isHasPreNumberOperators) {
            for (i = list.size() - 1; i >= 0; --i) {
                try {
                    if (!list.get(i + 1).equals("Infinity") && Number.isNumber(list.get(i + 1))) {
                        if (!list.get(i).equals("\u221a")) continue;
                        list.set(i, String.valueOf(Math.sqrt(Double.valueOf(list.get(i + 1)))));
                        list.set(i + 1, "");
                        continue;
                    }
                    if (!list.get(i + 1).equals("Infinity")) continue;
                    list.set(i, "Infinity");
                    list.set(i + 1, "");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        list.removeAll(real);
        if (isHasPowerOperators) {
            for (i = 0; i < list.size(); ++i) {
                try {
                    if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (!list.get(i).equals("^") || !Number.isNumber(list.get(i - 1)) || !Number.isNumber(list.get(i + 1))) continue;
                        list.set(i + 1, String.valueOf(Math.pow(Double.valueOf(list.get(i - 1)), Double.valueOf(list.get(i + 1)))));
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        if (Double.valueOf(list.get(i + 1)) > 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) == 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) < 1.0 && Double.valueOf(list.get(i + 1)) > 0.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i + 1)) < 1.0 && Double.valueOf(list.get(i + 1)) == 0.0) {
                            list.set(i + 1, "1.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!(Double.valueOf(list.get(i + 1)) < 1.0) || !(Double.valueOf(list.get(i + 1)) < 0.0)) continue;
                        list.set(i + 1, "0.0");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                        if (Double.valueOf(list.get(i - 1)) > 1.0) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) == 1.0) {
                            list.set(i + 1, "1.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) < 1.0 && Double.valueOf(list.get(i - 1)) > 0.0) {
                            list.set(i + 1, "0.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (Double.valueOf(list.get(i - 1)) < 1.0 && Double.valueOf(list.get(i - 1)) == 0.0) {
                            list.set(i + 1, "0.0");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!(Double.valueOf(list.get(i - 1)) < 1.0) || !(Double.valueOf(list.get(i - 1)) < 0.0)) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                    list.set(i + 1, "Infinity");
                    list.set(i - 1, "");
                    list.set(i, "");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        list.removeAll(real);
        if (isHasPermOrCombOperators) {
            for (i = 0; i < list.size(); ++i) {
                try {
                    if (list.get(i).equals("\u0420")) {
                        if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                            list.set(i + 1, String.valueOf(Double.valueOf(Maths.fact(list.get(i - 1))) / Double.valueOf(Maths.fact(String.valueOf(Double.valueOf(list.get(i - 1)) - Double.valueOf(list.get(i + 1)))))));
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                            list.set(i + 1, "Infinity");
                            list.set(i - 1, "");
                            list.set(i, "");
                            continue;
                        }
                        if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i).equals("\u010c")) continue;
                    if (!list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        list.set(i + 1, String.valueOf(Double.valueOf(Maths.fact(list.get(i - 1))) / (Double.valueOf(Maths.fact(String.valueOf(Double.valueOf(list.get(i - 1)) - Double.valueOf(list.get(i + 1))))) * Double.valueOf(Maths.fact(list.get(i + 1))))));
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (list.get(i - 1).equals("Infinity") && !list.get(i + 1).equals("Infinity")) {
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") && list.get(i + 1).equals("Infinity")) {
                        list.set(i + 1, "Infinity");
                        list.set(i - 1, "");
                        list.set(i, "");
                        continue;
                    }
                    if (!list.get(i - 1).equals("Infinity") || !list.get(i + 1).equals("Infinity")) continue;
                    list.set(i + 1, "Infinity");
                    list.set(i - 1, "");
                    list.set(i, "");
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        boolean skip = false;
        if (isHasMulOrDivOperators || isHasRemainderOperators || isHasLogicOperators) {
            for (int i3 = 0; i3 < list.size(); ++i3) {
                try {
                    if (list.get(i3).equals("*")) {
                        if (!list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, String.valueOf(Double.valueOf(list.get(i3 - 1)) * Double.valueOf(list.get(i3 + 1))));
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                            skip = true;
                        } else if (list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "Infinity");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                            skip = true;
                        } else if (!list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "Infinity");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                            skip = true;
                        } else if (list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "Infinity");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                            skip = true;
                        }
                    } else if (list.get(i3).equals("/")) {
                        if (!list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, String.valueOf(Double.valueOf(list.get(i3 - 1)) / Double.valueOf(list.get(i3 + 1))));
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                            skip = true;
                        } else if (list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "Infinity");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                            skip = true;
                        } else if (!list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "0.0");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                            skip = true;
                        } else if (list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "Infinity");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                            skip = true;
                        }
                    } else if (list.get(i3).equals("%")) {
                        if (!list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, String.valueOf(Double.valueOf(list.get(i3 - 1)) % Double.valueOf(list.get(i3 + 1))));
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                            skip = true;
                        } else if (list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "Infinity");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                            skip = true;
                        } else if (!list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, list.get(i3 - 1));
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                            skip = true;
                        } else if (list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "Infinity");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                            skip = true;
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                if (skip) continue;
                try {
                    if (list.get(i3).equals("==")) {
                        if (!list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, String.valueOf(Double.valueOf(list.get(i3 - 1)) - Double.valueOf(list.get(i3 + 1)) == 0.0));
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        } else if (list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "false");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        } else if (!list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "false");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        } else if (list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "true");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    if (list.get(i3).equals(">")) {
                        if (!list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, String.valueOf(Double.valueOf(list.get(i3 - 1)) - Double.valueOf(list.get(i3 + 1)) > 0.0));
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        } else if (list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "true");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        } else if (!list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "false");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        } else if (list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "true");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    if (list.get(i3).equals("\u2265")) {
                        if (!list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, String.valueOf(Double.valueOf(list.get(i3 - 1)) - Double.valueOf(list.get(i3 + 1)) >= 0.0));
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        } else if (list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "true");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        } else if (!list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "false");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        } else if (list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "true");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    if (list.get(i3).equals("<")) {
                        if (!list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, String.valueOf(Double.valueOf(list.get(i3 - 1)) - Double.valueOf(list.get(i3 + 1)) < 0.0));
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        } else if (list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "false");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        } else if (!list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "true");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        } else if (list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                            list.set(i3 + 1, "true");
                            list.set(i3 - 1, "");
                            list.set(i3, "");
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    if (!list.get(i3).equals("\u2264")) continue;
                    if (!list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                        list.set(i3 + 1, String.valueOf(Double.valueOf(list.get(i3 - 1)) - Double.valueOf(list.get(i3 + 1)) <= 0.0));
                        list.set(i3 - 1, "");
                        list.set(i3, "");
                        continue;
                    }
                    if (list.get(i3 - 1).equals("Infinity") && !list.get(i3 + 1).equals("Infinity")) {
                        list.set(i3 + 1, "false");
                        list.set(i3 - 1, "");
                        list.set(i3, "");
                        continue;
                    }
                    if (!list.get(i3 - 1).equals("Infinity") && list.get(i3 + 1).equals("Infinity")) {
                        list.set(i3 + 1, "true");
                        list.set(i3 - 1, "");
                        list.set(i3, "");
                        continue;
                    }
                    if (!list.get(i3 - 1).equals("Infinity") || !list.get(i3 + 1).equals("Infinity")) continue;
                    list.set(i3 + 1, "true");
                    list.set(i3 - 1, "");
                    list.set(i3, "");
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            list.removeAll(real);
        }
        if (isHasPlusOrMinusOperators) {
            for (int i4 = 0; i4 < list.size(); ++i4) {
                try {
                    if (!list.get(i4).equals("+") && !list.get(i4).equals("-")) continue;
                    if (!list.get(i4 - 1).equals("Infinity") && !list.get(i4 + 1).equals("Infinity")) {
                        if (list.get(i4).equals("+") && Number.isNumber(list.get(i4 - 1)) && Number.isNumber(list.get(i4 + 1))) {
                            list.set(i4 + 1, String.valueOf(Double.valueOf(list.get(i4 - 1)) + Double.valueOf(list.get(i4 + 1))));
                            list.set(i4 - 1, "");
                            list.set(i4, "");
                            continue;
                        }
                        if (!list.get(i4).equals("-") || !Number.isNumber(list.get(i4 - 1)) || !Number.isNumber(list.get(i4 + 1))) continue;
                        list.set(i4 + 1, String.valueOf(Double.valueOf(list.get(i4 - 1)) - Double.valueOf(list.get(i4 + 1))));
                        list.set(i4 - 1, "");
                        list.set(i4, "");
                        continue;
                    }
                    list.set(i4 + 1, "Infinity");
                    list.set(i4 - 1, "");
                    list.set(i4, "");
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        real.add("(");
        real.add(")");
        list.removeAll(real);
        if (list.size() != 1) {
            // empty if block
        }
        return list;
    }

    private String generateName() {
        int count = this.manager.count();
        return "myForm_" + count;
    }
}

