/*
 * Decompiled with CFR 0.152.
 */
package math.differentialcalculus;

import java.util.ArrayList;
import math.differentialcalculus.Methods;
import parser.Bracket;
import parser.CustomScanner;
import parser.Operator;
import parser.STRING;
import parser.Variable;

public class DerivativeScanner {
    String expression;
    private ArrayList<String> scanner;
    private boolean syntaxValid;

    public DerivativeScanner(String expression) throws Exception {
        expression = STRING.replaceAll(expression, "\u00b3\u221a", "\\cbrt//_\\temp//");
        expression = STRING.replaceAll(expression, "\u00b2", "^2");
        expression = STRING.replaceAll(expression, "\u00b3", "^3");
        expression = STRING.replaceAll(expression, "+-", "-");
        expression = STRING.replaceAll(expression, "-+", "-");
        expression = STRING.replaceAll(expression, "--", "+");
        if (expression.contains("\\cbrt//_\\temp//")) {
            expression = expression.replace("\\cbrt//_\\temp//", "\u00b3\u221a");
        }
        for (int i = 0; i < expression.length(); ++i) {
            try {
                if (expression.substring(i, i + 1).equals("\u03c0")) {
                    expression = STRING.replace(expression, "pi", i, i + 1);
                    continue;
                }
                if (expression.substring(i, i + 1).equals("\u00d7")) {
                    expression = STRING.replace(expression, "*", i, i + 1);
                    continue;
                }
                if (!expression.substring(i, i + 1).equals("\u00f7")) continue;
                expression = STRING.replace(expression, "/", i, i + 1);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        StringBuilder expr = new StringBuilder(expression);
        for (int i = 0; i < expr.length(); ++i) {
            if (expr.substring(i, i + 1).equals("-") && expr.substring(i + 1, i + 2).equals("-")) {
                expr.replace(i, i + 2, "+");
                --i;
            }
            if (expr.substring(i, i + 1).equals("-") && expr.substring(i + 1, i + 2).equals("+")) {
                expr.replace(i, i + 2, "-");
                --i;
            }
            if (expr.substring(i, i + 1).equals("+") && expr.substring(i + 1, i + 2).equals("+")) {
                expr.replace(i, i + 2, "+");
                --i;
            }
            if (!expr.substring(i, i + 1).equals("+") || !expr.substring(i + 1, i + 2).equals("-")) continue;
            expr.replace(i, i + 2, "-");
            --i;
        }
        this.expression = expression = expr.toString();
        CustomScanner cs = new CustomScanner(expression, true, Methods.inbuiltMethods, Methods.inbuiltOperators);
        this.scanner = (ArrayList)cs.scan();
        this.orderNumberTokens();
        this.syntaxAnalyzer();
    }

    public static boolean isNumber(String token) {
        try {
            double val = Double.parseDouble(token);
            return true;
        }
        catch (Exception numErr) {
            return false;
        }
    }

    private static boolean isValidOperatorOrMethod(String op) {
        for (String value : Methods.inbuiltMethods) {
            if (!op.equals(value)) continue;
            return true;
        }
        for (String value : Methods.inbuiltOperators) {
            if (!op.equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean syntaxAnalyzer() throws Exception {
        String token = "";
        for (int count = 0; count < this.scanner.size(); ++count) {
            token = this.scanner.get(count);
            if (!(DerivativeScanner.isNumber(token) || Variable.isVariableString(token) || DerivativeScanner.isValidOperatorOrMethod(token))) {
                System.out.println("Invalid " + token + " found!");
                this.scanner.clear();
                throw new Exception("Syntax Error Found During Scanning");
            }
            if (count >= this.scanner.size() - 1 || !Methods.isInbuiltMethodName(token) || Operator.isOpeningBracket(this.scanner.get(count + 1))) continue;
            System.out.println("Cannot use an inbuilt method name as a variable name.");
            this.scanner.clear();
            throw new Exception("Syntax Error Found During Scanning");
        }
        this.syntaxValid = true;
        return true;
    }

    public void setSyntaxValid(boolean syntaxValid) {
        this.syntaxValid = syntaxValid;
    }

    public boolean isSyntaxValid() {
        return this.syntaxValid;
    }

    public void setScanner(ArrayList<String> scanner) {
        this.scanner = scanner;
    }

    public ArrayList<String> getScanner() {
        return this.scanner;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    private void orderNumberTokens() {
        int sz = this.scanner.size();
        for (int i = 0; i < (sz = this.scanner.size()); ++i) {
            if (i > 0 && i < sz - 1) {
                int len;
                String token = this.scanner.get(i);
                String prevToken = this.scanner.get(i - 1);
                String nextToken = this.scanner.get(i + 1);
                if ((token.equals("+") || token.equals("-")) && (len = prevToken.length()) > 1 && DerivativeScanner.isNumber(prevToken.substring(0, len - 1)) && !DerivativeScanner.isNumber(prevToken.substring(0, len)) && prevToken.substring(len - 1).equalsIgnoreCase("E") && DerivativeScanner.isNumber(nextToken)) {
                    StringBuilder sb = new StringBuilder(prevToken);
                    sb.append(token);
                    sb.append(nextToken);
                    this.scanner.set(i - 1, sb.substring(0, sb.length()));
                    this.scanner.subList(i, i + 2).clear();
                    --i;
                }
            }
            if (Operator.isOpeningBracket(this.scanner.get(i)) && this.scanner.get(i + 1).equals("-") && Variable.isVariableString(this.scanner.get(i + 2))) {
                this.scanner.set(i + 1, "-1");
                this.scanner.add(i + 2, "*");
                continue;
            }
            if (Operator.isPower(this.scanner.get(i)) && this.scanner.get(i + 1).equals("-") && Variable.isVariableString(this.scanner.get(i + 2))) {
                if (Operator.isOpeningBracket(this.scanner.get(i + 3))) {
                    int close = Bracket.getComplementIndex(true, i + 3, this.scanner);
                    this.scanner.add(close, ")");
                    this.scanner.add(i + 2, "*");
                    this.scanner.set(i + 1, "-1");
                    this.scanner.add(i + 1, "(");
                    continue;
                }
                this.scanner.add(i + 3, ")");
                this.scanner.add(i + 2, "*");
                this.scanner.set(i + 1, "-1");
                this.scanner.add(i + 1, "(");
                continue;
            }
            if (Operator.isPower(this.scanner.get(i)) && this.scanner.get(i + 1).equals("-") && DerivativeScanner.isNumber(this.scanner.get(i + 2))) {
                this.scanner.set(i + 1, "-" + this.scanner.get(i + 2));
                this.scanner.remove(i + 2);
                continue;
            }
            if (Operator.isMulOrDiv(this.scanner.get(i)) && this.scanner.get(i + 1).equals("-") && DerivativeScanner.isNumber(this.scanner.get(i + 2))) {
                this.scanner.set(i + 1, "-" + this.scanner.get(i + 2));
                this.scanner.remove(i + 2);
                continue;
            }
            if (!Operator.isPlusOrMinus(this.scanner.get(i)) || !this.scanner.get(i + 1).equals("-") || !DerivativeScanner.isNumber(this.scanner.get(i + 2))) continue;
            if (this.scanner.get(i).equals("+")) {
                this.scanner.set(i, "-");
                this.scanner.remove(i + 1);
                continue;
            }
            this.scanner.set(i, "+");
            this.scanner.remove(i + 1);
        }
    }

    public static void main(String[] args) {
        try {
            String expression = "1/x^-2.22+sin(myDiff_3)/(myDiff_2)*diff(myDiff_2)";
            DerivativeScanner ds = new DerivativeScanner(expression);
            System.out.println(ds.scanner);
        }
        catch (Exception expression) {
            // empty catch block
        }
        String a = "abcdratatouille";
        a = a.replace("rat", "cat");
        System.out.println(a);
    }
}

