/*
 * Decompiled with CFR 0.152.
 */
package math.complex;

import math.complex.ComplexState;

public class ComplexNumber {
    private double real;
    private double imag;
    public static final String radical = "i";
    private ComplexState state = ComplexState.CARTESIAN;

    public ComplexNumber(double real, double imag, ComplexState state) {
        this.state = state;
        if (state.isCartesian()) {
            this.real = real;
            this.imag = imag;
        } else if (state.isPolar() || state.isExponential()) {
            this.real = real * Math.cos(imag);
            this.imag = real * Math.sin(imag);
        }
        this.state = ComplexState.CARTESIAN;
    }

    public double getImag() {
        return this.imag;
    }

    public void setImag(double imag) {
        this.imag = imag;
    }

    public double getReal() {
        return this.real;
    }

    public void setReal(double real) {
        this.real = real;
    }

    public static String getRadical() {
        return radical;
    }

    public void setState(ComplexState state) {
        this.state = state;
    }

    public ComplexState getState() {
        return this.state;
    }

    public double getAngle() {
        if (this.state.isCartesian()) {
            return Math.atan(this.imag / this.real);
        }
        return this.imag;
    }

    public double getRadius() {
        if (this.state.isPolar()) {
            return this.abs();
        }
        return this.real;
    }

    public ComplexNumber add(ComplexNumber complexNumber) {
        return new ComplexNumber(this.real + complexNumber.real, this.imag + complexNumber.imag, this.state);
    }

    public ComplexNumber minus(ComplexNumber complexNumber) {
        return new ComplexNumber(this.real - complexNumber.real, this.imag - complexNumber.imag, this.state);
    }

    public ComplexNumber multiply(ComplexNumber complexNumber) {
        double a = this.real;
        double b = this.imag;
        double c = complexNumber.real;
        double d = complexNumber.imag;
        return new ComplexNumber(a * c - b * d, a * d + b * c, this.state);
    }

    public ComplexNumber divide(ComplexNumber complexNumber) {
        double a = this.real;
        double b = this.imag;
        double c = complexNumber.real;
        double d = complexNumber.imag;
        return new ComplexNumber((a * c + b * c + b * d) / (c * c + d * d), a * d / (c * c + d * d), this.state);
    }

    public ComplexNumber scalarDivide(double number) {
        return new ComplexNumber(this.real / number, this.imag / number, ComplexState.CARTESIAN);
    }

    public ComplexNumber scalarMultiply(double number) {
        return new ComplexNumber(this.real * number, this.imag * number, ComplexState.CARTESIAN);
    }

    public ComplexNumber getConjugate() {
        return new ComplexNumber(this.real, -this.imag, ComplexState.CARTESIAN);
    }

    public double abs() {
        double a = this.real;
        double b = this.imag;
        return Math.sqrt(a * a + b * b);
    }

    public ComplexNumber log() {
        return new ComplexNumber(Math.log(this.getRadius()), this.getAngle(), ComplexState.CARTESIAN);
    }

    public ComplexNumber exp() {
        return new ComplexNumber(Math.exp(this.real) * Math.cos(this.imag), Math.exp(this.real) * Math.sin(this.imag), ComplexState.CARTESIAN);
    }

    public ComplexNumber inverse() {
        double den = this.real * this.real + this.imag * this.imag;
        return new ComplexNumber(this.real / den, -this.imag / den, ComplexState.CARTESIAN);
    }

    public ComplexNumber pow(double n) {
        double r = this.abs();
        return new ComplexNumber(Math.pow(r, n), n * this.getAngle(), ComplexState.POLAR);
    }

    public ComplexNumber sin() {
        return new ComplexNumber(Math.sin(this.real) * Math.cosh(this.imag), Math.cos(this.real) * Math.sinh(this.imag), ComplexState.CARTESIAN);
    }

    public ComplexNumber cos() {
        return new ComplexNumber(Math.cos(this.real) * Math.cosh(this.imag), -Math.sin(this.real) * Math.sinh(this.imag), ComplexState.CARTESIAN);
    }

    public ComplexNumber tan() {
        double tanreal = Math.tan(this.real);
        double tanhimag = Math.tanh(this.imag);
        double sechImag = 1.0 / Math.cosh(this.imag);
        double secReal = 1.0 / Math.cos(this.real);
        double den = 1.0 - tanreal * tanreal * tanhimag * tanhimag;
        return new ComplexNumber(tanreal * sechImag * sechImag / den, tanhimag * secReal * secReal / den, ComplexState.CARTESIAN);
    }

    public ComplexNumber sec() {
        return this.cos().inverse();
    }

    public ComplexNumber csc() {
        return this.sin().inverse();
    }

    public ComplexNumber cot() {
        return this.tan().inverse();
    }

    public ComplexNumber sinh() {
        return new ComplexNumber(Math.sinh(this.real) * Math.cos(this.imag), Math.cosh(this.real) * Math.sin(this.imag), ComplexState.CARTESIAN);
    }

    public ComplexNumber cosh() {
        return new ComplexNumber(Math.cosh(this.real) * Math.cos(this.imag), Math.sinh(this.real) * Math.sin(this.imag), ComplexState.CARTESIAN);
    }

    public ComplexNumber tanh() {
        double tanhreal = Math.tanh(this.real);
        double tanimag = Math.tan(this.imag);
        double secImag = 1.0 / Math.cos(this.imag);
        double sechReal = 1.0 / Math.cosh(this.real);
        double den = 1.0 + tanhreal * tanhreal * tanimag * tanimag;
        return new ComplexNumber(tanhreal * secImag * secImag / den, -tanimag * sechReal * sechReal / den, ComplexState.CARTESIAN);
    }

    public ComplexNumber sech() {
        return this.cosh().inverse();
    }

    public ComplexNumber csch() {
        return this.sinh().inverse();
    }

    public ComplexNumber coth() {
        return this.tanh().inverse();
    }

    public String toString() {
        String comp = this.real + "+" + this.imag + radical;
        comp = comp.replace("+-", "-");
        comp = comp.replace("-+", "-");
        comp = comp.replace("--", "+");
        comp = comp.replace("++", "+");
        return comp;
    }

    public static void main(String[] args) {
        ComplexNumber Z = new ComplexNumber(2.0, -3.5, ComplexState.CARTESIAN);
        ComplexNumber Z1 = new ComplexNumber(2.0, -3.5, ComplexState.CARTESIAN);
        System.out.println(Z.sin().pow(2.0).add(Z.cos().pow(2.0)));
    }
}

