/*
 * Decompiled with CFR 0.152.
 */
package math;

import math.Line;
import util.SimplePoint;

public class Point {
    public double x;
    public double y;
    public double z;

    public Point() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Point(double x) {
        this.x = x;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
        this.z = 0.0;
    }

    public Point(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point(Point point) {
        this.x = point.x;
        this.y = point.y;
        this.z = point.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getZ() {
        return this.z;
    }

    public double calcDistanceTo(Point pt) {
        return Math.sqrt(Math.pow(this.x - pt.x, 2.0) + Math.pow(this.y - pt.y, 2.0) + Math.pow(this.z - pt.z, 2.0));
    }

    public double findXYGrad(Point pt) {
        return (this.y - pt.y) / (this.x - pt.x);
    }

    public double findXZGrad(Point pt) {
        return (this.z - pt.z) / (this.x - pt.x);
    }

    public double findYZGrad(Point pt) {
        return (this.z - pt.z) / (this.y - pt.y);
    }

    public SimplePoint getUtilPoint() {
        return new SimplePoint((int)this.x, (int)this.y);
    }

    public static SimplePoint getUtilPoint(Point point) {
        return new SimplePoint((int)point.x, (int)point.y);
    }

    public static Point midPoint(Point p1, Point p2) {
        return new Point(0.5 * (p1.x + p2.x), 0.5 * (p1.y + p2.y));
    }

    public boolean isCollinearWith(Point p1, Point p2) {
        Line line = new Line(p1, p2);
        return line.passesThroughPoint(this);
    }

    public boolean liesBetween(Point p1, Point p2) {
        boolean truly1 = p1.x <= this.x && p2.x >= this.x || p2.x <= this.x && p1.x >= this.x;
        boolean truly2 = p1.y <= this.y && p2.y >= this.y || p2.y <= this.y && p1.y >= this.y;
        boolean truly3 = p1.z <= this.z && p2.z >= this.z || p2.z <= this.z && p1.z >= this.z;
        return truly1 && truly2 && truly3 && this.isCollinearWith(p1, p2);
    }

    public String toString() {
        if (this.z == 0.0) {
            return "(" + this.x + ", " + this.y + ")";
        }
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public static void main(String[] args) {
        Point p1 = new Point(1.0, 5.0);
        Point p2 = new Point(2.0, 8.0);
        Point p3 = new Point(10.0, 32.0);
        System.out.println(p1.liesBetween(p2, p3));
    }
}

