/*
 * Decompiled with CFR 0.152.
 */
package com.github.gabrielbb.cutout;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.os.AsyncTask;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import com.github.gabrielbb.cutout.BitmapUtility;
import java.lang.ref.WeakReference;
import java.util.Stack;

class DrawView
extends View {
    private Path livePath;
    private Paint pathPaint;
    private Bitmap imageBitmap;
    private final Stack<Pair<Pair<Path, Paint>, Bitmap>> cuts = new Stack();
    private final Stack<Pair<Pair<Path, Paint>, Bitmap>> undoneCuts = new Stack();
    private float pathX;
    private float pathY;
    private static final float TOUCH_TOLERANCE = 4.0f;
    private static final float COLOR_TOLERANCE = 20.0f;
    private Button undoButton;
    private Button redoButton;
    private View loadingModal;
    private DrawViewAction currentAction;

    public DrawView(Context c, AttributeSet attrs) {
        super(c, attrs);
        this.livePath = new Path();
        this.pathPaint = new Paint(1);
        this.pathPaint.setDither(true);
        this.pathPaint.setColor(0);
        this.pathPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.pathPaint.setStyle(Paint.Style.STROKE);
        this.pathPaint.setStrokeJoin(Paint.Join.ROUND);
        this.pathPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    public void setButtons(Button undoButton, Button redoButton) {
        this.undoButton = undoButton;
        this.redoButton = redoButton;
    }

    protected void onSizeChanged(int newWidth, int newHeight, int oldWidth, int oldHeight) {
        super.onSizeChanged(newWidth, newHeight, oldWidth, oldHeight);
        this.resizeBitmap(newWidth, newHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        if (this.imageBitmap != null) {
            canvas.drawBitmap(this.imageBitmap, 0.0f, 0.0f, null);
            for (Pair pair : this.cuts) {
                if (pair.first == null) continue;
                canvas.drawPath((Path)((Pair)pair.first).first, (Paint)((Pair)pair.first).second);
            }
            if (this.currentAction == DrawViewAction.MANUAL_CLEAR) {
                canvas.drawPath(this.livePath, this.pathPaint);
            }
        }
        canvas.restore();
    }

    private void touchStart(float x, float y) {
        this.pathX = x;
        this.pathY = y;
        this.undoneCuts.clear();
        this.redoButton.setEnabled(false);
        if (this.currentAction == DrawViewAction.AUTO_CLEAR) {
            new AutomaticPixelClearingTask(this).execute(new Integer[]{(int)x, (int)y});
        } else {
            this.livePath.moveTo(x, y);
        }
        this.invalidate();
    }

    private void touchMove(float x, float y) {
        if (this.currentAction == DrawViewAction.MANUAL_CLEAR) {
            float dx = Math.abs(x - this.pathX);
            float dy = Math.abs(y - this.pathY);
            if (dx >= 4.0f || dy >= 4.0f) {
                this.livePath.quadTo(this.pathX, this.pathY, (x + this.pathX) / 2.0f, (y + this.pathY) / 2.0f);
                this.pathX = x;
                this.pathY = y;
            }
        }
    }

    private void touchUp() {
        if (this.currentAction == DrawViewAction.MANUAL_CLEAR) {
            this.livePath.lineTo(this.pathX, this.pathY);
            this.cuts.push((Pair<Pair<Path, Paint>, Bitmap>)new Pair((Object)new Pair((Object)this.livePath, (Object)this.pathPaint), null));
            this.livePath = new Path();
            this.undoButton.setEnabled(true);
        }
    }

    public void undo() {
        if (this.cuts.size() > 0) {
            Pair<Pair<Path, Paint>, Bitmap> cut = this.cuts.pop();
            if (cut.second != null) {
                this.undoneCuts.push((Pair<Pair<Path, Paint>, Bitmap>)new Pair(null, (Object)this.imageBitmap));
                this.imageBitmap = (Bitmap)cut.second;
            } else {
                this.undoneCuts.push(cut);
            }
            if (this.cuts.isEmpty()) {
                this.undoButton.setEnabled(false);
            }
            this.redoButton.setEnabled(true);
            this.invalidate();
        }
    }

    public void redo() {
        if (this.undoneCuts.size() > 0) {
            Pair<Pair<Path, Paint>, Bitmap> cut = this.undoneCuts.pop();
            if (cut.second != null) {
                this.cuts.push((Pair<Pair<Path, Paint>, Bitmap>)new Pair(null, (Object)this.imageBitmap));
                this.imageBitmap = (Bitmap)cut.second;
            } else {
                this.cuts.push(cut);
            }
            if (this.undoneCuts.isEmpty()) {
                this.redoButton.setEnabled(false);
            }
            this.undoButton.setEnabled(true);
            this.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.imageBitmap != null && this.currentAction != DrawViewAction.ZOOM) {
            switch (ev.getAction()) {
                case 0: {
                    this.touchStart(ev.getX(), ev.getY());
                    return true;
                }
                case 2: {
                    this.touchMove(ev.getX(), ev.getY());
                    this.invalidate();
                    return true;
                }
                case 1: {
                    this.touchUp();
                    this.invalidate();
                    return true;
                }
            }
        }
        return super.onTouchEvent(ev);
    }

    private void resizeBitmap(int width, int height) {
        if (width > 0 && height > 0 && this.imageBitmap != null) {
            this.imageBitmap = BitmapUtility.getResizedBitmap(this.imageBitmap, width, height);
            this.imageBitmap.setHasAlpha(true);
            this.invalidate();
        }
    }

    public void setBitmap(Bitmap bitmap) {
        this.imageBitmap = bitmap;
        this.resizeBitmap(this.getWidth(), this.getHeight());
    }

    public Bitmap getCurrentBitmap() {
        return this.imageBitmap;
    }

    public void setAction(DrawViewAction newAction) {
        this.currentAction = newAction;
    }

    public void setStrokeWidth(int strokeWidth) {
        this.pathPaint = new Paint(this.pathPaint);
        this.pathPaint.setStrokeWidth((float)strokeWidth);
    }

    public void setLoadingModal(View loadingModal) {
        this.loadingModal = loadingModal;
    }

    private static class AutomaticPixelClearingTask
    extends AsyncTask<Integer, Void, Bitmap> {
        private WeakReference<DrawView> drawViewWeakReference;

        AutomaticPixelClearingTask(DrawView drawView) {
            this.drawViewWeakReference = new WeakReference<DrawView>(drawView);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            ((DrawView)((Object)this.drawViewWeakReference.get())).loadingModal.setVisibility(0);
            ((DrawView)((Object)this.drawViewWeakReference.get())).cuts.push(new Pair(null, (Object)((DrawView)((Object)this.drawViewWeakReference.get())).imageBitmap));
        }

        protected Bitmap doInBackground(Integer ... points) {
            Bitmap oldBitmap = ((DrawView)((Object)this.drawViewWeakReference.get())).imageBitmap;
            int colorToReplace = oldBitmap.getPixel(points[0].intValue(), points[1].intValue());
            int width = oldBitmap.getWidth();
            int height = oldBitmap.getHeight();
            int[] pixels = new int[width * height];
            oldBitmap.getPixels(pixels, 0, width, 0, 0, width, height);
            int rA = Color.alpha((int)colorToReplace);
            int rR = Color.red((int)colorToReplace);
            int rG = Color.green((int)colorToReplace);
            int rB = Color.blue((int)colorToReplace);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int index = y * width + x;
                    int pixel = pixels[index];
                    int rrA = Color.alpha((int)pixel);
                    int rrR = Color.red((int)pixel);
                    int rrG = Color.green((int)pixel);
                    int rrB = Color.blue((int)pixel);
                    if (!((float)rA - 20.0f < (float)rrA) || !((float)rrA < (float)rA + 20.0f) || !((float)rR - 20.0f < (float)rrR) || !((float)rrR < (float)rR + 20.0f) || !((float)rG - 20.0f < (float)rrG) || !((float)rrG < (float)rG + 20.0f) || !((float)rB - 20.0f < (float)rrB) || !((float)rrB < (float)rB + 20.0f)) continue;
                    pixels[index] = 0;
                }
            }
            Bitmap newBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            newBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
            return newBitmap;
        }

        protected void onPostExecute(Bitmap result) {
            super.onPostExecute((Object)result);
            ((DrawView)((Object)this.drawViewWeakReference.get())).imageBitmap = result;
            ((DrawView)((Object)this.drawViewWeakReference.get())).undoButton.setEnabled(true);
            ((DrawView)((Object)this.drawViewWeakReference.get())).loadingModal.setVisibility(4);
            ((DrawView)((Object)this.drawViewWeakReference.get())).invalidate();
        }
    }

    public static enum DrawViewAction {
        AUTO_CLEAR,
        MANUAL_CLEAR,
        ZOOM;

    }
}

