/*
 * Decompiled with CFR 0.152.
 */
package com.github.gabrielbb.cutout;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Pair;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import com.alexvasilkov.gestures.views.interfaces.GestureView;
import com.github.gabrielbb.cutout.BitmapUtility;
import com.github.gabrielbb.cutout.DrawView;
import com.github.gabrielbb.cutout.IntroActivity;
import com.github.gabrielbb.cutout.R;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.theartofdev.edmodo.cropper.CropImage;
import com.theartofdev.edmodo.cropper.CropImageView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.UUID;
import pl.aprilapps.easyphotopicker.DefaultCallback;
import pl.aprilapps.easyphotopicker.EasyImage;
import top.defaults.checkerboarddrawable.CheckerboardDrawable;

public class CutOutActivity
extends AppCompatActivity {
    private static final int INTRO_REQUEST_CODE = 4;
    private static final int WRITE_EXTERNAL_STORAGE_CODE = 1;
    private static final int IMAGE_CHOOSER_REQUEST_CODE = 2;
    private static final int CAMERA_REQUEST_CODE = 3;
    private static final String INTRO_SHOWN = "INTRO_SHOWN";
    private FrameLayout loadingModal;
    private GestureView gestureView;
    private DrawView drawView;
    private LinearLayout manualClearSettingsLayout;
    private static final short MAX_ERASER_SIZE = 150;
    private static final short BORDER_SIZE = 45;
    private static final float MAX_ZOOM = 4.0f;
    private static final String SAVED_IMAGE_FORMAT = "png";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_photo_edit);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.photo_edit_toolbar);
        toolbar.setBackgroundColor(-16777216);
        toolbar.setTitleTextColor(-1);
        this.setSupportActionBar(toolbar);
        FrameLayout drawViewLayout = (FrameLayout)this.findViewById(R.id.drawViewLayout);
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 16) {
            drawViewLayout.setBackgroundDrawable((Drawable)CheckerboardDrawable.create());
        } else {
            drawViewLayout.setBackground((Drawable)CheckerboardDrawable.create());
        }
        SeekBar strokeBar = (SeekBar)this.findViewById(R.id.strokeBar);
        strokeBar.setMax(150);
        strokeBar.setProgress(50);
        this.gestureView = (GestureView)this.findViewById(R.id.gestureView);
        this.drawView = (DrawView)this.findViewById(R.id.drawView);
        this.drawView.setDrawingCacheEnabled(true);
        this.drawView.setLayerType(2, null);
        this.drawView.setStrokeWidth(strokeBar.getProgress());
        strokeBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                CutOutActivity.this.drawView.setStrokeWidth(seekBar.getProgress());
            }
        });
        this.loadingModal = (FrameLayout)this.findViewById(R.id.loadingModal);
        this.loadingModal.setVisibility(4);
        this.drawView.setLoadingModal((View)this.loadingModal);
        this.manualClearSettingsLayout = (LinearLayout)this.findViewById(R.id.manual_clear_settings_layout);
        this.setUndoRedo();
        this.initializeActionButtons();
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setDisplayShowHomeEnabled(true);
            this.getSupportActionBar().setDisplayShowTitleEnabled(false);
            if (toolbar.getNavigationIcon() != null) {
                toolbar.getNavigationIcon().setColorFilter(this.getResources().getColor(R.color.white), PorterDuff.Mode.SRC_ATOP);
            }
        }
        Button doneButton = (Button)this.findViewById(R.id.done);
        doneButton.setOnClickListener(v -> this.startSaveDrawingTask());
        FrameLayout adViewContainer = (FrameLayout)this.findViewById(R.id.adViewContainer);
        if (this.getIntent().hasExtra("CUTOUT_EXTRA_AD_ID")) {
            String adId = this.getIntent().getStringExtra("CUTOUT_EXTRA_AD_ID");
            AdView adView = new AdView(this.getApplicationContext());
            adView.setAdSize(AdSize.BANNER);
            adView.setAdUnitId(adId);
            adViewContainer.addView((View)adView);
            AdRequest adRequest = new AdRequest.Builder().build();
            adView.loadAd(adRequest);
        } else {
            adViewContainer.setVisibility(8);
        }
        if (this.getIntent().getBooleanExtra("CUTOUT_EXTRA_INTRO", false) && !this.getPreferences(0).getBoolean(INTRO_SHOWN, false)) {
            Intent intent = new Intent((Context)this, IntroActivity.class);
            this.startActivityForResult(intent, 4);
        } else {
            this.start();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.setResult(0);
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private Uri getExtraSource() {
        return this.getIntent().hasExtra("CUTOUT_EXTRA_SOURCE") ? (Uri)this.getIntent().getParcelableExtra("CUTOUT_EXTRA_SOURCE") : null;
    }

    private void start() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            Uri uri = this.getExtraSource();
            if (this.getIntent().getBooleanExtra("CUTOUT_EXTRA_CROP", false)) {
                CropImage.ActivityBuilder cropImageBuilder;
                if (uri != null) {
                    cropImageBuilder = CropImage.activity((Uri)uri);
                } else if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") == 0) {
                    cropImageBuilder = CropImage.activity();
                } else {
                    ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.CAMERA"}, (int)3);
                    return;
                }
                cropImageBuilder = cropImageBuilder.setGuidelines(CropImageView.Guidelines.ON);
                cropImageBuilder.start((Activity)this);
            } else if (uri != null) {
                this.setDrawViewBitmap(uri);
            } else if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") == 0) {
                EasyImage.openChooserWithGallery((Activity)this, (String)this.getString(R.string.image_chooser_message), (int)2);
            } else {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.CAMERA"}, (int)3);
            }
        } else {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
        }
    }

    private void startSaveDrawingTask() {
        SaveDrawingTask task = new SaveDrawingTask(this);
        int borderColor = this.getIntent().getIntExtra("CUTOUT_EXTRA_BORDER_COLOR", -1);
        if (borderColor != -1) {
            Bitmap image = BitmapUtility.getBorderedBitmap(this.drawView.getDrawingCache(), borderColor, 45);
            task.execute(new Bitmap[]{image});
        } else {
            task.execute(new Bitmap[]{this.drawView.getDrawingCache()});
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (grantResults.length > 0 && grantResults[0] == 0) {
            this.start();
        } else {
            this.setResult(0);
            this.finish();
        }
    }

    private void activateGestureView() {
        this.gestureView.getController().getSettings().setMaxZoom(4.0f).setDoubleTapZoom(-1.0f).setPanEnabled(true).setZoomEnabled(true).setDoubleTapEnabled(true).setOverscrollDistance(0.0f, 0.0f).setOverzoomFactor(2.0f);
    }

    private void deactivateGestureView() {
        this.gestureView.getController().getSettings().setPanEnabled(false).setZoomEnabled(false).setDoubleTapEnabled(false);
    }

    private void initializeActionButtons() {
        Button autoClearButton = (Button)this.findViewById(R.id.auto_clear_button);
        Button manualClearButton = (Button)this.findViewById(R.id.manual_clear_button);
        Button zoomButton = (Button)this.findViewById(R.id.zoom_button);
        autoClearButton.setActivated(false);
        autoClearButton.setOnClickListener(buttonView -> {
            if (!autoClearButton.isActivated()) {
                this.drawView.setAction(DrawView.DrawViewAction.AUTO_CLEAR);
                this.manualClearSettingsLayout.setVisibility(4);
                autoClearButton.setActivated(true);
                manualClearButton.setActivated(false);
                zoomButton.setActivated(false);
                this.deactivateGestureView();
            }
        });
        manualClearButton.setActivated(true);
        this.drawView.setAction(DrawView.DrawViewAction.MANUAL_CLEAR);
        manualClearButton.setOnClickListener(buttonView -> {
            if (!manualClearButton.isActivated()) {
                this.drawView.setAction(DrawView.DrawViewAction.MANUAL_CLEAR);
                this.manualClearSettingsLayout.setVisibility(0);
                manualClearButton.setActivated(true);
                autoClearButton.setActivated(false);
                zoomButton.setActivated(false);
                this.deactivateGestureView();
            }
        });
        zoomButton.setActivated(false);
        this.deactivateGestureView();
        zoomButton.setOnClickListener(buttonView -> {
            if (!zoomButton.isActivated()) {
                this.drawView.setAction(DrawView.DrawViewAction.ZOOM);
                this.manualClearSettingsLayout.setVisibility(4);
                zoomButton.setActivated(true);
                manualClearButton.setActivated(false);
                autoClearButton.setActivated(false);
                this.activateGestureView();
            }
        });
    }

    private void setUndoRedo() {
        Button undoButton = (Button)this.findViewById(R.id.undo);
        undoButton.setEnabled(false);
        undoButton.setOnClickListener(v -> this.undo());
        Button redoButton = (Button)this.findViewById(R.id.redo);
        redoButton.setEnabled(false);
        redoButton.setOnClickListener(v -> this.redo());
        this.drawView.setButtons(undoButton, redoButton);
    }

    private void exitWithError(Exception e) {
        Intent intent = new Intent();
        intent.putExtra("CUTOUT_EXTRA_RESULT", (Serializable)e);
        this.setResult(3680, intent);
        this.finish();
    }

    private void setDrawViewBitmap(Uri uri) {
        try {
            Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.getContentResolver(), (Uri)uri);
            this.drawView.setBitmap(bitmap);
        }
        catch (IOException e) {
            this.exitWithError(e);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 203) {
            CropImage.ActivityResult result = CropImage.getActivityResult((Intent)data);
            if (resultCode == -1) {
                this.setDrawViewBitmap(result.getUri());
            } else if (resultCode == 204) {
                this.exitWithError(result.getError());
            } else {
                this.setResult(0);
                this.finish();
            }
        } else if (requestCode == 4) {
            SharedPreferences.Editor editor = this.getPreferences(0).edit();
            editor.putBoolean(INTRO_SHOWN, true);
            editor.apply();
            this.start();
        } else {
            EasyImage.handleActivityResult((int)requestCode, (int)resultCode, (Intent)data, (Activity)this, (EasyImage.Callbacks)new DefaultCallback(){

                public void onImagePickerError(Exception e, EasyImage.ImageSource source, int type) {
                    CutOutActivity.this.exitWithError(e);
                }

                public void onImagePicked(File imageFile, EasyImage.ImageSource source, int type) {
                    CutOutActivity.this.setDrawViewBitmap(Uri.parse((String)imageFile.toURI().toString()));
                }

                public void onCanceled(EasyImage.ImageSource source, int type) {
                    File photoFile;
                    if (source == EasyImage.ImageSource.CAMERA && (photoFile = EasyImage.lastlyTakenButCanceledPhoto((Context)CutOutActivity.this)) != null) {
                        photoFile.delete();
                    }
                    CutOutActivity.this.setResult(0);
                    CutOutActivity.this.finish();
                }
            });
        }
    }

    private void undo() {
        this.drawView.undo();
    }

    private void redo() {
        this.drawView.redo();
    }

    private static class SaveDrawingTask
    extends AsyncTask<Bitmap, Void, Pair<String, Exception>> {
        private final WeakReference<CutOutActivity> activityWeakReference;

        SaveDrawingTask(CutOutActivity activity) {
            this.activityWeakReference = new WeakReference<CutOutActivity>(activity);
        }

        protected void onPreExecute() {
            super.onPreExecute();
            ((CutOutActivity)((Object)this.activityWeakReference.get())).loadingModal.setVisibility(0);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Pair<String, Exception> doInBackground(Bitmap ... bitmaps) {
            File file = new File(Environment.getExternalStorageDirectory().toString(), UUID.randomUUID().toString() + "." + CutOutActivity.SAVED_IMAGE_FORMAT);
            try (FileOutputStream out = new FileOutputStream(file);){
                bitmaps[0].compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
                Pair pair = new Pair((Object)file.getAbsolutePath(), null);
                return pair;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new Pair(null, (Object)e);
            }
        }

        protected void onPostExecute(Pair<String, Exception> result) {
            super.onPostExecute(result);
            Intent resultIntent = new Intent();
            if (result.first != null) {
                Uri uri = Uri.parse((String)((String)result.first));
                resultIntent.putExtra("CUTOUT_EXTRA_RESULT", (Parcelable)uri);
                ((CutOutActivity)((Object)this.activityWeakReference.get())).setResult(-1, resultIntent);
                ((CutOutActivity)((Object)this.activityWeakReference.get())).finish();
            } else {
                ((CutOutActivity)((Object)this.activityWeakReference.get())).exitWithError((Exception)result.second);
            }
        }
    }
}

