/*
 * Decompiled with CFR 0.152.
 */
package org.yi.acru.bukkit;

import com.gmail.nossr50.datatypes.PlayerProfile;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.register.payment.Method;
import com.nijikokun.register.payment.Methods;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.platymuus.bukkit.permissions.Group;
import de.bananaco.bpermissions.api.WorldManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import org.anjocaido.groupmanager.GroupManager;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.yi.acru.bukkit.BlockUtil;
import org.yi.acru.bukkit.PluginCoreLink;
import org.yi.acru.bukkit.PluginCoreServerListener;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public abstract class PluginCore
extends JavaPlugin {
    private static final String coreVersion = "1.3.5";
    public static final Logger log = Logger.getLogger("Minecraft");
    private static boolean registered = false;
    private final PluginCoreServerListener serverListener = new PluginCoreServerListener(this);
    private static int useExternalGroups = 0;
    private static int useExternalPermissions = 0;
    private static int useExternalZones = 0;
    private static int useExternalEconomy = 0;
    private static String lastZoneDeny = "lockette.unknown";
    private static List<PluginCoreLink> linkList = null;
    private static PluginCoreLink linkSuperPerms = null;
    private static PluginCoreLink linkGroupManager = null;
    private static PluginCoreLink linkPermsBukkit = null;
    private static PluginCoreLink linkPermissionsEx = null;
    private static PluginCoreLink linkBPermissions = null;
    private static PluginCoreLink linkTowny = null;
    private static PluginCoreLink linkSimpleClans = null;
    private static PluginCoreLink linkMcmmo = null;
    private static PluginCoreLink linkFactions = null;
    private static PluginCoreLink linkLWC = null;
    private static PluginCoreLink linkRegister = null;
    private static PluginCoreLink linkPermissions = null;
    private static boolean permissionsWorld = false;

    public void onEnable() {
        if (!registered) {
            this.serverListener.registerEvents();
            registered = true;
        }
        if (linkList != null) {
            linkList.clear();
            linkList = null;
            useExternalGroups = 0;
            useExternalPermissions = 0;
            useExternalZones = 0;
            useExternalEconomy = 0;
        }
        linkList = new ArrayList<PluginCoreLink>(10);
        linkSuperPerms = this.linkInternalPerms();
        linkGroupManager = this.linkExternalPlugin("GroupManager", PluginCoreLink.LinkType.GroupManager);
        linkPermsBukkit = this.linkExternalPlugin("PermissionsBukkit", PluginCoreLink.LinkType.GROUPS_PERMISSIONS);
        linkPermissionsEx = this.linkExternalPlugin("PermissionsEx", PluginCoreLink.LinkType.GROUPS_PERMISSIONS);
        linkBPermissions = this.linkExternalPlugin("bPermissions", PluginCoreLink.LinkType.GROUPS_PERMISSIONS);
        linkTowny = this.linkExternalPlugin("Towny", PluginCoreLink.LinkType.GROUPS_ZONES);
        linkSimpleClans = this.linkExternalPlugin("SimpleClans", PluginCoreLink.LinkType.GROUPS);
        linkMcmmo = this.linkExternalPlugin("mcMMO", PluginCoreLink.LinkType.GROUPS);
        linkFactions = this.linkExternalPlugin("Factions", PluginCoreLink.LinkType.GROUPS);
        linkLWC = this.linkExternalPlugin("LWC", PluginCoreLink.LinkType.ZONES);
        linkRegister = this.linkExternalPlugin("Register", PluginCoreLink.LinkType.ECONOMY);
        linkPermissions = this.linkExternalPlugin("Permissions", PluginCoreLink.LinkType.Permissions);
        if (this.usingExternalPermissions()) {
            log.info("[" + this.getDescription().getName() + "] Using linked plugin for admin permissions.");
        } else {
            log.info("[" + this.getDescription().getName() + "] Using ops file for admin permissions.");
        }
    }

    public void onDisable() {
        if (linkList != null) {
            linkList.clear();
            linkList = null;
            useExternalGroups = 0;
            useExternalPermissions = 0;
            useExternalZones = 0;
            useExternalEconomy = 0;
        }
    }

    public static String getCoreVersion() {
        return coreVersion;
    }

    public static String lastZoneDeny() {
        return lastZoneDeny;
    }

    public void dumpCoreInfo() {
        log.info("[" + this.getDescription().getName() + "] Dumping core information:");
        log.info("Number of linked group plugins: " + useExternalGroups);
        log.info("Number of linked permission plugins: " + useExternalPermissions);
        log.info("Number of linked zone plugins: " + useExternalZones);
        log.info("Number of linked economy plugins: " + useExternalEconomy);
        if (linkSuperPerms.isEnabled()) {
            Collection players = this.getServer().getOnlinePlayers();
            log.info("Superperms is available, " + players.size() + " players online.");
            for (Player player : players) {
                log.info("Player: " + player.getName() + " has the following permissions:");
                Set perms = player.getEffectivePermissions();
                for (PermissionAttachmentInfo perm : perms) {
                    log.info("    " + perm.getPermission() + " = " + perm.getValue());
                }
            }
        } else {
            log.info("Superperms is unavailable.");
        }
    }

    private PluginCoreLink linkInternalPerms() {
        PluginCoreLink link = new PluginCoreLink(this, null, PluginCoreLink.LinkType.PERMISSIONS);
        try {
            Class[] args = new Class[]{String.class};
            Player.class.getMethod("hasPermission", args);
        }
        catch (Throwable ex) {
            return link;
        }
        link.setEnabled(true);
        return link;
    }

    private PluginCoreLink linkExternalPlugin(String pluginName, PluginCoreLink.LinkType handler) {
        Plugin plugin = this.getServer().getPluginManager().getPlugin(pluginName);
        PluginCoreLink link = new PluginCoreLink(this, plugin, handler);
        if (plugin == null) {
            return link;
        }
        if (linkList == null) {
            return link;
        }
        link.setLinked(true);
        linkList.add(0, link);
        if (this.getServer().getPluginManager().isPluginEnabled(plugin)) {
            this.setLink(link.getPluginName(), true, false);
        }
        return link;
    }

    public void setLink(String pluginName, boolean enable, boolean listener) {
        if (linkList == null) {
            return;
        }
        boolean external = this.usingExternalPermissions();
        int groups = useExternalGroups;
        int perms = useExternalPermissions;
        int zones = useExternalZones;
        int economy = useExternalEconomy;
        boolean result = true;
        int difference = enable ? 1 : -1;
        for (PluginCoreLink link : linkList) {
            if (!pluginName.equals(link.getPluginName())) continue;
            if (!link.isLinked()) {
                return;
            }
            switch (link.getType()) {
                case GROUPS: 
                case GROUPS_PERMISSIONS: 
                case GROUPS_ZONES: 
                case GROUPS_PERMISSIONS_ZONES: {
                    useExternalGroups += difference;
                }
            }
            switch (link.getType()) {
                case GROUPS_PERMISSIONS: 
                case GROUPS_PERMISSIONS_ZONES: 
                case PERMISSIONS: 
                case PERMISSIONS_ZONES: {
                    useExternalPermissions += difference;
                }
            }
            switch (link.getType()) {
                case GROUPS_ZONES: 
                case GROUPS_PERMISSIONS_ZONES: 
                case PERMISSIONS_ZONES: 
                case ZONES: {
                    useExternalZones += difference;
                }
            }
            switch (link.getType()) {
                case ECONOMY: {
                    useExternalEconomy += difference;
                }
            }
            switch (link.getType()) {
                case GroupManager: {
                    result = this.enableLinkGroupManager(link, enable, difference);
                    break;
                }
                case Permissions: {
                    result = this.enableLinkPermissions(link, enable, difference);
                    break;
                }
                default: {
                    link.setEnabled(enable);
                }
            }
            if (enable) {
                if (result) {
                    String changed = "";
                    if (groups != useExternalGroups) {
                        changed = changed + "/Groups";
                    }
                    if (this.usingExternalPermissions() && perms != useExternalPermissions) {
                        changed = changed + "/Permissions";
                    }
                    if (zones != useExternalZones) {
                        changed = changed + "/Zones";
                    }
                    if (economy != useExternalEconomy) {
                        changed = changed + "/Economy";
                    }
                    changed = changed.startsWith("/") ? changed.substring(1) : (!this.usingExternalPermissions() ? "NO REASON (permissions disabled)" : "NO REASON");
                    log.info("[" + this.getDescription().getName() + "] Enabled link to plugin " + link.getPluginName() + " for " + changed + ", version " + link.getPluginVersion());
                    if (listener && !external && this.usingExternalPermissions()) {
                        log.info("[" + this.getDescription().getName() + "] Ops file overridden, using linked plugin for admin permissions.");
                    }
                } else if (!link.isLinked()) {
                    log.info("[" + this.getDescription().getName() + "] Ignoring fake Permissions plugin version " + link.getPluginVersion());
                } else {
                    log.warning("[" + this.getDescription().getName() + "] Failed to enable link to plugin" + link.getPluginName() + ", version " + link.getPluginVersion() + "!");
                }
            } else if (result) {
                log.info("[" + this.getDescription().getName() + "] Disabled link to plugin " + link.getPluginName() + ", version " + link.getPluginVersion());
            } else {
                log.warning("[" + this.getDescription().getName() + "] Failed to disable link to plugin " + link.getPluginName() + ", version " + link.getPluginVersion() + "!");
            }
            return;
        }
    }

    protected boolean enableLinkGroupManager(PluginCoreLink link, boolean enable, int difference) {
        if (enable) {
            try {
                Method getWho = GroupManager.class.getMethod("getWorldsHolder", null);
                link.setData(getWho.invoke((Object)link.getGroupManager(), (Object[])null));
            }
            catch (Throwable ex) {
                return false;
            }
        }
        useExternalGroups += difference;
        useExternalPermissions += difference;
        link.setEnabled(enable);
        return true;
    }

    protected boolean enableLinkPermissions(PluginCoreLink link, boolean enable, int difference) {
        boolean usePerms = true;
        if (linkBPermissions != null && linkBPermissions.isLinked()) {
            usePerms = false;
        }
        if (enable) {
            try {
                Class.forName("org.anjocaido.groupmanager.permissions.NijikoPermissionsProxy");
                link.setLinked(false);
                return false;
            }
            catch (Throwable throwable) {
                try {
                    Class.forName("com.platymuus.bukkit.permcompat.PermissionHandler");
                    link.setLinked(false);
                    return false;
                }
                catch (Throwable throwable2) {
                    try {
                        Class.forName("ru.tehkode.permissions.compat.P2Group");
                        link.setLinked(false);
                        return false;
                    }
                    catch (Throwable throwable3) {
                        try {
                            link.setData(link.getPermissions().getHandler());
                        }
                        catch (Throwable ex) {
                            return false;
                        }
                        permissionsWorld = false;
                        try {
                            Class[] args = new Class[]{String.class, String.class, String.class};
                            PermissionHandler.class.getMethod("inGroup", args);
                            permissionsWorld = true;
                        }
                        catch (Throwable throwable4) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        useExternalGroups += difference;
        if (usePerms) {
            useExternalPermissions += difference;
        }
        link.setEnabled(enable);
        return true;
    }

    protected boolean pluginEnableOverride(String pluginName) {
        return false;
    }

    protected boolean usingExternalGroups() {
        return useExternalGroups > 0;
    }

    protected boolean usingExternalPermissions() {
        return useExternalPermissions > 0;
    }

    protected boolean usingExternalZones() {
        return useExternalZones > 0;
    }

    protected boolean usingExternalEconomy() {
        return useExternalEconomy > 0;
    }

    protected String getLocalizedEveryone() {
        return null;
    }

    protected String getLocalizedOperators() {
        return null;
    }

    public boolean inGroup(World world, Player player, String groupName) {
        return this.inGroup(world, player, player.getName(), groupName);
    }

    public boolean inGroup(World world, String playerName, String groupName) {
        return this.inGroup(world, this.getServer().getPlayer(playerName), playerName, groupName);
    }

    private boolean inGroup(World world, Player player, String playerName, String groupName) {
        if (groupName.equalsIgnoreCase("[Everyone]")) {
            return true;
        }
        String local = this.getLocalizedEveryone();
        if (local != null && groupName.equalsIgnoreCase(local)) {
            return true;
        }
        if (player != null && player.isOp()) {
            if (groupName.equalsIgnoreCase("[Operators]")) {
                return true;
            }
            local = this.getLocalizedOperators();
            if (local != null && groupName.equalsIgnoreCase(local)) {
                return true;
            }
        }
        if (!this.usingExternalGroups()) {
            return false;
        }
        boolean result = false;
        int end = groupName.length() - 1;
        if (end >= 2 && groupName.charAt(0) == '[' && groupName.charAt(end) == ']') {
            PlayerProfile pProfile;
            Clan clan;
            List membership;
            Group group;
            if (linkPermsBukkit.isEnabled() && (group = linkPermsBukkit.getPermsBukkit().getGroup(groupName.substring(1, end))) != null && (membership = linkPermsBukkit.getPermsBukkit().getGroups(playerName)) != null) {
                int count = membership.size();
                for (int x = 0; x < count; ++x) {
                    if (!((Group)membership.get(x)).equals((Object)group)) continue;
                    return true;
                }
            }
            if (linkPermissionsEx.isEnabled() && (result = PermissionsEx.getUser((String)playerName).inGroup(groupName.substring(1, end), world.getName()))) {
                return true;
            }
            if (linkBPermissions.isEnabled() && (result = WorldManager.getInstance().getWorld(world.getName()).getUser(playerName).hasGroupRecursive(groupName.substring(1, end).toLowerCase()))) {
                return true;
            }
            if (linkGroupManager.isEnabled() && (result = linkGroupManager.getWorldsHolder().getWorldPermissions(world.getName()).inGroup(playerName, groupName.substring(1, end)))) {
                return true;
            }
            if (linkTowny.isEnabled()) {
                try {
                    Resident resident = TownyUniverse.getDataSource().getResident(playerName);
                    try {
                        Town town = resident.getTown();
                        if (town.getName().equalsIgnoreCase(groupName.substring(1, end))) {
                            return true;
                        }
                        try {
                            Nation nation = town.getNation();
                            if (nation.getName().equalsIgnoreCase(groupName.substring(1, end))) {
                                return true;
                            }
                        }
                        catch (Throwable nation) {
                        }
                    }
                    catch (Throwable town) {}
                }
                catch (Throwable resident) {
                    // empty catch block
                }
            }
            if (linkSimpleClans.isEnabled() && (clan = linkSimpleClans.getSimpleClans().getClanManager().getClanByPlayerName(playerName)) != null) {
                if (clan.getName().equalsIgnoreCase(groupName.substring(1, end))) {
                    return true;
                }
                if (clan.getTag().equalsIgnoreCase(groupName.substring(1, end))) {
                    return true;
                }
            }
            if (linkMcmmo.isEnabled() && player != null && (pProfile = linkMcmmo.getMcmmo().getPlayerProfile(player.getName())) != null && pProfile.inParty() && pProfile.getParty().getName().equalsIgnoreCase(groupName.substring(1, end))) {
                return true;
            }
            if (linkFactions.isEnabled() && player != null) {
                Object obj = linkFactions.getFactions();
                Class<?> klass = obj.getClass();
                String tag = null;
                try {
                    switch (klass.getSimpleName()) {
                        case "P": {
                            Method m = klass.getMethod("getPlayerFactionTag", Player.class);
                            tag = (String)m.invoke(obj, player);
                            break;
                        }
                        case "Factions": {
                            Class<?> kklass = Class.forName("com.massivecraft.factions.entity.MPlayer");
                            Method m1 = kklass.getMethod("get", Object.class);
                            Object mp = m1.invoke(null, player);
                            Method m2 = kklass.getMethod("getFactionName", new Class[0]);
                            tag = (String)m2.invoke(mp, new Object[0]);
                        }
                    }
                }
                catch (Exception e) {
                    tag = null;
                    e.printStackTrace();
                }
                tag = ChatColor.stripColor(tag);
                if (tag != null && tag.equalsIgnoreCase(groupName.substring(1, end))) {
                    return true;
                }
            }
            if (linkPermissions.isEnabled() && (result = permissionsWorld ? linkPermissions.getPermissionHandler().inGroup(world.getName(), playerName, groupName.substring(1, end)) : linkPermissions.getPermissionHandler().inGroup(player.getWorld().getName(), playerName, groupName.substring(1, end)))) {
                return true;
            }
        }
        return false;
    }

    public boolean hasPermission(World world, String playerName, String permissionNode) {
        return this.hasPermission(world, this.getServer().getPlayer(playerName), permissionNode);
    }

    public boolean hasPermission(World world, Player player, String permissionNode) {
        if (player == null) {
            return false;
        }
        if (!this.usingExternalPermissions()) {
            return player.isOp();
        }
        boolean result = false;
        if (linkSuperPerms.isEnabled() && player != null && (result = player.hasPermission(permissionNode))) {
            return true;
        }
        if (linkGroupManager.isEnabled() && (result = linkGroupManager.getWorldsHolder().getWorldPermissions(world.getName()).has(player, permissionNode))) {
            return true;
        }
        return linkPermissions.isEnabled() && (result = linkPermissions.getPermissionHandler().has(player, permissionNode));
    }

    public boolean canBuild(String playerName, Block block) {
        return this.canBuild(this.getServer().getPlayer(playerName), block);
    }

    public boolean canBuild(Player player, Block block) {
        LWC lwc;
        Protection protection;
        lastZoneDeny = "noone";
        if (!this.usingExternalZones()) {
            return true;
        }
        if (linkTowny.isEnabled()) {
            try {
                if (TownyUniverse.getDataSource().getWorld(block.getWorld().getName()).isUsingTowny() && TownyUniverse.isWilderness((Block)block) && this.usingExternalPermissions() && !this.hasPermission(block.getWorld(), player, "lockette.towny.wilds")) {
                    lastZoneDeny = "towny.wilds";
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (linkLWC.isEnabled() && (protection = (lwc = linkLWC.getLWCPlugin().getLWC()).findProtection(block)) != null && !lwc.canAdminProtection(player, protection)) {
            lastZoneDeny = "lwc.protection";
            return false;
        }
        return true;
    }

    public String economyFormat(double amount) {
        if (!this.usingExternalEconomy()) {
            return Double.toString(amount);
        }
        if (linkRegister.isEnabled() && Methods.hasMethod()) {
            return Methods.getMethod().format(amount);
        }
        return Double.toString(amount);
    }

    public boolean economyTransfer(String source, String destination, double amount) {
        Method.MethodAccount sourceAccount;
        if (!this.usingExternalEconomy()) {
            return false;
        }
        if (linkRegister.isEnabled() && Methods.hasMethod() && Methods.getMethod().hasAccount(source) && (sourceAccount = Methods.getMethod().getAccount(source)).hasEnough(amount)) {
            if (!Methods.getMethod().hasAccount(destination)) {
                Methods.getMethod().createAccount(destination);
            }
            if (Methods.getMethod().hasAccount(destination)) {
                Method.MethodAccount destinationAccount = Methods.getMethod().getAccount(destination);
                if (sourceAccount.subtract(amount)) {
                    if (destinationAccount.add(amount)) {
                        return true;
                    }
                    sourceAccount.add(amount);
                }
            }
        }
        return false;
    }

    protected void selectiveBroadcast(String target, String message) {
        if (target == null) {
            return;
        }
        if (target.isEmpty()) {
            return;
        }
        if (message == null) {
            return;
        }
        if (message.isEmpty()) {
            return;
        }
        Collection players = this.getServer().getOnlinePlayers();
        if (target.charAt(0) == '[') {
            for (Player p : players) {
                if (!this.inGroup(p.getWorld(), p, target)) continue;
                p.sendMessage(message);
            }
        } else {
            for (Player p : players) {
                if (!target.equalsIgnoreCase(p.getName())) continue;
                p.sendMessage(message);
            }
        }
    }

    public boolean playerOnline(String truncName) {
        String text = truncName.replaceAll("(?i)\u00a7[0-F]", "");
        Collection players = this.getServer().getOnlinePlayers();
        for (Player p : players) {
            int length = p.getName().length();
            if (length > 15) {
                length = 15;
            }
            if (!text.equals(p.getName().substring(0, length))) continue;
            return true;
        }
        return false;
    }

    protected static float getBuildVersion() {
        int build;
        String version = Server.class.getPackage().getImplementationVersion() + ' ';
        int index = version.lastIndexOf("-b");
        if (index == -1) {
            return 0.0f;
        }
        if (version.length() < (index += 2) + 3) {
            return 0.0f;
        }
        if (version.charAt(index) == '{') {
            ++index;
        }
        int endIndex = index;
        for (int x = index; x < version.length() && Character.isDigit(version.charAt(x)); ++x) {
            ++endIndex;
        }
        try {
            build = Integer.parseInt(version.substring(index, endIndex));
        }
        catch (NumberFormatException ex) {
            return 0.0f;
        }
        boolean jenkins = false;
        boolean bamboo = false;
        if (version.length() >= endIndex + 3) {
            if (version.charAt(endIndex) == '}') {
                ++endIndex;
            }
            if (version.charAt(endIndex) != ' ') {
                if (version.substring(endIndex).startsWith("jnks ")) {
                    jenkins = true;
                } else {
                    bamboo = true;
                }
            }
        }
        if (build >= 231 && build <= 326 && !jenkins && !bamboo) {
            return build;
        }
        if (build >= 35 && build <= 54 && jenkins) {
            return 399.0f + (float)build / 100.0f;
        }
        if (build >= 400 && jenkins) {
            return build;
        }
        return 0.0f;
    }

    public static Block getSignAttachedBlock(Block block) {
        if (block.getTypeId() != Material.WALL_SIGN.getId()) {
            return null;
        }
        int face = block.getData() & 7;
        if (face == BlockUtil.faceList[0]) {
            return block.getRelative(BlockFace.NORTH);
        }
        if (face == BlockUtil.faceList[1]) {
            return block.getRelative(BlockFace.EAST);
        }
        if (face == BlockUtil.faceList[2]) {
            return block.getRelative(BlockFace.SOUTH);
        }
        if (face == BlockUtil.faceList[3]) {
            return block.getRelative(BlockFace.WEST);
        }
        return null;
    }

    public static Block getTrapDoorAttachedBlock(Block block) {
        int type = block.getTypeId();
        if (type != Material.TRAP_DOOR.getId() && type != Material.IRON_TRAPDOOR.getId()) {
            return null;
        }
        int face = block.getData() & 3;
        if (face == BlockUtil.attachList[0]) {
            return block.getRelative(BlockFace.NORTH);
        }
        if (face == BlockUtil.attachList[1]) {
            return block.getRelative(BlockFace.EAST);
        }
        if (face == BlockUtil.attachList[2]) {
            return block.getRelative(BlockFace.SOUTH);
        }
        if (face == BlockUtil.attachList[3]) {
            return block.getRelative(BlockFace.WEST);
        }
        return null;
    }

    public static BlockFace getPistonFacing(Block block) {
        int type = block.getTypeId();
        if (type != Material.PISTON_BASE.getId() && type != Material.PISTON_STICKY_BASE.getId() && type != Material.PISTON_EXTENSION.getId()) {
            return BlockFace.SELF;
        }
        int face = block.getData() & 7;
        switch (face) {
            case 0: {
                return BlockFace.DOWN;
            }
            case 1: {
                return BlockFace.UP;
            }
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.SOUTH;
            }
            case 4: {
                return BlockFace.WEST;
            }
            case 5: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.SELF;
    }
}

