/*
 * Decompiled with CFR 0.152.
 */
package org.yi.acru.bukkit.Lockette;

import java.util.UUID;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.yi.acru.bukkit.BlockUtil;
import org.yi.acru.bukkit.Lockette.Lockette;

public class LocketteInventoryListener
implements Listener {
    private static Lockette plugin;

    public LocketteInventoryListener(Lockette instance) {
        plugin = instance;
    }

    protected void registerEvents() {
        PluginManager pm = plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)plugin);
    }

    private boolean isProtected(Inventory inv, boolean allowEveryone) {
        Block block;
        int type;
        if (!Lockette.blockHopper) {
            return false;
        }
        InventoryHolder holder = inv.getHolder();
        if (holder instanceof DoubleChest) {
            holder = ((DoubleChest)holder).getLeftSide();
        }
        if (holder instanceof BlockState && (BlockUtil.isInList(type = (block = ((BlockState)holder).getBlock()).getTypeId(), BlockUtil.materialListNonDoors) || Lockette.isInList(type, Lockette.customBlockList))) {
            return allowEveryone && Lockette.isEveryone(block) ? false : Lockette.isProtected(block);
        }
        return false;
    }

    private boolean passThrough(Inventory src, Inventory dest, Inventory me) {
        Block block;
        InventoryHolder holder;
        if (!Lockette.blockHopper) {
            return true;
        }
        UUID srcOwner = null;
        UUID destOwner = null;
        UUID meOwner = null;
        if (src != null) {
            holder = src.getHolder();
            if (holder instanceof DoubleChest) {
                holder = ((DoubleChest)holder).getLeftSide();
            }
            if (holder instanceof BlockState) {
                block = ((BlockState)holder).getBlock();
                srcOwner = Lockette.getProtectedOwnerUUID(block);
                if (Lockette.isEveryone(block)) {
                    srcOwner = null;
                }
            }
        }
        if (dest != null) {
            holder = dest.getHolder();
            if (holder instanceof DoubleChest) {
                holder = ((DoubleChest)holder).getLeftSide();
            }
            if (holder instanceof BlockState) {
                block = ((BlockState)holder).getBlock();
                destOwner = Lockette.getProtectedOwnerUUID(block);
                if (Lockette.isEveryone(block)) {
                    destOwner = null;
                }
            }
        }
        if (me != null) {
            holder = me.getHolder();
            if (holder instanceof DoubleChest) {
                holder = ((DoubleChest)holder).getLeftSide();
            }
            if (holder instanceof BlockState) {
                block = ((BlockState)holder).getBlock();
                meOwner = Lockette.getProtectedOwnerUUID(block);
                if (Lockette.isEveryone(block)) {
                    meOwner = null;
                }
            }
        }
        return srcOwner == meOwner && meOwner == destOwner || srcOwner == meOwner && destOwner == null || srcOwner == null && meOwner == destOwner || srcOwner == null && destOwner == null;
    }

    @EventHandler
    public void onInventoryItemMove(InventoryMoveItemEvent event) {
        Inventory me;
        Inventory dest;
        Inventory src = event.getSource();
        if (this.passThrough(src, dest = event.getDestination(), me = event.getInitiator())) {
            return;
        }
        if (this.isProtected(event.getSource(), false) || this.isProtected(event.getDestination(), true)) {
            event.setCancelled(true);
        }
    }
}

