/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.glacio.parsing.lexer;

import com.github.fridujo.glacio.parsing.charstream.Position;
import com.github.fridujo.glacio.parsing.lexer.FixedTokenDefinition;
import com.github.fridujo.glacio.parsing.lexer.TokenType;
import java.util.Arrays;
import java.util.Objects;

public class Token {
    private final TokenType type;
    private final String literal;
    private final Position position;

    public Token(TokenType type, String literal, Position position) {
        this.type = type;
        this.literal = literal;
        this.position = position;
    }

    public Token(TokenType type, Position position) {
        this(type, "", position);
    }

    public Token(FixedTokenDefinition fixedTokenDefinition, Position position) {
        this(fixedTokenDefinition.getType(), fixedTokenDefinition.getLiteralString(), position);
    }

    public TokenType getType() {
        return this.type;
    }

    public String getLiteral() {
        return this.literal;
    }

    public Position getPosition() {
        return this.position;
    }

    public String toString() {
        return "Token{type=" + (Object)((Object)this.type) + ", literal='" + this.literal.replace("\n", "") + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return this.type == token.type && Objects.equals(this.literal, token.literal);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.literal});
    }

    public boolean isOfType(TokenType tokenType) {
        return this.isOfAnyType(tokenType);
    }

    public boolean isOfAnyType(TokenType ... tokenTypes) {
        return Arrays.stream(tokenTypes).map(tt -> tt == this.getType()).mapToInt(sameType -> sameType != false ? 1 : 0).sum() > 0;
    }
}

