/*
 * Decompiled with CFR 0.152.
 */
package com.github.fridujo.glacio.parsing.i18n;

import com.eclipsesource.json.JsonObject;
import com.github.fridujo.glacio.parsing.i18n.LanguageKeywords;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class GherkinJsonMapper {
    public Map<String, LanguageKeywords> map(JsonObject jsonObject) {
        List languageCodes = jsonObject.names();
        return languageCodes.stream().collect(Collectors.toMap(Function.identity(), code -> this.mapToLanguage((String)code, jsonObject.get(code).asObject())));
    }

    private LanguageKeywords mapToLanguage(String code, JsonObject jsonObject) {
        String name = jsonObject.get("name").asString();
        String nativeName = jsonObject.get("native").asString();
        Set<String> feature = this.getKeywords(jsonObject, "feature");
        Set<String> scenarioOutline = this.getKeywords(jsonObject, "scenarioOutline");
        Set<String> background = this.getKeywords(jsonObject, "background");
        Set<String> scenario = this.getKeywords(jsonObject, "scenario");
        Set<String> given = this.getKeywords(jsonObject, "given");
        Set<String> when = this.getKeywords(jsonObject, "when");
        Set<String> then = this.getKeywords(jsonObject, "then");
        Set<String> and = this.getKeywords(jsonObject, "and");
        Set<String> but = this.getKeywords(jsonObject, "but");
        Set<String> examples = this.getKeywords(jsonObject, "examples");
        return new LanguageKeywords(code, name, nativeName, feature, background, scenarioOutline, scenario, given, when, then, this.concat(and, but), examples);
    }

    private Set<String> concat(Set<String> s1, Set<String> s2) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(s1);
        result.addAll(s2);
        return result;
    }

    private Set<String> getKeywords(JsonObject jsonObject, String keywordName) {
        return jsonObject.get(keywordName).asArray().values().stream().map((? super T jv) -> jv.asString()).filter(k -> !"* ".equals(k)).collect(Collectors.toSet());
    }
}

