/*
 * Decompiled with CFR 0.152.
 */
package com.franriadigos.view;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.franriadigos.view.AttributesHelper;
import com.franriadigos.view.CircularProgressContract;

public class ImageViewCircularProgress
extends AppCompatImageView
implements CircularProgressContract {
    private float mMax = 100.0f;
    private float mProgress = 0.0f;
    private float mCurrentProgress = 0.0f;
    private float mBackgroundRingSize;
    private float mProgressRingSize = this.mBackgroundRingSize = 40.0f;
    private boolean mProgressRingOutline = false;
    private int mBackgroundRingColor = -1434201911;
    private int mProgressRingColor = -16738680;
    private int[] mProgressGradient;
    private boolean mIsJoinGradient;
    private float mGradientFactor;
    private Paint.Cap mProgressRingCorner = Paint.Cap.BUTT;
    private ObjectAnimator mAnimator;
    private Interpolator mDefaultInterpolator = new OvershootInterpolator();
    private int mViewHeight = 0;
    private int mViewWidth = 0;
    private int mPaddingTop;
    private int mPaddingBottom;
    private int mPaddingLeft;
    private int mPaddingRight;
    private Paint mProgressRingPaint;
    private Paint mBackgroundRingPaint;
    private RectF mRingBounds;
    private float mOffsetRingSize;
    private Paint mMaskPaint;
    private Bitmap mOriginalBitmap;
    private Canvas mCacheCanvas;

    public ImageViewCircularProgress(Context context) {
        this(context, null);
    }

    public ImageViewCircularProgress(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImageViewCircularProgress(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        new AttributesHelper(this).loadFromAttributes(attrs, defStyleAttr, 0);
        this.setupAnimator();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int widthWithoutPadding = width - this.getPaddingLeft() - this.getPaddingRight();
        int heightWithoutPadding = height - this.getPaddingTop() - this.getPaddingBottom();
        int size = widthWithoutPadding > heightWithoutPadding ? heightWithoutPadding : widthWithoutPadding;
        this.setMeasuredDimension(size + this.getPaddingLeft() + this.getPaddingRight(), size + this.getPaddingTop() + this.getPaddingBottom());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mViewWidth = w;
        this.mViewHeight = h;
        if (this.isProgressRingOutline()) {
            this.setPadding(Float.valueOf(this.mBackgroundRingSize + (float)this.getPaddingLeft()).intValue(), Float.valueOf(this.mBackgroundRingSize + (float)this.getPaddingTop()).intValue(), Float.valueOf(this.mBackgroundRingSize + (float)this.getPaddingRight()).intValue(), Float.valueOf(this.mBackgroundRingSize + (float)this.getPaddingBottom()).intValue());
        }
        this.setupBounds();
        this.setupBackgroundRingPaint();
        this.setupProgressRingPaint();
        this.requestLayout();
        this.invalidate();
    }

    private void setupBounds() {
        int minValue = Math.min(this.mViewWidth, this.mViewHeight);
        int xOffset = this.mViewWidth - minValue;
        int yOffset = this.mViewHeight - minValue;
        int outline = 0;
        if (this.isProgressRingOutline()) {
            outline = Float.valueOf(-this.mBackgroundRingSize).intValue();
        }
        this.mPaddingTop = outline + this.getPaddingTop() + yOffset / 2;
        this.mPaddingBottom = outline + this.getPaddingBottom() + yOffset / 2;
        this.mPaddingLeft = outline + this.getPaddingLeft() + xOffset / 2;
        this.mPaddingRight = outline + this.getPaddingRight() + xOffset / 2;
        float biggerRingSize = this.mBackgroundRingSize > this.mProgressRingSize ? this.mBackgroundRingSize : this.mProgressRingSize;
        this.mOffsetRingSize = biggerRingSize / 2.0f;
        int width = this.getWidth();
        int height = this.getHeight();
        this.mRingBounds = new RectF((float)this.mPaddingLeft + this.mOffsetRingSize, (float)this.mPaddingTop + this.mOffsetRingSize, (float)(width - this.mPaddingRight) - this.mOffsetRingSize, (float)(height - this.mPaddingBottom) - this.mOffsetRingSize);
    }

    private void setupMask() {
        this.mOriginalBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        BitmapShader shader = new BitmapShader(this.mOriginalBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mMaskPaint = new Paint();
        this.mMaskPaint.setAntiAlias(true);
        this.mMaskPaint.setShader((Shader)shader);
    }

    private void setupProgressRingPaint() {
        this.mProgressRingPaint = new Paint();
        this.mProgressRingPaint.setAntiAlias(true);
        this.mProgressRingPaint.setStrokeCap(this.mProgressRingCorner);
        this.mProgressRingPaint.setStyle(Paint.Style.STROKE);
        this.mProgressRingPaint.setStrokeWidth(this.mProgressRingSize);
        this.mProgressRingPaint.setColor(this.mProgressRingColor);
        if (this.mProgressGradient != null) {
            int[] colors = this.mProgressGradient;
            if (this.isJoinGradient()) {
                colors = new int[this.mProgressGradient.length + 1];
                float[] positions = new float[colors.length];
                int i = 0;
                positions[i] = i;
                int[] nArray = this.mProgressGradient;
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    int color;
                    colors[i] = color = nArray[j];
                    if (i == this.mProgressGradient.length - 1) {
                        positions[i] = (360.0f - this.mProgressRingSize * this.getGradientFactor()) / 360.0f;
                    } else if (i > 0) {
                        positions[i] = (float)i / (float)colors.length;
                    }
                    ++i;
                }
                colors[i] = colors[0];
                positions[i] = 1.0f;
            }
            SweepGradient gradient = new SweepGradient(this.mRingBounds.centerX(), this.mRingBounds.centerY(), colors, null);
            this.mProgressRingPaint.setShader((Shader)gradient);
            Matrix matrix = new Matrix();
            this.mProgressRingPaint.getShader().setLocalMatrix(matrix);
            matrix.postTranslate(-this.mRingBounds.centerX(), -this.mRingBounds.centerY());
            matrix.postRotate(-90.0f);
            matrix.postTranslate(this.mRingBounds.centerX(), this.mRingBounds.centerY());
            this.mProgressRingPaint.getShader().setLocalMatrix(matrix);
            this.mProgressRingPaint.setColor(this.mProgressGradient[0]);
        }
    }

    private void setupBackgroundRingPaint() {
        this.mBackgroundRingPaint = new Paint();
        this.mBackgroundRingPaint.setColor(this.mBackgroundRingColor);
        this.mBackgroundRingPaint.setAntiAlias(true);
        this.mBackgroundRingPaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundRingPaint.setStrokeWidth(this.mBackgroundRingSize);
    }

    private void setupAnimator() {
        this.mAnimator = ObjectAnimator.ofFloat((Object)this, (String)"progress", (float[])new float[]{this.getProgress(), this.getProgress()});
        this.mAnimator.setDuration(1200L);
        this.mAnimator.setInterpolator((TimeInterpolator)this.mDefaultInterpolator);
        this.mAnimator.setStartDelay(500L);
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ImageViewCircularProgress.this.setCurrentProgress(((Float)animation.getAnimatedValue()).floatValue());
                ImageViewCircularProgress.this.setProgress(ImageViewCircularProgress.this.getCurrentProgress());
            }
        });
    }

    public void startAnimation() {
        float finalProgress = this.getProgress();
        this.setProgress(this.getCurrentProgress());
        this.mAnimator.setFloatValues(new float[]{this.getCurrentProgress(), finalProgress});
        this.mAnimator.start();
    }

    protected void onDraw(@NonNull Canvas canvas) {
        if (this.mMaskPaint == null) {
            this.setupMask();
        }
        if (this.mCacheCanvas == null) {
            this.mCacheCanvas = new Canvas(this.mOriginalBitmap);
        }
        super.onDraw(this.mCacheCanvas);
        canvas.drawCircle(this.mRingBounds.centerX(), this.mRingBounds.centerY(), this.mRingBounds.width() / 2.0f - this.mBackgroundRingSize / 2.0f, this.mMaskPaint);
        if (this.mBackgroundRingSize > 0.0f) {
            canvas.drawArc(this.mRingBounds, 360.0f, 360.0f, false, this.mBackgroundRingPaint);
        }
        if (this.mProgressRingSize > 0.0f) {
            canvas.drawArc(this.mRingBounds, -90.0f, this.getSweepAngle(), false, this.mProgressRingPaint);
        }
    }

    private float getSweepAngle() {
        return 360.0f / this.mMax * this.mProgress;
    }

    public ObjectAnimator getAnimator() {
        return this.mAnimator;
    }

    @Override
    public float getMax() {
        return this.mMax;
    }

    @Override
    public void setMax(float max) {
        this.mMax = max;
    }

    @Override
    public float getCurrentProgress() {
        return this.mCurrentProgress;
    }

    @Override
    public void setCurrentProgress(float currentProgress) {
        this.mCurrentProgress = currentProgress;
    }

    @Override
    public float getProgress() {
        return this.mProgress;
    }

    @Override
    public void setProgress(float progress) {
        this.mProgress = progress < 0.0f ? 0.0f : (progress > 100.0f ? 100.0f : progress);
        this.invalidate();
    }

    @Override
    public float getProgressRingSize() {
        return this.mProgressRingSize;
    }

    @Override
    public void setProgressRingSize(float progressRingSize) {
        this.mProgressRingSize = progressRingSize;
    }

    @Override
    public float getBackgroundRingSize() {
        return this.mBackgroundRingSize;
    }

    @Override
    public void setBackgroundRingSize(float backgroundRingSize) {
        this.mBackgroundRingSize = backgroundRingSize;
    }

    @Override
    public boolean isProgressRingOutline() {
        return this.mProgressRingOutline;
    }

    @Override
    public void setProgressRingOutline(boolean progressRingOutline) {
        this.mProgressRingOutline = progressRingOutline;
    }

    @Override
    public int getBackgroundRingColor() {
        return this.mBackgroundRingColor;
    }

    @Override
    public void setBackgroundRingColor(int backgroundRingColor) {
        this.mBackgroundRingColor = backgroundRingColor;
    }

    @Override
    public int getProgressRingColor() {
        return this.mProgressRingColor;
    }

    @Override
    public void setProgressRingColor(int progressRingColor) {
        this.mProgressRingColor = progressRingColor;
    }

    @Override
    public int[] getProgressGradient() {
        return this.mProgressGradient;
    }

    @Override
    public void setProgressGradient(int[] progressGradient) {
        this.mProgressGradient = progressGradient;
    }

    @Override
    public boolean isJoinGradient() {
        return this.mIsJoinGradient;
    }

    @Override
    public void setJoinGradient(boolean isJoinGradient) {
        this.mIsJoinGradient = isJoinGradient;
    }

    @Override
    public float getGradientFactor() {
        return this.mGradientFactor;
    }

    @Override
    public void setGradientFactor(float gradientFactor) {
        this.mGradientFactor = gradientFactor;
    }

    @Override
    public Paint.Cap getProgressRingCorner() {
        return this.mProgressRingCorner;
    }

    @Override
    public void setProgressRingCorner(int progressRingCorner) {
        this.mProgressRingCorner = this.getCap(progressRingCorner);
    }

    @Override
    public Paint.Cap getCap(int id) {
        for (Paint.Cap value : Paint.Cap.values()) {
            if (id != value.ordinal()) continue;
            return value;
        }
        return Paint.Cap.BUTT;
    }
}

