/*
 * Decompiled with CFR 0.152.
 */
package com.franmontiel.attributionpresenter;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.franmontiel.attributionpresenter.R;
import com.franmontiel.attributionpresenter.entities.Attribution;
import com.franmontiel.attributionpresenter.entities.LicenseInfo;
import com.franmontiel.attributionpresenter.listeners.OnAttributionClickListener;
import com.franmontiel.attributionpresenter.listeners.OnLicenseClickListener;
import com.franmontiel.attributionpresenter.util.BrowserOpener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class AttributionAdapter
extends BaseAdapter {
    private List<Attribution> items;
    @LayoutRes
    private int itemLayout;
    @LayoutRes
    private int licenseLayout;
    @Nullable
    private final OnAttributionClickListener onAttributionClickListener;
    @Nullable
    private final OnLicenseClickListener onLicenseClickListener;

    AttributionAdapter(Collection<Attribution> attributions, @LayoutRes int itemLayout, @LayoutRes int licenseLayout, @Nullable OnAttributionClickListener onAttributionClickListener, @Nullable OnLicenseClickListener onLicenseClickListener) {
        this.items = new ArrayList<Attribution>(attributions.size());
        this.items.addAll(attributions);
        this.itemLayout = itemLayout;
        this.licenseLayout = licenseLayout;
        this.onAttributionClickListener = onAttributionClickListener;
        this.onLicenseClickListener = onLicenseClickListener;
    }

    public int getCount() {
        return this.items.size();
    }

    public Attribution getItem(int position) {
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, final ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(this.itemLayout, parent, false);
            holder = new ViewHolder();
            holder.name = (TextView)convertView.findViewById(R.id.name);
            holder.copyrightNotices = (TextView)convertView.findViewById(R.id.copyrightNotices);
            holder.licensesLayout = (ViewGroup)convertView.findViewById(R.id.licensesLayout);
            if (holder.name == null || holder.copyrightNotices == null || holder.licensesLayout == null) {
                throw new IllegalStateException("Item layout must contain all of the following required views:\n  - TextView with android:id=\"@+id/name\"\n  - TextView with android:id=\"@+id/copyrightNotices\"\n  - ViewGroup descendant with android:id=\"@+id/licensesLayout\"");
            }
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        final Attribution attribution = this.getItem(position);
        holder.name.setText((CharSequence)attribution.getName());
        holder.copyrightNotices.setText((CharSequence)attribution.getFormattedCopyrightNotices());
        holder.licensesLayout.removeAllViews();
        for (LicenseInfo licenseInfo : attribution.getLicensesInfo()) {
            this.addLicense(parent.getContext(), holder.licensesLayout, licenseInfo);
        }
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AttributionAdapter.this.onAttributionClickListener == null || !AttributionAdapter.this.onAttributionClickListener.onAttributionClick(attribution)) {
                    BrowserOpener.open(parent.getContext(), attribution.getWebsite());
                }
            }
        });
        return convertView;
    }

    private void addLicense(final Context context, ViewGroup licensesLayout, final LicenseInfo licenseInfo) {
        View inflatedView = LayoutInflater.from((Context)context).inflate(this.licenseLayout, licensesLayout, false);
        TextView licenseTextView = (TextView)inflatedView.findViewById(R.id.license);
        if (licenseTextView == null) {
            throw new IllegalStateException("LicenseInfo layout does not contain a required TextView with android:id=\"@+id/licenseInfo\"");
        }
        licenseTextView.setText((CharSequence)licenseInfo.getName());
        licenseTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AttributionAdapter.this.onLicenseClickListener == null || !AttributionAdapter.this.onLicenseClickListener.onLicenseClick(licenseInfo)) {
                    BrowserOpener.open(context, licenseInfo.getTextUrl());
                }
            }
        });
        licensesLayout.addView(inflatedView);
    }

    private static class ViewHolder {
        TextView name;
        TextView copyrightNotices;
        ViewGroup licensesLayout;

        private ViewHolder() {
        }
    }
}

