/*
 * Decompiled with CFR 0.152.
 */
package com.fraggjkee.smsconfirmationview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Build;
import android.util.AttributeSet;
import androidx.core.content.res.ResourcesCompat;
import com.fraggjkee.smsconfirmationview.AndroidExtensionsKt;
import com.fraggjkee.smsconfirmationview.R;
import com.fraggjkee.smsconfirmationview.SmsConfirmationView;
import com.fraggjkee.smsconfirmationview.SymbolView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/fraggjkee/smsconfirmationview/SmsConfirmationViewStyleUtils;", "", "()V", "defaultStyle", "Lcom/fraggjkee/smsconfirmationview/SmsConfirmationView$Style;", "getDefault", "context", "Landroid/content/Context;", "getFromAttributes", "attrs", "Landroid/util/AttributeSet;", "library_release"})
public final class SmsConfirmationViewStyleUtils {
    @NotNull
    public static final SmsConfirmationViewStyleUtils INSTANCE = new SmsConfirmationViewStyleUtils();
    @Nullable
    private static SmsConfirmationView.Style defaultStyle;

    private SmsConfirmationViewStyleUtils() {
    }

    @NotNull
    public final SmsConfirmationView.Style getDefault(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (defaultStyle == null) {
            Resources resources = context.getResources();
            SymbolView.Style symbolViewStyle = new SymbolView.Style(true, resources.getDimensionPixelSize(R.dimen.symbol_view_width), resources.getDimensionPixelSize(R.dimen.symbol_view_height), AndroidExtensionsKt.getThemeColor(context, R.attr.colorSurface), AndroidExtensionsKt.getThemeColor(context, R.attr.colorPrimary), AndroidExtensionsKt.getThemeColor(context, R.attr.colorPrimary), resources.getDimensionPixelSize(R.dimen.symbol_view_stroke_width), resources.getDimension(R.dimen.symbol_view_corner_radius), AndroidExtensionsKt.getThemeColor(context, R.attr.colorOnSurface), resources.getDimensionPixelSize(R.dimen.symbol_view_text_size), null, 1024, null);
            defaultStyle = new SmsConfirmationView.Style(4, resources.getDimensionPixelSize(R.dimen.symbols_spacing), symbolViewStyle, null, 8, null);
        }
        SmsConfirmationView.Style style = defaultStyle;
        Intrinsics.checkNotNull((Object)style);
        return style;
    }

    @NotNull
    public final SmsConfirmationView.Style getFromAttributes(@NotNull AttributeSet attrs, @NotNull Context context) {
        Typeface typeface;
        TypedArray typedArray;
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SmsConfirmationView.Style defaultStyle = this.getDefault(context);
        SymbolView.Style defaultSymbolStyle = defaultStyle.getSymbolViewStyle();
        TypedArray typedArray2 = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SmsConfirmationView, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray2, (String)"context.theme.obtainStyl\u2026msConfirmationView, 0, 0)");
        TypedArray $this$getFromAttributes_u24lambda_u2d1 = typedArray = typedArray2;
        boolean bl = false;
        boolean showCursor = $this$getFromAttributes_u24lambda_u2d1.getBoolean(R.styleable.SmsConfirmationView_scv_showCursor, defaultSymbolStyle.getShowCursor());
        int symbolWidth = $this$getFromAttributes_u24lambda_u2d1.getDimensionPixelSize(R.styleable.SmsConfirmationView_scv_symbolWidth, defaultSymbolStyle.getWidth());
        int symbolHeight = $this$getFromAttributes_u24lambda_u2d1.getDimensionPixelSize(R.styleable.SmsConfirmationView_scv_symbolHeight, defaultSymbolStyle.getHeight());
        int symbolBackgroundColor = $this$getFromAttributes_u24lambda_u2d1.getColor(R.styleable.SmsConfirmationView_scv_symbolBackgroundColor, defaultSymbolStyle.getBackgroundColor());
        int symbolBorderColor = $this$getFromAttributes_u24lambda_u2d1.getColor(R.styleable.SmsConfirmationView_scv_symbolBorderColor, defaultSymbolStyle.getBorderColor());
        int symbolBorderActiveColor = $this$getFromAttributes_u24lambda_u2d1.getColor(R.styleable.SmsConfirmationView_scv_symbolBorderActiveColor, symbolBorderColor);
        int symbolBorderWidth = $this$getFromAttributes_u24lambda_u2d1.getDimensionPixelSize(R.styleable.SmsConfirmationView_scv_symbolBorderWidth, defaultSymbolStyle.getBorderWidth());
        int symbolTextColor = $this$getFromAttributes_u24lambda_u2d1.getColor(R.styleable.SmsConfirmationView_scv_symbolTextColor, defaultSymbolStyle.getTextColor());
        int symbolTextSize = $this$getFromAttributes_u24lambda_u2d1.getDimensionPixelSize(R.styleable.SmsConfirmationView_scv_symbolTextSize, defaultSymbolStyle.getTextSize());
        float cornerRadius = $this$getFromAttributes_u24lambda_u2d1.getDimension(R.styleable.SmsConfirmationView_scv_symbolBorderCornerRadius, defaultSymbolStyle.getBorderCornerRadius());
        int codeLength = $this$getFromAttributes_u24lambda_u2d1.getInt(R.styleable.SmsConfirmationView_scv_codeLength, defaultStyle.getCodeLength());
        int symbolsSpacingPx = $this$getFromAttributes_u24lambda_u2d1.getDimensionPixelSize(R.styleable.SmsConfirmationView_scv_symbolsSpacing, defaultStyle.getSymbolsSpacing());
        int it = $this$getFromAttributes_u24lambda_u2d1.getInt(R.styleable.SmsConfirmationView_scv_smsDetectionMode, SmsConfirmationView.SmsDetectionMode.AUTO.ordinal());
        boolean bl2 = false;
        SmsConfirmationView.SmsDetectionMode smsDetectionMode = SmsConfirmationView.SmsDetectionMode.values()[it];
        if (Build.VERSION.SDK_INT >= 26) {
            typeface = $this$getFromAttributes_u24lambda_u2d1.getFont(R.styleable.SmsConfirmationView_scv_symbolTextFont);
            if (typeface == null) {
                typeface = Typeface.DEFAULT_BOLD;
            }
        } else {
            int resId = $this$getFromAttributes_u24lambda_u2d1.getResourceId(R.styleable.SmsConfirmationView_scv_symbolTextFont, -1);
            if (resId == -1) {
                typeface = Typeface.DEFAULT_BOLD;
            } else {
                typeface = ResourcesCompat.getFont((Context)context, (int)resId);
                if (typeface == null) {
                    typeface = Typeface.DEFAULT_BOLD;
                }
            }
        }
        Typeface symbolTextFont = typeface;
        $this$getFromAttributes_u24lambda_u2d1.recycle();
        Intrinsics.checkNotNullExpressionValue((Object)symbolTextFont, (String)"symbolTextFont");
        return new SmsConfirmationView.Style(codeLength, symbolsSpacingPx, new SymbolView.Style(showCursor, symbolWidth, symbolHeight, symbolBackgroundColor, symbolBorderColor, symbolBorderActiveColor, symbolBorderWidth, cornerRadius, symbolTextColor, symbolTextSize, symbolTextFont), smsDetectionMode);
    }
}

