/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.strings;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMString;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.Optional;

@RedisCommand(value="setrange")
public class SetRange
extends AbstractRedisOperation {
    public SetRange(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        int offset = Utils.convertToInteger(this.params().get(1).toString());
        Slice value = this.params().get(2);
        String oldValue = Optional.ofNullable(this.base().getRMString(key)).map(RMString::getStoredDataAsString).orElse("");
        String padding = "";
        if (offset > oldValue.length()) {
            padding = new String(new byte[offset - oldValue.length()]);
        }
        String newValue = oldValue.substring(0, Math.min(offset, oldValue.length())) + padding + value.toString();
        if (offset + value.length() < oldValue.length()) {
            newValue = newValue + oldValue.substring(offset + value.length());
        }
        this.base().putValue(key, Slice.create(newValue).extract(), null);
        return Response.integer(newValue.length());
    }
}

