/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.scripting;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.scripting.LuaRedisCallback;
import com.github.fppt.jedismock.operations.scripting.Script;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import com.github.fppt.jedismock.storage.RedisBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.JsePlatform;

@RedisCommand(value="eval")
public class Eval
extends AbstractRedisOperation {
    private static final String SCRIPT_RUNTIME_ERROR = "Error running script (call to function returned nil)";
    private static final String REDIS_LUA = Eval.loadResource();
    private final Globals globals = JsePlatform.standardGlobals();
    private final OperationExecutorState state;

    public Eval(RedisBase base, List<Slice> params, OperationExecutorState state) {
        super(base, params);
        this.state = state;
    }

    @Override
    protected int minArgs() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Slice response() {
        String script = this.params().get(0).toString();
        this.base().addCachedLuaScript(Script.getScriptSHA(script), script);
        int keysNum = Integer.parseInt(this.params().get(1).toString());
        List<LuaValue> args = Eval.getLuaValues(this.params().subList(2, this.params().size()));
        this.globals.set("redis", this.globals.load(REDIS_LUA).call());
        this.globals.set("KEYS", (LuaValue)Eval.embedLuaListToValue(args.subList(0, keysNum)));
        this.globals.set("ARGV", (LuaValue)Eval.embedLuaListToValue(args.subList(keysNum, args.size())));
        this.globals.set("_mock", CoerceJavaToLua.coerce((Object)new LuaRedisCallback(this.state)));
        int selected = this.state.getSelected();
        try {
            LuaValue result = this.globals.load(script).call();
            Slice slice = this.resolveResult(result);
            return slice;
        }
        catch (LuaError e) {
            Slice slice = Response.error(String.format("Error running script: %s", e.getMessage()));
            return slice;
        }
        finally {
            this.state.changeActiveRedisBase(selected);
        }
    }

    private static List<LuaValue> getLuaValues(List<Slice> slices) {
        return slices.stream().map(Slice::data).map(LuaValue::valueOf).collect(Collectors.toList());
    }

    public static LuaTable embedLuaListToValue(List<LuaValue> luaValues) {
        return LuaValue.listOf((LuaValue[])luaValues.toArray(new LuaValue[0]));
    }

    private Slice resolveResult(LuaValue result) {
        if (result.isnil()) {
            return Response.NULL;
        }
        switch (result.typename()) {
            case "string": {
                return Response.bulkString(Slice.create(((LuaString)result).m_bytes));
            }
            case "number": {
                return Response.integer(result.tolong());
            }
            case "table": {
                if (!result.get("err").isnil()) {
                    return Response.error(result.get("err").tojstring());
                }
                if (!result.get("ok").isnil()) {
                    return this.resolveResult(result.get("ok"));
                }
                return Response.array(this.luaTableToList(result));
            }
            case "boolean": {
                return result.toboolean() ? Response.integer(1L) : Response.NULL;
            }
        }
        return Response.error(SCRIPT_RUNTIME_ERROR);
    }

    private ArrayList<Slice> luaTableToList(LuaValue result) {
        ArrayList<Slice> list = new ArrayList<Slice>();
        for (int i = 0; i < result.length(); ++i) {
            list.add(this.resolveResult(result.get(i + 1)));
        }
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String loadResource() {
        try (InputStream in = Eval.class.getResourceAsStream("/redis.lua");){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

