/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.storage;

import com.github.fppt.jedismock.datastructures.Slice;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class ExpiringStorage {
    protected final Consumer<Slice> keyChangeNotifier;
    private final Supplier<Clock> clockSupplier;
    private final Map<Slice, Long> ttls = new HashMap<Slice, Long>();

    public ExpiringStorage(Supplier<Clock> clockSupplier, Consumer<Slice> keyChangeNotifier) {
        this.clockSupplier = Objects.requireNonNull(clockSupplier);
        this.keyChangeNotifier = Objects.requireNonNull(keyChangeNotifier);
    }

    protected void clear() {
        this.ttls.clear();
    }

    protected void delete(Slice key) {
        this.ttls.remove(key);
    }

    protected abstract boolean keyExists(Slice var1);

    protected boolean isKeyOutdated(Slice key) {
        Long deadline = this.ttls.get(key);
        return deadline != null && deadline != -1L && deadline <= this.getMillis();
    }

    public Long getTTL(Slice key) {
        Objects.requireNonNull(key);
        Long deadline = this.ttls.get(key);
        if (deadline == null) {
            return null;
        }
        if (deadline == -1L) {
            return deadline;
        }
        long now = this.getMillis();
        if (now < deadline) {
            return deadline - now;
        }
        this.delete(key);
        return null;
    }

    public Long getDeadline(Slice key) {
        return this.ttls.get(key);
    }

    public long setTTL(Slice key, long ttl) {
        this.keyChangeNotifier.accept(key);
        return this.setDeadline(key, ttl + this.getMillis());
    }

    protected final long getMillis() {
        return this.clockSupplier.get().millis();
    }

    protected void configureTTL(Slice key, Long ttl) {
        if (ttl == null) {
            if (this.getTTL(key) == null) {
                this.setDeadline(key, -1L);
            }
        } else if (ttl != -1L) {
            this.setTTL(key, ttl);
        } else {
            this.setDeadline(key, -1L);
        }
    }

    public long setDeadline(Slice key, long deadline) {
        Objects.requireNonNull(key);
        if (this.keyExists(key)) {
            Long oldValue = this.ttls.put(key, deadline);
            return deadline < 0L && (oldValue == null || oldValue < 0L) ? 0L : 1L;
        }
        return 0L;
    }

    public Supplier<Clock> getClockSupplier() {
        return this.clockSupplier;
    }
}

