/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.keys.paramsparser;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.keys.paramsparser.ExpirationParamsException;
import java.util.Collections;
import java.util.List;

public final class ExpirationFieldsParam {
    private final List<Slice> fields;

    public ExpirationFieldsParam(List<Slice> params, int position) throws ExpirationParamsException {
        if (!"FIELDS".equalsIgnoreCase(params.get(position).toString())) {
            throw new ExpirationParamsException("ERR Mandatory argument FIELDS is missing or not at the right position");
        }
        long numFields = 0L;
        try {
            numFields = Long.parseLong(new String(params.get(position + 1).data()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (numFields <= 0L) {
            throw new ExpirationParamsException("ERR Parameter `numFields` should be greater than 0");
        }
        if ((long)(params.size() - position - 2) != numFields) {
            throw new ExpirationParamsException("ERR The `numfields` parameter must match the number of arguments");
        }
        this.fields = Collections.unmodifiableList(params.subList(position + 2, params.size()));
    }

    public List<Slice> getFields() {
        return this.fields;
    }
}

