/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.keys;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.keys.paramsparser.ExpirationExtraParam;
import com.github.fppt.jedismock.operations.keys.paramsparser.ExpirationParamsException;
import com.github.fppt.jedismock.operations.keys.paramsparser.ExpirationTimeParam;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="pexpireat")
class PExpireAt
extends AbstractRedisOperation {
    PExpireAt(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected int minArgs() {
        return 2;
    }

    protected boolean useMillis() {
        return true;
    }

    @Override
    protected Slice response() {
        try {
            Slice key = this.params().get(0);
            ExpirationTimeParam expirationTime = new ExpirationTimeParam(this.self().value(), this.params().get(1), this.useMillis(), 0L);
            ExpirationExtraParam extraParam = new ExpirationExtraParam(this.params(), false);
            long newDeadline = expirationTime.getMillis();
            if (this.base().exists(key) && extraParam.checkTiming(this.base().getDeadline(key), newDeadline)) {
                return Response.integer(this.base().setDeadline(key, newDeadline));
            }
            return Response.integer(0L);
        }
        catch (ExpirationParamsException e) {
            return Response.error(e.getMessage());
        }
    }
}

