/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sets;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@RedisCommand(value="spop")
class SPop
extends AbstractRedisOperation {
    SPop(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    private List<Slice> popper(Set<Slice> collection, int numberToBeRemoved) {
        ArrayList<Slice> result = new ArrayList<Slice>();
        Iterator<Slice> it = collection.iterator();
        while (numberToBeRemoved-- > 0 && it.hasNext()) {
            result.add(Response.bulkString(it.next()));
            it.remove();
        }
        return result;
    }

    @Override
    protected Slice response() {
        int numberOfElementsToBeRemoved;
        Slice key = this.params().get(0);
        Set<Slice> set = this.getSetFromBaseOrCreateEmpty(key).getStoredData();
        int n = numberOfElementsToBeRemoved = this.params().size() > 1 ? Utils.convertToInteger(this.params().get(1).toString()) : 1;
        if (set.isEmpty()) {
            return this.params().size() > 1 ? Response.EMPTY_ARRAY : Response.NULL;
        }
        List<Slice> removedElements = this.popper(set, numberOfElementsToBeRemoved);
        if (set.isEmpty()) {
            this.base().deleteValue(key);
        }
        if (this.params().size() > 1) {
            return Response.array(removedElements);
        }
        return removedElements.get(0);
    }
}

