/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="zadd")
class ZAdd
extends AbstractRedisOperation {
    ZAdd(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key);
        int count = 0;
        for (int i = 1; i < this.params().size(); i += 2) {
            double s;
            Slice score = this.params().get(i);
            Slice value = this.params().get(i + 1);
            Double prevScore = mapDBObj.put(value, s = Utils.convertToDouble(score.toString()));
            if (prevScore != null) continue;
            ++count;
        }
        this.base().putValue(key, mapDBObj);
        return Response.integer(count);
    }
}

