/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.storage;

import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.RMHash;
import com.github.fppt.jedismock.datastructures.Slice;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ExpiringKeyValueStorage {
    private final Map<Slice, RMDataStructure> values = new HashMap<Slice, RMDataStructure>();
    private final Map<Slice, Long> ttls = new HashMap<Slice, Long>();
    private final Consumer<Slice> keyChangeNotifier;

    public ExpiringKeyValueStorage(Consumer<Slice> keyChangeNotifier) {
        this.keyChangeNotifier = keyChangeNotifier;
    }

    public Map<Slice, RMDataStructure> values() {
        return this.values;
    }

    public Map<Slice, Long> ttls() {
        return this.ttls;
    }

    public void delete(Slice key) {
        this.keyChangeNotifier.accept(key);
        this.ttls().remove(key);
        this.values().remove(key);
    }

    public void delete(Slice key1, Slice key2) {
        this.keyChangeNotifier.accept(key1);
        Objects.requireNonNull(key2);
        if (!this.verifyKey(key1)) {
            return;
        }
        RMHash sortedSetByKey = this.getRMSortedSet(key1);
        Map<Slice, Slice> storedData = sortedSetByKey.getStoredData();
        if (!storedData.containsKey(key2)) {
            return;
        }
        storedData.remove(key2);
        if (storedData.isEmpty()) {
            this.values.remove(key1);
        }
        if (!this.values().containsKey(key1)) {
            this.ttls().remove(key1);
        }
    }

    public void clear() {
        this.values().clear();
        this.ttls().clear();
    }

    public RMDataStructure getValue(Slice key) {
        if (!this.verifyKey(key)) {
            return null;
        }
        return this.values().get(key);
    }

    private boolean verifyKey(Slice key) {
        Objects.requireNonNull(key);
        if (!this.values().containsKey(key)) {
            return false;
        }
        if (this.isKeyOutdated(key)) {
            this.delete(key);
            return false;
        }
        return true;
    }

    boolean isKeyOutdated(Slice key) {
        Long deadline = this.ttls().get(key);
        return deadline != null && deadline != -1L && deadline <= System.currentTimeMillis();
    }

    public Long getTTL(Slice key) {
        Objects.requireNonNull(key);
        Long deadline = this.ttls().get(key);
        if (deadline == null) {
            return null;
        }
        if (deadline == -1L) {
            return deadline;
        }
        long now = System.currentTimeMillis();
        if (now < deadline) {
            return deadline - now;
        }
        this.delete(key);
        return null;
    }

    public long setTTL(Slice key, long ttl) {
        this.keyChangeNotifier.accept(key);
        return this.setDeadline(key, ttl + System.currentTimeMillis());
    }

    public void put(Slice key, RMDataStructure value, Long ttl) {
        this.keyChangeNotifier.accept(key);
        this.values().put(key, value);
        this.configureTTL(key, ttl);
    }

    public void put(Slice key, Slice value, Long ttl) {
        this.keyChangeNotifier.accept(key);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.values().put(key, value.extract());
        this.configureTTL(key, ttl);
    }

    public void put(Slice key1, Slice key2, Slice value, Long ttl) {
        RMHash mapByKey;
        this.keyChangeNotifier.accept(key1);
        Objects.requireNonNull(key1);
        Objects.requireNonNull(key2);
        Objects.requireNonNull(value);
        if (!this.values.containsKey(key1)) {
            mapByKey = new RMHash();
            this.values.put(key1, mapByKey);
        } else {
            mapByKey = this.getRMSortedSet(key1);
        }
        mapByKey.put(key2, value);
        this.configureTTL(key1, ttl);
    }

    private RMHash getRMSortedSet(Slice key) {
        RMDataStructure valueByKey = this.values.get(key);
        if (!this.isSortedSetValue(valueByKey)) {
            valueByKey.raiseTypeCastException();
        }
        return (RMHash)valueByKey;
    }

    private void configureTTL(Slice key, Long ttl) {
        if (ttl == null) {
            if (this.getTTL(key) == null) {
                this.setDeadline(key, -1L);
            }
        } else if (ttl != -1L) {
            this.setTTL(key, ttl);
        } else {
            this.setDeadline(key, -1L);
        }
    }

    public long setDeadline(Slice key, long deadline) {
        Objects.requireNonNull(key);
        if (this.values().containsKey(key)) {
            this.ttls().put(key, deadline);
            return 1L;
        }
        return 0L;
    }

    public boolean exists(Slice slice) {
        return this.verifyKey(slice);
    }

    private boolean isSortedSetValue(RMDataStructure value) {
        return value instanceof RMHash;
    }

    public Slice type(Slice key) {
        if (!this.verifyKey(key)) {
            return Slice.create("none");
        }
        RMDataStructure valueByKey = this.getValue(key);
        if (valueByKey == null) {
            return Slice.create("none");
        }
        return Slice.create(valueByKey.getTypeName());
    }
}

