/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.ListIterator;

@RedisCommand(value="lrem")
class LRem
extends AbstractRedisOperation {
    private final int directedNumRemove = Utils.convertToInteger(new String(this.params().get(1).data()));
    private final Slice target = this.params().get(2);

    private boolean isDeletingElement(Slice element, int numRemoved) {
        return element.equals(this.target) && (this.directedNumRemove == 0 || numRemoved < Math.abs(this.directedNumRemove));
    }

    LRem(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMList listObj = this.base().getList(key);
        if (listObj == null) {
            return Response.integer(0L);
        }
        List<Slice> list = listObj.getStoredData();
        int numRemoved = 0;
        ListIterator<Slice> iterator = this.directedNumRemove < 0 ? list.listIterator(list.size()) : list.listIterator();
        while (this.directedNumRemove < 0 ? iterator.hasPrevious() : iterator.hasNext()) {
            Slice element = this.directedNumRemove < 0 ? iterator.previous() : iterator.next();
            if (!this.isDeletingElement(element, numRemoved)) continue;
            iterator.remove();
            ++numRemoved;
        }
        return Response.integer(numRemoved);
    }
}

