/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.lists.LLen;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.SliceParser;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

abstract class BPop
extends AbstractRedisOperation {
    private final Object lock;
    private final boolean isInTransaction;

    BPop(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.lock = state.lock();
        this.isInTransaction = state.isTransactionModeOn();
    }

    abstract AbstractRedisOperation popper(List<Slice> var1);

    @Override
    protected Slice response() {
        int size = this.params().size();
        if (size < 2) {
            throw new IndexOutOfBoundsException("require at least 2 params");
        }
        List<Slice> keys = this.params().subList(0, size - 1);
        long timeoutNanos = (long)(Utils.convertToDouble(this.params().get(size - 1).toString()) * 1.0E9);
        if (timeoutNanos < 0L) {
            throw new IllegalArgumentException("ERR timeout is negative");
        }
        Slice source = this.getKey(keys, true);
        long waitEnd = System.nanoTime() + timeoutNanos;
        try {
            long waitTimeNanos;
            while (source == null && !this.isInTransaction && (waitTimeNanos = timeoutNanos == 0L ? 0L : waitEnd - System.nanoTime()) >= 0L) {
                this.lock.wait(waitTimeNanos / 1000000L, (int)waitTimeNanos % 1000000);
                source = this.getKey(keys, false);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Response.NULL;
        }
        if (source != null) {
            Slice result = this.popper(Collections.singletonList(source)).execute();
            return Response.array(Arrays.asList(Response.bulkString(source), result));
        }
        System.out.println("Source is still null");
        return Response.NULL;
    }

    private Slice getKey(List<Slice> list, boolean checkForType) {
        for (Slice key : list) {
            Slice result;
            if (!this.base().exists(key)) continue;
            try {
                result = new LLen(this.base(), Collections.singletonList(key)).execute();
            }
            catch (WrongValueTypeException e) {
                if (!checkForType) continue;
                throw e;
            }
            int length = SliceParser.consumeInteger(result.data());
            if (length <= 0) continue;
            return key;
        }
        return null;
    }
}

