/*
 * Decompiled with CFR 0.152.
 */
package soup.neumorphism.internal.shape;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import soup.neumorphism.LightSource;
import soup.neumorphism.NeumorphShapeAppearanceModel;
import soup.neumorphism.NeumorphShapeDrawable;
import soup.neumorphism.internal.blur.BlurProvider;
import soup.neumorphism.internal.shape.Shape;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lsoup/neumorphism/internal/shape/PressedShape;", "Lsoup/neumorphism/internal/shape/Shape;", "drawableState", "Lsoup/neumorphism/NeumorphShapeDrawable$NeumorphShapeDrawableState;", "(Lsoup/neumorphism/NeumorphShapeDrawable$NeumorphShapeDrawableState;)V", "darkShadowDrawable", "Landroid/graphics/drawable/GradientDrawable;", "lightShadowDrawable", "shadowBitmap", "Landroid/graphics/Bitmap;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "outlinePath", "Landroid/graphics/Path;", "generateShadowBitmap", "w", "", "h", "getCornerRadiiForDarkShadow", "", "cornerSize", "", "getCornerRadiiForLightShadow", "getCornerSizeForDarkShadow", "getCornerSizeForLightShadow", "setDrawableState", "newDrawableState", "updateShadowBitmap", "bounds", "Landroid/graphics/Rect;", "neumorphism_release"})
public final class PressedShape
implements Shape {
    private Bitmap shadowBitmap;
    private final GradientDrawable lightShadowDrawable;
    private final GradientDrawable darkShadowDrawable;
    private NeumorphShapeDrawable.NeumorphShapeDrawableState drawableState;

    @Override
    public void setDrawableState(@NotNull NeumorphShapeDrawable.NeumorphShapeDrawableState newDrawableState) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)newDrawableState), (String)"newDrawableState");
        this.drawableState = newDrawableState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull Canvas canvas, @NotNull Path outlinePath) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)outlinePath, (String)"outlinePath");
        Canvas $this$withClip$iv = canvas;
        boolean $i$f$withClip = false;
        int checkpoint$iv = $this$withClip$iv.save();
        $this$withClip$iv.clipPath(outlinePath);
        try {
            Canvas $this$withClip = $this$withClip$iv;
            boolean bl = false;
            Bitmap bitmap = this.shadowBitmap;
            if (bitmap != null) {
                Bitmap bitmap2 = bitmap;
                boolean bl2 = false;
                boolean bl3 = false;
                Bitmap it = bitmap2;
                boolean bl4 = false;
                float left = 0.0f;
                float top = 0.0f;
                Rect inset = this.drawableState.getInset();
                left = inset.left;
                top = inset.top;
                $this$withClip.drawBitmap(it, left, top, null);
            }
        }
        finally {
            $this$withClip$iv.restoreToCount(checkpoint$iv);
        }
    }

    @Override
    public void updateShadowBitmap(@NotNull Rect bounds) {
        float cornerSize;
        boolean bl;
        float f;
        float f2;
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        int shadowElevation = (int)this.drawableState.getShadowElevation();
        int w = bounds.width();
        int h = bounds.height();
        int width = w + shadowElevation;
        int height = h + shadowElevation;
        GradientDrawable gradientDrawable = this.lightShadowDrawable;
        boolean bl2 = false;
        boolean bl3 = false;
        GradientDrawable $this$apply = gradientDrawable;
        boolean bl4 = false;
        $this$apply.setSize(width, height);
        $this$apply.setStroke(shadowElevation, this.drawableState.getShadowColorLight());
        switch (this.drawableState.getShapeAppearanceModel().getCornerFamily()) {
            case 1: {
                $this$apply.setShape(1);
                break;
            }
            case 0: {
                f2 = (float)w / 2.0f;
                f = (float)h / 2.0f;
                bl = false;
                f2 = Math.min(f2, f);
                f = this.getCornerSizeForLightShadow();
                bl = false;
                cornerSize = Math.min(f2, f);
                $this$apply.setShape(0);
                $this$apply.setCornerRadii(this.getCornerRadiiForLightShadow(cornerSize));
            }
        }
        gradientDrawable = this.darkShadowDrawable;
        bl2 = false;
        bl3 = false;
        $this$apply = gradientDrawable;
        boolean bl5 = false;
        $this$apply.setSize(width, height);
        $this$apply.setStroke(shadowElevation, this.drawableState.getShadowColorDark());
        switch (this.drawableState.getShapeAppearanceModel().getCornerFamily()) {
            case 1: {
                $this$apply.setShape(1);
                break;
            }
            case 0: {
                f2 = (float)w / 2.0f;
                f = (float)h / 2.0f;
                bl = false;
                f2 = Math.min(f2, f);
                f = this.getCornerSizeForDarkShadow();
                bl = false;
                cornerSize = Math.min(f2, f);
                $this$apply.setShape(0);
                $this$apply.setCornerRadii(this.getCornerRadiiForDarkShadow(cornerSize));
            }
        }
        this.lightShadowDrawable.setSize(width, height);
        this.lightShadowDrawable.setBounds(0, 0, width, height);
        this.darkShadowDrawable.setSize(width, height);
        this.darkShadowDrawable.setBounds(0, 0, width, height);
        this.shadowBitmap = this.generateShadowBitmap(w, h);
    }

    private final float getCornerSizeForLightShadow() {
        float f;
        NeumorphShapeAppearanceModel neumorphShapeAppearanceModel = this.drawableState.getShapeAppearanceModel();
        boolean bl = false;
        boolean bl2 = false;
        NeumorphShapeAppearanceModel $this$run = neumorphShapeAppearanceModel;
        boolean bl3 = false;
        switch (this.drawableState.getLightSource()) {
            case 0: {
                f = $this$run.getBottomLeftCornerSize();
                break;
            }
            case 1: {
                f = $this$run.getTopRightCornerSize();
                break;
            }
            case 2: {
                f = $this$run.getBottomRightCornerSize();
                break;
            }
            case 3: {
                f = $this$run.getTopLeftCornerSize();
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("LightSource " + this.drawableState.getLightSource() + " is not supported.");
            }
        }
        return f;
    }

    private final float[] getCornerRadiiForLightShadow(float cornerSize) {
        float[] fArray;
        switch (this.drawableState.getLightSource()) {
            case 0: {
                float[] fArray2 = new float[8];
                fArray2[0] = 0.0f;
                fArray2[1] = 0.0f;
                fArray2[2] = 0.0f;
                fArray2[3] = 0.0f;
                fArray2[4] = cornerSize;
                fArray2[5] = cornerSize;
                fArray2[6] = 0.0f;
                fArray = fArray2;
                fArray2[7] = 0.0f;
                break;
            }
            case 1: {
                float[] fArray3 = new float[8];
                fArray3[0] = 0.0f;
                fArray3[1] = 0.0f;
                fArray3[2] = cornerSize;
                fArray3[3] = cornerSize;
                fArray3[4] = 0.0f;
                fArray3[5] = 0.0f;
                fArray3[6] = 0.0f;
                fArray = fArray3;
                fArray3[7] = 0.0f;
                break;
            }
            case 2: {
                float[] fArray4 = new float[8];
                fArray4[0] = 0.0f;
                fArray4[1] = 0.0f;
                fArray4[2] = 0.0f;
                fArray4[3] = 0.0f;
                fArray4[4] = 0.0f;
                fArray4[5] = 0.0f;
                fArray4[6] = cornerSize;
                fArray = fArray4;
                fArray4[7] = cornerSize;
                break;
            }
            case 3: {
                float[] fArray5 = new float[8];
                fArray5[0] = cornerSize;
                fArray5[1] = cornerSize;
                fArray5[2] = 0.0f;
                fArray5[3] = 0.0f;
                fArray5[4] = 0.0f;
                fArray5[5] = 0.0f;
                fArray5[6] = 0.0f;
                fArray = fArray5;
                fArray5[7] = 0.0f;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("LightSource " + this.drawableState.getLightSource() + " is not supported.");
            }
        }
        return fArray;
    }

    private final float getCornerSizeForDarkShadow() {
        float f;
        NeumorphShapeAppearanceModel neumorphShapeAppearanceModel = this.drawableState.getShapeAppearanceModel();
        boolean bl = false;
        boolean bl2 = false;
        NeumorphShapeAppearanceModel $this$run = neumorphShapeAppearanceModel;
        boolean bl3 = false;
        switch (this.drawableState.getLightSource()) {
            case 0: {
                f = $this$run.getTopLeftCornerSize();
                break;
            }
            case 1: {
                f = $this$run.getBottomLeftCornerSize();
                break;
            }
            case 2: {
                f = $this$run.getTopRightCornerSize();
                break;
            }
            case 3: {
                f = $this$run.getBottomRightCornerSize();
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("LightSource " + this.drawableState.getLightSource() + " is not supported.");
            }
        }
        return f;
    }

    private final float[] getCornerRadiiForDarkShadow(float cornerSize) {
        float[] fArray;
        switch (this.drawableState.getLightSource()) {
            case 0: {
                float[] fArray2 = new float[8];
                fArray2[0] = cornerSize;
                fArray2[1] = cornerSize;
                fArray2[2] = 0.0f;
                fArray2[3] = 0.0f;
                fArray2[4] = 0.0f;
                fArray2[5] = 0.0f;
                fArray2[6] = 0.0f;
                fArray = fArray2;
                fArray2[7] = 0.0f;
                break;
            }
            case 1: {
                float[] fArray3 = new float[8];
                fArray3[0] = 0.0f;
                fArray3[1] = 0.0f;
                fArray3[2] = 0.0f;
                fArray3[3] = 0.0f;
                fArray3[4] = 0.0f;
                fArray3[5] = 0.0f;
                fArray3[6] = cornerSize;
                fArray = fArray3;
                fArray3[7] = cornerSize;
                break;
            }
            case 2: {
                float[] fArray4 = new float[8];
                fArray4[0] = 0.0f;
                fArray4[1] = 0.0f;
                fArray4[2] = cornerSize;
                fArray4[3] = cornerSize;
                fArray4[4] = 0.0f;
                fArray4[5] = 0.0f;
                fArray4[6] = 0.0f;
                fArray = fArray4;
                fArray4[7] = 0.0f;
                break;
            }
            case 3: {
                float[] fArray5 = new float[8];
                fArray5[0] = 0.0f;
                fArray5[1] = 0.0f;
                fArray5[2] = 0.0f;
                fArray5[3] = 0.0f;
                fArray5[4] = cornerSize;
                fArray5[5] = cornerSize;
                fArray5[6] = 0.0f;
                fArray = fArray5;
                fArray5[7] = 0.0f;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("LightSource " + this.drawableState.getLightSource() + " is not supported.");
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Bitmap generateShadowBitmap(int w, int h) {
        Canvas $this$withTranslation;
        float x$iv;
        Canvas $this$withTranslation$iv;
        void $this$onCanvas$iv;
        Function1<Bitmap, Bitmap> $fun$blurred$1 = new Function1<Bitmap, Bitmap>(this){
            final /* synthetic */ PressedShape this$0;

            @Nullable
            public final Bitmap invoke(@NotNull Bitmap $this$blurred) {
                Intrinsics.checkParameterIsNotNull((Object)$this$blurred, (String)"$this$blurred");
                if (PressedShape.access$getDrawableState$p(this.this$0).getInEditMode()) {
                    return $this$blurred;
                }
                return BlurProvider.blur$default(PressedShape.access$getDrawableState$p(this.this$0).getBlurProvider(), $this$blurred, 0, 0, 6, null);
            }
            {
                this.this$0 = pressedShape;
                super(1);
            }
        };
        float shadowElevation = this.drawableState.getShadowElevation();
        int lightSource = this.drawableState.getLightSource();
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(w, h, Bitmap.Config.ARGB_8888)");
        Bitmap bitmap2 = bitmap;
        Function1<Bitmap, Bitmap> function1 = $fun$blurred$1;
        boolean $i$f$onCanvas = false;
        void var8_9 = $this$onCanvas$iv;
        boolean bl = false;
        boolean bl2 = false;
        void it$iv = var8_9;
        boolean bl3 = false;
        Canvas canvas = new Canvas((Bitmap)it$iv);
        boolean bl4 = false;
        boolean bl5 = false;
        Canvas $this$onCanvas = canvas;
        boolean bl6 = false;
        Canvas canvas2 = $this$onCanvas;
        float f = LightSource.Companion.isLeft(lightSource) ? -shadowElevation : 0.0f;
        float y$iv = LightSource.Companion.isTop(lightSource) ? -shadowElevation : 0.0f;
        boolean $i$f$withTranslation = false;
        int checkpoint$iv = $this$withTranslation$iv.save();
        $this$withTranslation$iv.translate(x$iv, y$iv);
        try {
            $this$withTranslation = $this$withTranslation$iv;
            boolean bl7 = false;
            this.lightShadowDrawable.draw($this$withTranslation);
        }
        finally {
            $this$withTranslation$iv.restoreToCount(checkpoint$iv);
        }
        $this$withTranslation$iv = $this$onCanvas;
        x$iv = LightSource.Companion.isRight(lightSource) ? -shadowElevation : 0.0f;
        y$iv = LightSource.Companion.isBottom(lightSource) ? -shadowElevation : 0.0f;
        $i$f$withTranslation = false;
        checkpoint$iv = $this$withTranslation$iv.save();
        $this$withTranslation$iv.translate(x$iv, y$iv);
        try {
            $this$withTranslation = $this$withTranslation$iv;
            boolean bl8 = false;
            this.darkShadowDrawable.draw($this$withTranslation);
        }
        finally {
            $this$withTranslation$iv.restoreToCount(checkpoint$iv);
        }
        void var26_28 = var8_9;
        return function1.invoke((Bitmap)var26_28);
    }

    public PressedShape(@NotNull NeumorphShapeDrawable.NeumorphShapeDrawableState drawableState) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)drawableState), (String)"drawableState");
        this.drawableState = drawableState;
        this.lightShadowDrawable = new GradientDrawable();
        this.darkShadowDrawable = new GradientDrawable();
    }

    public static final /* synthetic */ NeumorphShapeDrawable.NeumorphShapeDrawableState access$getDrawableState$p(PressedShape $this) {
        return $this.drawableState;
    }

    public static final /* synthetic */ void access$setDrawableState$p(PressedShape $this, NeumorphShapeDrawable.NeumorphShapeDrawableState neumorphShapeDrawableState) {
        $this.drawableState = neumorphShapeDrawableState;
    }
}

