/*
 * Decompiled with CFR 0.152.
 */
package soup.neumorphism;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.StyleRes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import soup.neumorphism.NeumorphShapeAppearanceModel;
import soup.neumorphism.internal.blur.BlurProvider;
import soup.neumorphism.internal.shape.BasinShape;
import soup.neumorphism.internal.shape.FlatShape;
import soup.neumorphism.internal.shape.PressedShape;
import soup.neumorphism.internal.shape.Shape;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b&\u0018\u0000 q2\u00020\u0001:\u0002qrB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nB\u0017\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB\u000f\b\u0012\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0019H\u0002J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010(\u001a\u00020\u001bH\u0002J\b\u0010)\u001a\u00020*H\u0002J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u0010-\u001a\u0004\u0018\u00010.J\u0006\u0010/\u001a\u00020\bJ\b\u00100\u001a\u00020\bH\u0016J\u0010\u00101\u001a\u00020 2\u0006\u00102\u001a\u000203H\u0016J\u0006\u00104\u001a\u00020\u0019J\b\u00105\u001a\u0004\u0018\u000106J\u0006\u00107\u001a\u000208J\u0006\u00109\u001a\u00020\fJ\u0006\u0010:\u001a\u00020\bJ\b\u0010;\u001a\u0004\u0018\u00010.J\u0006\u0010<\u001a\u000208J\u0006\u0010=\u001a\u000208J\u0006\u0010>\u001a\u000208J\b\u0010?\u001a\u00020\u0014H\u0002J\b\u0010@\u001a\u00020\u0014H\u0002J\b\u0010A\u001a\u00020 H\u0016J\b\u0010B\u001a\u00020 H\u0002J\b\u0010C\u001a\u00020\u0014H\u0016J\b\u0010D\u001a\u00020\u0001H\u0016J\u0010\u0010E\u001a\u00020 2\u0006\u0010!\u001a\u00020*H\u0014J\u0010\u0010F\u001a\u00020\u00142\u0006\u0010G\u001a\u00020HH\u0014J\u0010\u0010I\u001a\u00020 2\u0006\u0010J\u001a\u00020\bH\u0016J\u0012\u0010K\u001a\u00020 2\b\u0010L\u001a\u0004\u0018\u00010MH\u0016J\u0010\u0010N\u001a\u00020 2\b\u0010O\u001a\u0004\u0018\u00010.J\u000e\u0010P\u001a\u00020 2\u0006\u0010Q\u001a\u00020\u0014J&\u0010R\u001a\u00020 2\u0006\u0010S\u001a\u00020\b2\u0006\u0010T\u001a\u00020\b2\u0006\u0010U\u001a\u00020\b2\u0006\u0010V\u001a\u00020\bJ\u000e\u0010W\u001a\u00020 2\u0006\u0010X\u001a\u00020\bJ\u000e\u0010Y\u001a\u00020 2\u0006\u0010Z\u001a\u000206J\u0010\u0010[\u001a\u00020 2\b\b\u0001\u0010\\\u001a\u00020\bJ\u0010\u0010]\u001a\u00020 2\b\b\u0001\u0010\\\u001a\u00020\bJ\u000e\u0010^\u001a\u00020 2\u0006\u0010_\u001a\u000208J\u000e\u0010`\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010a\u001a\u00020 2\u0006\u0010b\u001a\u00020\bJ\u0018\u0010c\u001a\u00020 2\u0006\u0010d\u001a\u0002082\b\u0010e\u001a\u0004\u0018\u00010.J\u0018\u0010c\u001a\u00020 2\u0006\u0010d\u001a\u0002082\b\b\u0001\u0010e\u001a\u00020\bJ\u0010\u0010f\u001a\u00020 2\b\u0010e\u001a\u0004\u0018\u00010.J\u000e\u0010g\u001a\u00020 2\u0006\u0010d\u001a\u000208J\u000e\u0010h\u001a\u00020 2\u0006\u0010i\u001a\u000208J\u0018\u0010j\u001a\u00020\u00142\u0006\u0010k\u001a\u00020\u00142\u0006\u0010l\u001a\u00020\u0014H\u0016J\u000e\u0010m\u001a\u00020 2\u0006\u0010n\u001a\u000208J\u0018\u0010o\u001a\u00020\u001d2\u0006\u0010b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010p\u001a\u00020\u00142\u0006\u0010G\u001a\u00020HH\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006s"}, d2={"Lsoup/neumorphism/NeumorphShapeDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "shapeAppearanceModel", "Lsoup/neumorphism/NeumorphShapeAppearanceModel;", "blurProvider", "Lsoup/neumorphism/internal/blur/BlurProvider;", "(Lsoup/neumorphism/NeumorphShapeAppearanceModel;Lsoup/neumorphism/internal/blur/BlurProvider;)V", "drawableState", "Lsoup/neumorphism/NeumorphShapeDrawable$NeumorphShapeDrawableState;", "(Lsoup/neumorphism/NeumorphShapeDrawable$NeumorphShapeDrawableState;)V", "dirty", "", "fillPaint", "Landroid/graphics/Paint;", "isVisibleChanging", "outlinePath", "Landroid/graphics/Path;", "rectF", "Landroid/graphics/RectF;", "shadow", "Lsoup/neumorphism/internal/shape/Shape;", "strokePaint", "calculateOutlinePath", "", "bounds", "path", "draw", "canvas", "Landroid/graphics/Canvas;", "drawFillShape", "drawStrokeShape", "getBoundsAsRectF", "getBoundsInternal", "Landroid/graphics/Rect;", "getConstantState", "Landroid/graphics/drawable/Drawable$ConstantState;", "getFillColor", "Landroid/content/res/ColorStateList;", "getLightSource", "getOpacity", "getOutline", "outline", "Landroid/graphics/Outline;", "getOutlinePath", "getPaintStyle", "Landroid/graphics/Paint$Style;", "getShadowElevation", "", "getShapeAppearanceModel", "getShapeType", "getStrokeColor", "getStrokeWidth", "getTranslationZ", "getZ", "hasFill", "hasStroke", "invalidateSelf", "invalidateSelfIgnoreShape", "isStateful", "mutate", "onBoundsChange", "onStateChange", "state", "", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setFillColor", "fillColor", "setInEditMode", "inEditMode", "setInset", "left", "top", "right", "bottom", "setLightSource", "lightSource", "setPaintStyle", "paintStyle", "setShadowColorDark", "shadowColor", "setShadowColorLight", "setShadowElevation", "shadowElevation", "setShapeAppearanceModel", "setShapeType", "shapeType", "setStroke", "strokeWidth", "strokeColor", "setStrokeColor", "setStrokeWidth", "setTranslationZ", "translationZ", "setVisible", "visible", "restart", "setZ", "z", "shadowOf", "updateColorsForState", "Companion", "NeumorphShapeDrawableState", "neumorphism_release"})
public final class NeumorphShapeDrawable
extends Drawable {
    private NeumorphShapeDrawableState drawableState;
    private boolean dirty;
    private final Paint fillPaint;
    private final Paint strokePaint;
    private final RectF rectF;
    private final Path outlinePath;
    private Shape shadow;
    private boolean isVisibleChanging;
    public static final Companion Companion = new Companion(null);

    private final Shape shadowOf(int shapeType, NeumorphShapeDrawableState drawableState) {
        Shape shape;
        switch (shapeType) {
            case 0: {
                shape = new FlatShape(drawableState);
                break;
            }
            case 1: {
                shape = new PressedShape(drawableState);
                break;
            }
            case 2: {
                shape = new BasinShape(drawableState);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("ShapeType(" + shapeType + ") is invalid.");
            }
        }
        return shape;
    }

    @Nullable
    public Drawable.ConstantState getConstantState() {
        return this.drawableState;
    }

    @NotNull
    public Drawable mutate() {
        block0: {
            NeumorphShapeDrawableState newDrawableState;
            this.drawableState = newDrawableState = new NeumorphShapeDrawableState(this.drawableState);
            Shape shape = this.shadow;
            if (shape == null) break block0;
            shape.setDrawableState(newDrawableState);
        }
        return this;
    }

    public final void setShapeAppearanceModel(@NotNull NeumorphShapeAppearanceModel shapeAppearanceModel) {
        Intrinsics.checkParameterIsNotNull((Object)shapeAppearanceModel, (String)"shapeAppearanceModel");
        this.drawableState.setShapeAppearanceModel(shapeAppearanceModel);
        this.invalidateSelf();
    }

    @NotNull
    public final NeumorphShapeAppearanceModel getShapeAppearanceModel() {
        return this.drawableState.getShapeAppearanceModel();
    }

    public final void setFillColor(@Nullable ColorStateList fillColor) {
        if (Intrinsics.areEqual((Object)this.drawableState.getFillColor(), (Object)fillColor) ^ true) {
            this.drawableState.setFillColor(fillColor);
            int[] nArray = this.getState();
            Intrinsics.checkExpressionValueIsNotNull((Object)nArray, (String)"state");
            this.onStateChange(nArray);
        }
    }

    @Nullable
    public final ColorStateList getFillColor() {
        return this.drawableState.getFillColor();
    }

    public final void setStrokeColor(@Nullable ColorStateList strokeColor) {
        if (Intrinsics.areEqual((Object)this.drawableState.getStrokeColor(), (Object)strokeColor) ^ true) {
            this.drawableState.setStrokeColor(strokeColor);
            int[] nArray = this.getState();
            Intrinsics.checkExpressionValueIsNotNull((Object)nArray, (String)"state");
            this.onStateChange(nArray);
        }
    }

    @Nullable
    public final ColorStateList getStrokeColor() {
        return this.drawableState.getStrokeColor();
    }

    public final void setStroke(float strokeWidth, @ColorInt int strokeColor) {
        this.setStrokeWidth(strokeWidth);
        this.setStrokeColor(ColorStateList.valueOf((int)strokeColor));
    }

    public final void setStroke(float strokeWidth, @Nullable ColorStateList strokeColor) {
        this.setStrokeWidth(strokeWidth);
        this.setStrokeColor(strokeColor);
    }

    public final float getStrokeWidth() {
        return this.drawableState.getStrokeWidth();
    }

    public final void setStrokeWidth(float strokeWidth) {
        this.drawableState.setStrokeWidth(strokeWidth);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public void setAlpha(int alpha) {
        if (this.drawableState.getAlpha() != alpha) {
            this.drawableState.setAlpha(alpha);
            this.invalidateSelfIgnoreShape();
        }
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    private final Rect getBoundsInternal() {
        Rect rect = this.drawableState.getInset();
        boolean bl = false;
        boolean bl2 = false;
        Rect inset = rect;
        boolean bl3 = false;
        Rect rect2 = super.getBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)rect2, (String)"super.getBounds()");
        Rect bounds = rect2;
        return new Rect(bounds.left + inset.left, bounds.top + inset.top, bounds.right - inset.right, bounds.bottom - inset.bottom);
    }

    private final RectF getBoundsAsRectF() {
        this.rectF.set(this.getBoundsInternal());
        return this.rectF;
    }

    public final void setInset(int left, int top, int right, int bottom) {
        this.drawableState.getInset().set(left, top, right, bottom);
        this.invalidateSelf();
    }

    public final void setLightSource(int lightSource) {
        if (this.drawableState.getLightSource() != lightSource) {
            this.drawableState.setLightSource(lightSource);
            this.invalidateSelf();
        }
    }

    public final int getLightSource() {
        return this.drawableState.getLightSource();
    }

    public final void setShapeType(int shapeType) {
        if (this.drawableState.getShapeType() != shapeType) {
            this.drawableState.setShapeType(shapeType);
            this.shadow = this.shadowOf(shapeType, this.drawableState);
            this.invalidateSelf();
        }
    }

    public final int getShapeType() {
        return this.drawableState.getShapeType();
    }

    public final void setShadowElevation(float shadowElevation) {
        if (this.drawableState.getShadowElevation() != shadowElevation) {
            this.drawableState.setShadowElevation(shadowElevation);
            this.invalidateSelf();
        }
    }

    public final float getShadowElevation() {
        return this.drawableState.getShadowElevation();
    }

    public final void setShadowColorLight(@ColorInt int shadowColor) {
        if (this.drawableState.getShadowColorLight() != shadowColor) {
            this.drawableState.setShadowColorLight(shadowColor);
            this.invalidateSelf();
        }
    }

    public final void setShadowColorDark(@ColorInt int shadowColor) {
        if (this.drawableState.getShadowColorDark() != shadowColor) {
            this.drawableState.setShadowColorDark(shadowColor);
            this.invalidateSelf();
        }
    }

    public final float getTranslationZ() {
        return this.drawableState.getTranslationZ();
    }

    public final void setTranslationZ(float translationZ) {
        if (this.drawableState.getTranslationZ() != translationZ) {
            this.drawableState.setTranslationZ(translationZ);
            this.invalidateSelfIgnoreShape();
        }
    }

    public final float getZ() {
        return this.getShadowElevation() + this.getTranslationZ();
    }

    public final void setZ(float z) {
        this.setTranslationZ(z - this.getShadowElevation());
    }

    public void invalidateSelf() {
        if (!this.isVisibleChanging) {
            this.dirty = true;
        }
        super.invalidateSelf();
    }

    private final void invalidateSelfIgnoreShape() {
        super.invalidateSelf();
    }

    @Nullable
    public final Paint.Style getPaintStyle() {
        return this.drawableState.getPaintStyle();
    }

    public final void setPaintStyle(@NotNull Paint.Style paintStyle) {
        Intrinsics.checkParameterIsNotNull((Object)paintStyle, (String)"paintStyle");
        this.drawableState.setPaintStyle(paintStyle);
        this.invalidateSelfIgnoreShape();
    }

    private final boolean hasFill() {
        return this.drawableState.getPaintStyle() == Paint.Style.FILL_AND_STROKE || this.drawableState.getPaintStyle() == Paint.Style.FILL;
    }

    private final boolean hasStroke() {
        return (this.drawableState.getPaintStyle() == Paint.Style.FILL_AND_STROKE || this.drawableState.getPaintStyle() == Paint.Style.STROKE) && this.strokePaint.getStrokeWidth() > 0.0f;
    }

    public boolean setVisible(boolean visible, boolean restart) {
        this.isVisibleChanging = true;
        boolean bl = super.setVisible(visible, restart);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean $this$apply = bl;
        boolean bl4 = false;
        this.isVisibleChanging = false;
        return bl;
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        this.dirty = true;
        super.onBoundsChange(bounds);
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        int prevAlpha = this.fillPaint.getAlpha();
        this.fillPaint.setAlpha(NeumorphShapeDrawable.Companion.modulateAlpha(prevAlpha, this.drawableState.getAlpha()));
        this.strokePaint.setStrokeWidth(this.drawableState.getStrokeWidth());
        int prevStrokeAlpha = this.strokePaint.getAlpha();
        this.strokePaint.setAlpha(NeumorphShapeDrawable.Companion.modulateAlpha(prevStrokeAlpha, this.drawableState.getAlpha()));
        if (this.dirty) {
            this.calculateOutlinePath(this.getBoundsAsRectF(), this.outlinePath);
            Shape shape = this.shadow;
            if (shape != null) {
                shape.updateShadowBitmap(this.getBoundsInternal());
            }
            this.dirty = false;
        }
        if (this.hasFill()) {
            this.drawFillShape(canvas);
        }
        Shape shape = this.shadow;
        if (shape != null) {
            shape.draw(canvas, this.outlinePath);
        }
        if (this.hasStroke()) {
            this.drawStrokeShape(canvas);
        }
        this.fillPaint.setAlpha(prevAlpha);
        this.strokePaint.setAlpha(prevStrokeAlpha);
    }

    private final void drawFillShape(Canvas canvas) {
        canvas.drawPath(this.outlinePath, this.fillPaint);
    }

    private final void drawStrokeShape(Canvas canvas) {
        canvas.drawPath(this.outlinePath, this.strokePaint);
    }

    @NotNull
    public final Path getOutlinePath() {
        return this.outlinePath;
    }

    private final void calculateOutlinePath(RectF bounds, Path path) {
        NeumorphShapeAppearanceModel shapeAppearanceModel = this.drawableState.getShapeAppearanceModel();
        float left = this.drawableState.getInset().left;
        float top = this.drawableState.getInset().top;
        float right = left + bounds.width();
        float bottom = top + bounds.height();
        path.reset();
        switch (shapeAppearanceModel.getCornerFamily()) {
            case 1: {
                path.addOval(left, top, right, bottom, Path.Direction.CW);
                break;
            }
            case 0: {
                float f = bounds.width() / 2.0f;
                float f2 = bounds.height() / 2.0f;
                NeumorphShapeAppearanceModel neumorphShapeAppearanceModel = shapeAppearanceModel;
                float f3 = bottom;
                float f4 = right;
                float f5 = top;
                float f6 = left;
                Path path2 = path;
                boolean bl = false;
                float f7 = Math.min(f, f2);
                path2.addRoundRect(f6, f5, f4, f3, neumorphShapeAppearanceModel.getCornerRadii$neumorphism_release(f7), Path.Direction.CW);
                break;
            }
        }
        path.close();
    }

    public void getOutline(@NotNull Outline outline) {
        Intrinsics.checkParameterIsNotNull((Object)outline, (String)"outline");
        NeumorphShapeAppearanceModel shapeAppearanceModel = this.drawableState.getShapeAppearanceModel();
        switch (shapeAppearanceModel.getCornerFamily()) {
            case 1: {
                outline.setOval(this.getBoundsInternal());
                break;
            }
            case 0: {
                outline.setRect(this.getBoundsInternal());
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isStateful() {
        if (super.isStateful()) return true;
        ColorStateList colorStateList = this.drawableState.getFillColor();
        if (colorStateList == null) return false;
        if (!colorStateList.isStateful()) return false;
        return true;
    }

    protected boolean onStateChange(@NotNull int[] state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        boolean invalidateSelf = this.updateColorsForState(state);
        if (invalidateSelf) {
            this.invalidateSelf();
        }
        return invalidateSelf;
    }

    private final boolean updateColorsForState(int[] state) {
        boolean invalidateSelf;
        block3: {
            int newStrokeColor;
            boolean bl;
            boolean bl2;
            ColorStateList colorStateList;
            invalidateSelf = false;
            ColorStateList colorStateList2 = this.drawableState.getFillColor();
            if (colorStateList2 != null) {
                int newFillColor;
                colorStateList = colorStateList2;
                bl2 = false;
                bl = false;
                ColorStateList fillColor = colorStateList;
                boolean bl3 = false;
                int previousFillColor = this.fillPaint.getColor();
                if (previousFillColor != (newFillColor = fillColor.getColorForState(state, previousFillColor))) {
                    this.fillPaint.setColor(newFillColor);
                    invalidateSelf = true;
                }
            }
            ColorStateList colorStateList3 = this.drawableState.getStrokeColor();
            if (colorStateList3 == null) break block3;
            colorStateList = colorStateList3;
            bl2 = false;
            bl = false;
            ColorStateList strokeColor = colorStateList;
            boolean bl4 = false;
            int previousStrokeColor = this.strokePaint.getColor();
            if (previousStrokeColor != (newStrokeColor = strokeColor.getColorForState(state, previousStrokeColor))) {
                this.strokePaint.setColor(newStrokeColor);
                invalidateSelf = true;
            }
        }
        return invalidateSelf;
    }

    public final void setInEditMode(boolean inEditMode) {
        this.drawableState.setInEditMode(inEditMode);
    }

    public NeumorphShapeDrawable(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(new NeumorphShapeAppearanceModel(), new BlurProvider(context));
    }

    public NeumorphShapeDrawable(@NotNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(NeumorphShapeAppearanceModel.Companion.builder$default(NeumorphShapeAppearanceModel.Companion, context, attrs, defStyleAttr, defStyleRes, 0.0f, 16, null).build(), new BlurProvider(context));
    }

    public NeumorphShapeDrawable(@NotNull NeumorphShapeAppearanceModel shapeAppearanceModel, @NotNull BlurProvider blurProvider) {
        Intrinsics.checkParameterIsNotNull((Object)shapeAppearanceModel, (String)"shapeAppearanceModel");
        Intrinsics.checkParameterIsNotNull((Object)blurProvider, (String)"blurProvider");
        this(new NeumorphShapeDrawableState(shapeAppearanceModel, blurProvider));
    }

    private NeumorphShapeDrawable(NeumorphShapeDrawableState drawableState) {
        Paint paint;
        Paint paint2 = new Paint(1);
        NeumorphShapeDrawable neumorphShapeDrawable = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint2;
        boolean bl3 = false;
        $this$apply.setStyle(Paint.Style.FILL);
        $this$apply.setColor(0);
        neumorphShapeDrawable.fillPaint = paint = paint2;
        paint2 = new Paint(1);
        neumorphShapeDrawable = this;
        bl = false;
        bl2 = false;
        $this$apply = paint2;
        boolean bl4 = false;
        $this$apply.setStyle(Paint.Style.STROKE);
        $this$apply.setColor(0);
        neumorphShapeDrawable.strokePaint = paint = paint2;
        this.rectF = new RectF();
        this.outlinePath = new Path();
        this.drawableState = drawableState;
        this.shadow = this.shadowOf(drawableState.getShapeType(), drawableState);
    }

    public /* synthetic */ NeumorphShapeDrawable(NeumorphShapeDrawableState drawableState, DefaultConstructorMarker $constructor_marker) {
        this(drawableState);
    }

    public static final /* synthetic */ boolean access$getDirty$p(NeumorphShapeDrawable $this) {
        return $this.dirty;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\bJ\b\u0010K\u001a\u00020\nH\u0016J\b\u0010L\u001a\u00020MH\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R \u0010#\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b$\u0010%\u001a\u0004\b&\u0010\f\"\u0004\b'\u0010\u000eR\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\f\"\u0004\b0\u0010\u000eR\u001a\u00101\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\f\"\u0004\b3\u0010\u000eR\u001a\u00104\u001a\u000205X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R \u0010>\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b?\u0010%\u001a\u0004\b@\u0010\f\"\u0004\bA\u0010\u000eR\u001c\u0010B\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0014\"\u0004\bD\u0010\u0016R\u001a\u0010E\u001a\u000205X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u00107\"\u0004\bG\u00109R\u001a\u0010H\u001a\u000205X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u00107\"\u0004\bJ\u00109\u00a8\u0006N"}, d2={"Lsoup/neumorphism/NeumorphShapeDrawable$NeumorphShapeDrawableState;", "Landroid/graphics/drawable/Drawable$ConstantState;", "shapeAppearanceModel", "Lsoup/neumorphism/NeumorphShapeAppearanceModel;", "blurProvider", "Lsoup/neumorphism/internal/blur/BlurProvider;", "(Lsoup/neumorphism/NeumorphShapeAppearanceModel;Lsoup/neumorphism/internal/blur/BlurProvider;)V", "orig", "(Lsoup/neumorphism/NeumorphShapeDrawable$NeumorphShapeDrawableState;)V", "alpha", "", "getAlpha", "()I", "setAlpha", "(I)V", "getBlurProvider", "()Lsoup/neumorphism/internal/blur/BlurProvider;", "fillColor", "Landroid/content/res/ColorStateList;", "getFillColor", "()Landroid/content/res/ColorStateList;", "setFillColor", "(Landroid/content/res/ColorStateList;)V", "inEditMode", "", "getInEditMode", "()Z", "setInEditMode", "(Z)V", "inset", "Landroid/graphics/Rect;", "getInset", "()Landroid/graphics/Rect;", "setInset", "(Landroid/graphics/Rect;)V", "lightSource", "lightSource$annotations", "()V", "getLightSource", "setLightSource", "paintStyle", "Landroid/graphics/Paint$Style;", "getPaintStyle", "()Landroid/graphics/Paint$Style;", "setPaintStyle", "(Landroid/graphics/Paint$Style;)V", "shadowColorDark", "getShadowColorDark", "setShadowColorDark", "shadowColorLight", "getShadowColorLight", "setShadowColorLight", "shadowElevation", "", "getShadowElevation", "()F", "setShadowElevation", "(F)V", "getShapeAppearanceModel", "()Lsoup/neumorphism/NeumorphShapeAppearanceModel;", "setShapeAppearanceModel", "(Lsoup/neumorphism/NeumorphShapeAppearanceModel;)V", "shapeType", "shapeType$annotations", "getShapeType", "setShapeType", "strokeColor", "getStrokeColor", "setStrokeColor", "strokeWidth", "getStrokeWidth", "setStrokeWidth", "translationZ", "getTranslationZ", "setTranslationZ", "getChangingConfigurations", "newDrawable", "Landroid/graphics/drawable/Drawable;", "neumorphism_release"})
    public static final class NeumorphShapeDrawableState
    extends Drawable.ConstantState {
        @NotNull
        private NeumorphShapeAppearanceModel shapeAppearanceModel;
        @NotNull
        private final BlurProvider blurProvider;
        private boolean inEditMode;
        @NotNull
        private Rect inset;
        @Nullable
        private ColorStateList fillColor;
        @Nullable
        private ColorStateList strokeColor;
        private float strokeWidth;
        private int alpha;
        private int lightSource;
        private int shapeType;
        private float shadowElevation;
        private int shadowColorLight;
        private int shadowColorDark;
        private float translationZ;
        @NotNull
        private Paint.Style paintStyle;

        @NotNull
        public final NeumorphShapeAppearanceModel getShapeAppearanceModel() {
            return this.shapeAppearanceModel;
        }

        public final void setShapeAppearanceModel(@NotNull NeumorphShapeAppearanceModel neumorphShapeAppearanceModel) {
            Intrinsics.checkParameterIsNotNull((Object)neumorphShapeAppearanceModel, (String)"<set-?>");
            this.shapeAppearanceModel = neumorphShapeAppearanceModel;
        }

        @NotNull
        public final BlurProvider getBlurProvider() {
            return this.blurProvider;
        }

        public final boolean getInEditMode() {
            return this.inEditMode;
        }

        public final void setInEditMode(boolean bl) {
            this.inEditMode = bl;
        }

        @NotNull
        public final Rect getInset() {
            return this.inset;
        }

        public final void setInset(@NotNull Rect rect) {
            Intrinsics.checkParameterIsNotNull((Object)rect, (String)"<set-?>");
            this.inset = rect;
        }

        @Nullable
        public final ColorStateList getFillColor() {
            return this.fillColor;
        }

        public final void setFillColor(@Nullable ColorStateList colorStateList) {
            this.fillColor = colorStateList;
        }

        @Nullable
        public final ColorStateList getStrokeColor() {
            return this.strokeColor;
        }

        public final void setStrokeColor(@Nullable ColorStateList colorStateList) {
            this.strokeColor = colorStateList;
        }

        public final float getStrokeWidth() {
            return this.strokeWidth;
        }

        public final void setStrokeWidth(float f) {
            this.strokeWidth = f;
        }

        public final int getAlpha() {
            return this.alpha;
        }

        public final void setAlpha(int n) {
            this.alpha = n;
        }

        public static /* synthetic */ void lightSource$annotations() {
        }

        public final int getLightSource() {
            return this.lightSource;
        }

        public final void setLightSource(int n) {
            this.lightSource = n;
        }

        public static /* synthetic */ void shapeType$annotations() {
        }

        public final int getShapeType() {
            return this.shapeType;
        }

        public final void setShapeType(int n) {
            this.shapeType = n;
        }

        public final float getShadowElevation() {
            return this.shadowElevation;
        }

        public final void setShadowElevation(float f) {
            this.shadowElevation = f;
        }

        public final int getShadowColorLight() {
            return this.shadowColorLight;
        }

        public final void setShadowColorLight(int n) {
            this.shadowColorLight = n;
        }

        public final int getShadowColorDark() {
            return this.shadowColorDark;
        }

        public final void setShadowColorDark(int n) {
            this.shadowColorDark = n;
        }

        public final float getTranslationZ() {
            return this.translationZ;
        }

        public final void setTranslationZ(float f) {
            this.translationZ = f;
        }

        @NotNull
        public final Paint.Style getPaintStyle() {
            return this.paintStyle;
        }

        public final void setPaintStyle(@NotNull Paint.Style style2) {
            Intrinsics.checkParameterIsNotNull((Object)style2, (String)"<set-?>");
            this.paintStyle = style2;
        }

        @NotNull
        public Drawable newDrawable() {
            NeumorphShapeDrawable neumorphShapeDrawable = new NeumorphShapeDrawable(this, null);
            boolean bl = false;
            boolean bl2 = false;
            NeumorphShapeDrawable $this$apply = neumorphShapeDrawable;
            boolean bl3 = false;
            $this$apply.dirty = true;
            return neumorphShapeDrawable;
        }

        public int getChangingConfigurations() {
            return 0;
        }

        public NeumorphShapeDrawableState(@NotNull NeumorphShapeAppearanceModel shapeAppearanceModel, @NotNull BlurProvider blurProvider) {
            Intrinsics.checkParameterIsNotNull((Object)shapeAppearanceModel, (String)"shapeAppearanceModel");
            Intrinsics.checkParameterIsNotNull((Object)blurProvider, (String)"blurProvider");
            this.inset = new Rect();
            this.alpha = 255;
            this.shadowColorLight = -1;
            this.shadowColorDark = -16777216;
            this.paintStyle = Paint.Style.FILL_AND_STROKE;
            this.shapeAppearanceModel = shapeAppearanceModel;
            this.blurProvider = blurProvider;
        }

        public NeumorphShapeDrawableState(@NotNull NeumorphShapeDrawableState orig) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)orig), (String)"orig");
            this.inset = new Rect();
            this.alpha = 255;
            this.shadowColorLight = -1;
            this.shadowColorDark = -16777216;
            this.paintStyle = Paint.Style.FILL_AND_STROKE;
            this.shapeAppearanceModel = orig.shapeAppearanceModel;
            this.blurProvider = orig.blurProvider;
            this.inEditMode = orig.inEditMode;
            this.inset = new Rect(orig.inset);
            this.fillColor = orig.fillColor;
            this.strokeColor = orig.strokeColor;
            this.strokeWidth = orig.strokeWidth;
            this.alpha = orig.alpha;
            this.lightSource = orig.lightSource;
            this.shapeType = orig.shapeType;
            this.shadowElevation = orig.shadowElevation;
            this.shadowColorLight = orig.shadowColorLight;
            this.shadowColorDark = orig.shadowColorDark;
            this.translationZ = orig.translationZ;
            this.paintStyle = orig.paintStyle;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a8\u0006\u0007"}, d2={"Lsoup/neumorphism/NeumorphShapeDrawable$Companion;", "", "()V", "modulateAlpha", "", "paintAlpha", "alpha", "neumorphism_release"})
    public static final class Companion {
        private final int modulateAlpha(int paintAlpha, int alpha) {
            int scale = alpha + (alpha >>> 7);
            return paintAlpha * scale >>> 8;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

