/*
 * Decompiled with CFR 0.152.
 */
package com.forjrking.lubankt.parser;

import android.util.Log;
import com.forjrking.lubankt.io.ArrayProvide;
import com.forjrking.lubankt.parser.ImageType;
import com.forjrking.lubankt.parser.ImgHeaderParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public final class DefaultImgHeaderParser
implements ImgHeaderParser {
    private static final String TAG = "DfltImageHeaderParser";
    private static final int GIF_HEADER = 4671814;
    private static final int PNG_HEADER = -1991225785;
    static final int EXIF_MAGIC_NUMBER = 65496;
    private static final int MOTOROLA_TIFF_MAGIC_NUMBER = 19789;
    private static final int INTEL_TIFF_MAGIC_NUMBER = 18761;
    private static final String JPEG_EXIF_SEGMENT_PREAMBLE = "Exif\u0000\u0000";
    static final byte[] JPEG_EXIF_SEGMENT_PREAMBLE_BYTES = "Exif\u0000\u0000".getBytes(Charset.forName("UTF-8"));
    private static final int SEGMENT_SOS = 218;
    private static final int MARKER_EOI = 217;
    static final int SEGMENT_START_ID = 255;
    static final int EXIF_SEGMENT_TYPE = 225;
    private static final int ORIENTATION_TAG_TYPE = 274;
    private static final int[] BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int RIFF_HEADER = 1380533830;
    private static final int WEBP_HEADER = 1464156752;
    private static final int VP8_HEADER = 1448097792;
    private static final int VP8_HEADER_MASK = -256;
    private static final int VP8_HEADER_TYPE_MASK = 255;
    private static final int VP8_HEADER_TYPE_EXTENDED = 88;
    private static final int VP8_HEADER_TYPE_LOSSLESS = 76;
    private static final int WEBP_EXTENDED_ALPHA_FLAG = 16;
    private static final int WEBP_LOSSLESS_ALPHA_FLAG = 8;

    @Override
    public ImageType getType(InputStream is) throws IOException {
        return this.getType(new StreamReader(is));
    }

    @Override
    public int getOrientation(InputStream is) throws IOException {
        return this.getOrientation(new StreamReader(is));
    }

    private ImageType getType(Reader reader2) throws IOException {
        try {
            int firstTwoBytes = reader2.getUInt16();
            if (firstTwoBytes == 65496) {
                return ImageType.JPEG;
            }
            int firstThreeBytes = firstTwoBytes << 8 | reader2.getUInt8();
            if (firstThreeBytes == 4671814) {
                return ImageType.GIF;
            }
            int firstFourBytes = firstThreeBytes << 8 | reader2.getUInt8();
            if (firstFourBytes == -1991225785) {
                reader2.skip(21L);
                try {
                    short alpha = reader2.getUInt8();
                    return alpha >= 3 ? ImageType.PNG_A : ImageType.PNG;
                }
                catch (Reader.EndOfFileException e) {
                    return ImageType.PNG;
                }
            }
            if (firstFourBytes != 1380533830) {
                return ImageType.UNKNOWN;
            }
            reader2.skip(4L);
            int thirdFourBytes = reader2.getUInt16() << 16 | reader2.getUInt16();
            if (thirdFourBytes != 1464156752) {
                return ImageType.UNKNOWN;
            }
            int fourthFourBytes = reader2.getUInt16() << 16 | reader2.getUInt16();
            if ((fourthFourBytes & 0xFFFFFF00) != 1448097792) {
                return ImageType.UNKNOWN;
            }
            if ((fourthFourBytes & 0xFF) == 88) {
                reader2.skip(4L);
                short flags = reader2.getUInt8();
                return (flags & 0x10) != 0 ? ImageType.WEBP_A : ImageType.WEBP;
            }
            if ((fourthFourBytes & 0xFF) == 76) {
                reader2.skip(4L);
                short flags = reader2.getUInt8();
                return (flags & 8) != 0 ? ImageType.WEBP_A : ImageType.WEBP;
            }
            return ImageType.WEBP;
        }
        catch (Reader.EndOfFileException e) {
            return ImageType.UNKNOWN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOrientation(Reader reader2) throws IOException {
        int n;
        int magicNumber = reader2.getUInt16();
        if (!DefaultImgHeaderParser.handles(magicNumber)) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Parser doesn't handle magic number: " + magicNumber));
            }
            return -1;
        }
        int exifSegmentLength = this.moveToExifSegmentAndGetLength(reader2);
        if (exifSegmentLength == -1) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to parse exif segment length, or exif segment not found");
            }
            return -1;
        }
        byte[] exifData = ArrayProvide.get(exifSegmentLength);
        try {
            n = this.parseExifSegment(reader2, exifData, exifSegmentLength);
        }
        catch (Throwable throwable) {
            try {
                ArrayProvide.put(exifData);
                throw throwable;
            }
            catch (Reader.EndOfFileException e) {
                return -1;
            }
        }
        ArrayProvide.put(exifData);
        return n;
    }

    private int parseExifSegment(Reader reader2, byte[] tempArray, int exifSegmentLength) throws IOException {
        int read = reader2.read(tempArray, exifSegmentLength);
        if (read != exifSegmentLength) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to read exif segment data, length: " + exifSegmentLength + ", actually read: " + read));
            }
            return -1;
        }
        boolean hasJpegExifPreamble = this.hasJpegExifPreamble(tempArray, exifSegmentLength);
        if (hasJpegExifPreamble) {
            return DefaultImgHeaderParser.parseExifSegment(new RandomAccessReader(tempArray, exifSegmentLength));
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"Missing jpeg exif preamble");
        }
        return -1;
    }

    private boolean hasJpegExifPreamble(byte[] exifData, int exifSegmentLength) {
        boolean result2;
        boolean bl = result2 = exifData != null && exifSegmentLength > JPEG_EXIF_SEGMENT_PREAMBLE_BYTES.length;
        if (result2) {
            for (int i = 0; i < JPEG_EXIF_SEGMENT_PREAMBLE_BYTES.length; ++i) {
                if (exifData[i] == JPEG_EXIF_SEGMENT_PREAMBLE_BYTES[i]) continue;
                result2 = false;
                break;
            }
        }
        return result2;
    }

    private int moveToExifSegmentAndGetLength(Reader reader2) throws IOException {
        int segmentContentsLength;
        block7: {
            short segmentType;
            long skipped;
            do {
                short segmentId;
                if ((segmentId = reader2.getUInt8()) != 255) {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.d((String)TAG, (String)("Unknown segmentId=" + segmentId));
                    }
                    return -1;
                }
                segmentType = reader2.getUInt8();
                if (segmentType == 218) {
                    return -1;
                }
                if (segmentType == 217) {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.d((String)TAG, (String)"Found MARKER_EOI in exif segment");
                    }
                    return -1;
                }
                int segmentLength = reader2.getUInt16();
                segmentContentsLength = segmentLength - 2;
                if (segmentType == 225) break block7;
            } while ((skipped = reader2.skip(segmentContentsLength)) == (long)segmentContentsLength);
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to skip enough data, type: " + segmentType + ", wanted to skip: " + segmentContentsLength + ", but actually skipped: " + skipped));
            }
            return -1;
        }
        return segmentContentsLength;
    }

    private static int parseExifSegment(RandomAccessReader segmentData) {
        ByteOrder byteOrder;
        int headerOffsetSize = JPEG_EXIF_SEGMENT_PREAMBLE.length();
        short byteOrderIdentifier = segmentData.getInt16(headerOffsetSize);
        switch (byteOrderIdentifier) {
            case 19789: {
                byteOrder = ByteOrder.BIG_ENDIAN;
                break;
            }
            case 18761: {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            default: {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("Unknown endianness = " + byteOrderIdentifier));
                }
                byteOrder = ByteOrder.BIG_ENDIAN;
            }
        }
        segmentData.order(byteOrder);
        int firstIfdOffset = segmentData.getInt32(headerOffsetSize + 4) + headerOffsetSize;
        int tagCount = segmentData.getInt16(firstIfdOffset);
        for (int i = 0; i < tagCount; ++i) {
            int byteCount;
            int tagOffset = DefaultImgHeaderParser.calcTagOffset(firstIfdOffset, i);
            short tagType = segmentData.getInt16(tagOffset);
            if (tagType != 274) continue;
            short formatCode = segmentData.getInt16(tagOffset + 2);
            if (formatCode < 1 || formatCode > 12) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Got invalid format code = " + formatCode));
                continue;
            }
            int componentCount = segmentData.getInt32(tagOffset + 4);
            if (componentCount < 0) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)"Negative tiff component count");
                continue;
            }
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Got tagIndex=" + i + " tagType=" + tagType + " formatCode=" + formatCode + " componentCount=" + componentCount));
            }
            if ((byteCount = componentCount + BYTES_PER_FORMAT[formatCode]) > 4) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Got byte count > 4, not orientation, continuing, formatCode=" + formatCode));
                continue;
            }
            int tagValueOffset = tagOffset + 8;
            if (tagValueOffset < 0 || tagValueOffset > segmentData.length()) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Illegal tagValueOffset=" + tagValueOffset + " tagType=" + tagType));
                continue;
            }
            if (byteCount < 0 || tagValueOffset + byteCount > segmentData.length()) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Illegal number of bytes for TI tag data tagType=" + tagType));
                continue;
            }
            return segmentData.getInt16(tagValueOffset);
        }
        return -1;
    }

    private static int calcTagOffset(int ifdOffset, int tagIndex) {
        return ifdOffset + 2 + 12 * tagIndex;
    }

    private static boolean handles(int imageMagicNumber) {
        return (imageMagicNumber & 0xFFD8) == 65496 || imageMagicNumber == 19789 || imageMagicNumber == 18761;
    }

    private static final class StreamReader
    implements Reader {
        private final InputStream is;

        StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public short getUInt8() throws IOException {
            int readResult = this.is.read();
            if (readResult == -1) {
                throw new Reader.EndOfFileException();
            }
            return (short)readResult;
        }

        @Override
        public int getUInt16() throws IOException {
            return this.getUInt8() << 8 | this.getUInt8();
        }

        @Override
        public int read(byte[] buffer, int byteCount) throws IOException {
            int numBytesRead;
            int lastReadResult = 0;
            for (numBytesRead = 0; numBytesRead < byteCount && (lastReadResult = this.is.read(buffer, numBytesRead, byteCount - numBytesRead)) != -1; numBytesRead += lastReadResult) {
            }
            if (numBytesRead == 0 && lastReadResult == -1) {
                throw new Reader.EndOfFileException();
            }
            return numBytesRead;
        }

        @Override
        public long skip(long total) throws IOException {
            if (total < 0L) {
                return 0L;
            }
            long toSkip = total;
            while (toSkip > 0L) {
                long skipped = this.is.skip(toSkip);
                if (skipped > 0L) {
                    toSkip -= skipped;
                    continue;
                }
                int testEofByte = this.is.read();
                if (testEofByte == -1) break;
                --toSkip;
            }
            return total - toSkip;
        }
    }

    private static interface Reader {
        public short getUInt8() throws IOException;

        public int getUInt16() throws IOException;

        public int read(byte[] var1, int var2) throws IOException;

        public long skip(long var1) throws IOException;

        public static final class EndOfFileException
        extends IOException {
            private static final long serialVersionUID = 1L;

            EndOfFileException() {
                super("Unexpectedly reached end of a file");
            }
        }
    }

    private static final class RandomAccessReader {
        private final ByteBuffer data;

        RandomAccessReader(byte[] data, int length) {
            this.data = (ByteBuffer)ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN).limit(length);
        }

        void order(ByteOrder byteOrder) {
            this.data.order(byteOrder);
        }

        int length() {
            return this.data.remaining();
        }

        int getInt32(int offset) {
            return this.isAvailable(offset, 4) ? this.data.getInt(offset) : -1;
        }

        short getInt16(int offset) {
            return this.isAvailable(offset, 2) ? this.data.getShort(offset) : (short)-1;
        }

        private boolean isAvailable(int offset, int byteSize) {
            return this.data.remaining() - offset >= byteSize;
        }
    }
}

