/*
 * Decompiled with CFR 0.152.
 */
package com.forjrking.lubankt;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.os.Build;
import androidx.annotation.WorkerThread;
import com.forjrking.lubankt.Checker;
import com.forjrking.lubankt.io.ArrayProvide;
import com.forjrking.lubankt.io.InputStreamProvider;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BA\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0005H\u0007J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J \u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/forjrking/lubankt/CompressEngine;", "", "srcStream", "Lcom/forjrking/lubankt/io/InputStreamProvider;", "resFile", "Ljava/io/File;", "compress4Sample", "", "rqSize", "", "quality", "", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "compressConfig", "Landroid/graphics/Bitmap$Config;", "(Lcom/forjrking/lubankt/io/InputStreamProvider;Ljava/io/File;ZJILandroid/graphics/Bitmap$CompressFormat;Landroid/graphics/Bitmap$Config;)V", "compress", "computeSampleSize", "width", "height", "computeScaleSize", "", "hasEnoughMemory", "isAlpha32", "transformBitmap", "Landroid/graphics/Bitmap;", "bitmap", "scale", "angle", "library_release"})
public final class CompressEngine {
    private final InputStreamProvider<?> srcStream;
    private final File resFile;
    private final boolean compress4Sample;
    private final long rqSize;
    private final int quality;
    private final Bitmap.CompressFormat compressFormat;
    private final Bitmap.Config compressConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NotNull
    public final File compress() throws IOException {
        boolean isAlpha;
        float f;
        int angle = Checker.INSTANCE.getRotateDegree(this.srcStream.rewindAndGet());
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)this.srcStream.rewindAndGet(), null, (BitmapFactory.Options)options);
        int width = options.outWidth;
        int height = options.outHeight;
        if (this.compress4Sample) {
            options.inSampleSize = this.computeSampleSize(width, height);
            f = 1.0f;
        } else {
            options.inSampleSize = 0;
            f = this.computeScaleSize(width, height);
        }
        float scale = f;
        Checker.INSTANCE.logger("scale :" + scale + ",inSampleSize :" + options.inSampleSize + ",rotate :" + angle);
        options.inPreferredConfig = this.compressConfig;
        int tempScale = options.inSampleSize <= 0 ? 1 : options.inSampleSize;
        boolean bl = isAlpha = this.compressConfig == Bitmap.Config.ARGB_8888;
        if (!this.hasEnoughMemory(width / tempScale, height / tempScale, isAlpha)) {
            if (!isAlpha || !this.hasEnoughMemory(width / tempScale, height / tempScale, false)) {
                throw (Throwable)new IOException("image memory is too large");
            }
            Checker.INSTANCE.logger("memory warring \u964d\u4f4e\u4f4d\u56fe\u50cf\u7d20");
            options.inPreferredConfig = Bitmap.Config.RGB_565;
        }
        options.inJustDecodeBounds = false;
        if (options.inPreferredConfig == Bitmap.Config.RGB_565) {
            options.inDither = true;
        }
        options.inPreferQualityOverSpeed = true;
        byte[] bytes4Option = ArrayProvide.get(16384);
        options.inTempStorage = bytes4Option;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)this.srcStream.rewindAndGet(), null, (BitmapFactory.Options)options);
        if (bitmap == null) {
            throw (Throwable)new IOException("decodeStream error");
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"BitmapFactory.decodeStre\u2026ion(\"decodeStream error\")");
        Bitmap bitmap2 = bitmap;
        bitmap2 = this.transformBitmap(bitmap2, scale, angle);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            bitmap2.compress(this.compressFormat, this.quality, (OutputStream)stream);
            if (this.compressFormat != Bitmap.CompressFormat.PNG) {
                int tempQuality = this.quality;
                while ((float)(stream.size() / 1024) > (float)this.rqSize * scale && tempQuality > 6) {
                    stream.reset();
                    bitmap2.compress(this.compressFormat, tempQuality -= 6, (OutputStream)stream);
                }
                Checker.INSTANCE.logger("\u771f\u5b9e\u8f93\u51fa\u8d28\u91cf" + tempQuality);
            }
        }
        finally {
            bitmap2.recycle();
            ArrayProvide.put(bytes4Option);
            Checker.INSTANCE.logger("\u771f\u5b9e\u8f93\u51fa\u5927\u5c0f:" + stream.size());
        }
        Closeable closeable = stream;
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream bos = (ByteArrayOutputStream)closeable;
            boolean bl4 = false;
            Closeable closeable2 = new FileOutputStream(this.resFile);
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable2 = null;
            try {
                FileOutputStream fos = (FileOutputStream)closeable2;
                boolean bl7 = false;
                bos.writeTo(fos);
                fos.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return this.resFile;
    }

    private final int computeSampleSize(int width, int height) {
        int n;
        int srcWidth = width % 2 == 1 ? width + 1 : width;
        int srcHeight = height % 2 == 1 ? height + 1 : height;
        boolean bl = false;
        int longSide = Math.max(srcWidth, srcHeight);
        boolean bl2 = false;
        int shortSide = Math.min(srcWidth, srcHeight);
        float scale = (float)shortSide / (float)longSide;
        if (scale <= 1.0f && (double)scale > 0.5625) {
            int n2;
            n = longSide < 1664 ? 1 : (longSide < 4990 ? 2 : (4991 <= (n2 = longSide) && 10239 >= n2 ? 4 : (longSide / 1280 == 0 ? 1 : longSide / 1280)));
        } else if ((double)scale <= 0.5625 && (double)scale > 0.5) {
            n = longSide / 1280 == 0 ? 1 : longSide / 1280;
        } else {
            double d = (double)longSide / (1280.0 / (double)scale);
            boolean bl3 = false;
            n = (int)Math.ceil(d);
        }
        return n;
    }

    private final float computeScaleSize(int width, int height) {
        float scale = 1.0f;
        boolean bl = false;
        int max = Math.max(width, height);
        boolean bl2 = false;
        int min = Math.min(width, height);
        float ratio = (float)min / ((float)max * 1.0f);
        if (ratio >= 0.5f) {
            if ((float)max > 1280.0f) {
                scale = 1280.0f / ((float)max * 1.0f);
            }
        } else {
            int multiple = max / min;
            if (multiple < 10) {
                if ((float)min > 1000.0f && (1.0f - ratio / 2.0f) * (float)min > 1000.0f) {
                    scale = 1.0f - ratio / 2.0f;
                }
            } else {
                int arg = (int)Math.pow(multiple, 2.0);
                scale = 1.0f - (float)arg / 1000.0f + (multiple > 10 ? 0.01f : 0.03f);
                if ((float)min * scale < 640.0f) {
                    scale = 1.0f;
                }
            }
        }
        return scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap transformBitmap(Bitmap bitmap, float scale, int angle) {
        Bitmap bitmap2;
        if (scale == 1.0f && angle <= 0) {
            return bitmap;
        }
        try {
            Matrix matrix = new Matrix();
            if (scale != 1.0f) {
                matrix.setScale(scale, scale);
            }
            if (angle > 0) {
                matrix.postRotate((float)angle);
            }
            Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"Bitmap.createBitmap(bitm\u2026map.height, matrix, true)");
            bitmap2 = bitmap3;
        }
        finally {
            System.gc();
        }
        return bitmap2;
    }

    private final boolean hasEnoughMemory(int width, int height, boolean isAlpha32) {
        boolean bl;
        if (Build.VERSION.SDK_INT >= 26) {
            bl = true;
        } else {
            Runtime runtime = Runtime.getRuntime();
            long free = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
            int allocation = width * height << (isAlpha32 ? 2 : 1);
            Checker.INSTANCE.logger("free : " + (free >> 20) + "MB, need : " + (allocation >> 20) + "MB");
            bl = (long)allocation < free;
        }
        return bl;
    }

    public CompressEngine(@NotNull InputStreamProvider<?> srcStream, @NotNull File resFile, boolean compress4Sample, long rqSize, int quality, @NotNull Bitmap.CompressFormat compressFormat, @NotNull Bitmap.Config compressConfig) {
        Intrinsics.checkNotNullParameter(srcStream, (String)"srcStream");
        Intrinsics.checkNotNullParameter((Object)resFile, (String)"resFile");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        Intrinsics.checkNotNullParameter((Object)compressConfig, (String)"compressConfig");
        this.srcStream = srcStream;
        this.resFile = resFile;
        this.compress4Sample = compress4Sample;
        this.rqSize = rqSize;
        this.quality = quality;
        this.compressFormat = compressFormat;
        this.compressConfig = compressConfig;
    }
}

