/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.netlib.generator;

import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import lombok.NonNull;

public class JarMethodScanner {
    private static final Logger log = Logger.getLogger(JarMethodScanner.class.getName());
    @NonNull
    private final File file;

    private URLClassLoader createLoader() {
        try {
            URL url = this.file.toURI().toURL();
            return new URLClassLoader(new URL[]{url});
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getClasses(String packageName) throws IOException {
        JarFile jar = new JarFile(this.file);
        try {
            ArrayList matched = Lists.newArrayList();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement().getName();
                if (!entryName.startsWith(packageName.replace(".", "/")) || !entryName.endsWith(".class")) continue;
                matched.add(entryName.replace(".class", "").replace("/", "."));
            }
            ArrayList arrayList = matched;
            return arrayList;
        }
        finally {
            if (Collections.singletonList(jar).get(0) != null) {
                jar.close();
            }
        }
    }

    public List<Method> getStaticMethods(String packageName) throws Exception {
        ArrayList methods = Lists.newArrayList();
        List<String> classNames = this.getClasses(packageName);
        URLClassLoader loader = this.createLoader();
        for (String className : classNames) {
            Class<?> clazz = loader.loadClass(className);
            for (Method method : clazz.getMethods()) {
                int modifiers = method.getModifiers();
                String fqn = method.getDeclaringClass().getCanonicalName();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !fqn.startsWith(packageName)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    @ConstructorProperties(value={"file"})
    public JarMethodScanner(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.file = file;
    }
}

