/*
 * Decompiled with CFR 0.152.
 */
package io.fno.grel;

import java.math.BigInteger;
import java.util.Random;

public class MathFunctions {
    static final Random random = new Random();

    public static Double floor(Double d) {
        return Math.floor(d);
    }

    public static Double ceil(Double d) {
        return Math.ceil(d);
    }

    public static Double round(Double d) {
        return Math.round(d);
    }

    public static Double min(Double d1, Double d2) {
        return Math.min(d1, d2);
    }

    public static Double max(Double d1, Double d2) {
        return Math.max(d1, d2);
    }

    public static Integer mod(Integer d1, Integer d2) {
        return Math.floorMod(d1, (int)d2);
    }

    public static Double ln(Double d) {
        return Math.log(d);
    }

    public static Double log(Double d) {
        return Math.log10(d);
    }

    public static Double exp(Double d) {
        return Math.exp(d);
    }

    public static Double pow(Double d, Double e) {
        return Math.pow(d, e);
    }

    public static Double abs(Double d) {
        return Math.abs(d);
    }

    public static Double acos(Double d) {
        return Math.acos(d);
    }

    public static Double asin(Double d) {
        return Math.asin(d);
    }

    public static Double atan(Double d) {
        return Math.atan(d);
    }

    public static Double atan2(Double d1, Double d2) {
        return Math.atan2(d1, d2);
    }

    public static Long combin(Long n1, Long n2) {
        if (n1 < n2) {
            return 0L;
        }
        BigInteger result = BigInteger.ONE;
        for (long i = n1.longValue(); i > n2; --i) {
            result = result.multiply(BigInteger.valueOf(i));
        }
        return result.divide(MathFunctions.fact(BigInteger.valueOf(n1 - n2))).longValue();
    }

    public static Double cos(Double d) {
        return Math.cos(d);
    }

    public static Double cosh(Double d) {
        return Math.cosh(d);
    }

    public static Double sin(Double d) {
        return Math.sin(d);
    }

    public static Double sinh(Double d) {
        return Math.sinh(d);
    }

    public static Double tan(Double d) {
        return Math.tan(d);
    }

    public static Double tanh(Double d) {
        return Math.tanh(d);
    }

    public static Double degrees(Double d) {
        return Math.toDegrees(d);
    }

    public static Double radians(Double d) {
        return Math.toRadians(d);
    }

    public static Long even(Double d) {
        long rounded = Math.round(d + 0.4);
        return Math.abs(rounded) % 2L == 0L ? rounded : rounded + 1L;
    }

    public static Long odd(Double d) {
        long rounded = Math.round(d + 0.4);
        return Math.abs(rounded) % 2L == 1L ? rounded : rounded + 1L;
    }

    private static BigInteger fact(BigInteger bigInteger) {
        return MathFunctions.fact(bigInteger, BigInteger.ONE);
    }

    private static BigInteger fact(BigInteger b1, BigInteger step) {
        if (b1.compareTo(BigInteger.ZERO) < 0) {
            return BigInteger.ZERO;
        }
        BigInteger result = BigInteger.ONE;
        BigInteger i = b1;
        while (i.compareTo(BigInteger.ZERO) > 0) {
            result = result.multiply(i);
            i = i.subtract(step);
        }
        return result;
    }

    public static Long fact(Long l) {
        return MathFunctions.fact(BigInteger.valueOf(l)).longValue();
    }

    public static Long factn(Long l1, Long step) {
        return MathFunctions.fact(BigInteger.valueOf(l1), BigInteger.valueOf(step)).longValue();
    }

    public static Long gcd(Long l1, Long l2) {
        if (l1.equals(0L)) {
            return l2;
        }
        if (l2.equals(0L)) {
            return l1;
        }
        return MathFunctions.gcd(l2, l1 % l2);
    }

    public static Long lcm(Long l1, Long l2) {
        return BigInteger.valueOf(l1).multiply(BigInteger.valueOf(l2)).abs().divide(BigInteger.valueOf(MathFunctions.gcd(l1, l2))).longValue();
    }

    public static Long quotient(Long l1, Long l2) {
        return l1 / l2;
    }

    public static Long randomNumber(Long lower, Long upper) {
        double randomDouble = random.nextDouble();
        long delta = upper - lower;
        long randomInDelta = (long)(randomDouble * (double)delta);
        return randomInDelta + lower;
    }

    public static Long multinomial(Long ... args) {
        BigInteger sum = BigInteger.ZERO;
        BigInteger product = BigInteger.ONE;
        for (Long arg : args) {
            BigInteger bigInteger = BigInteger.valueOf(arg);
            sum = sum.add(bigInteger);
            product = product.multiply(MathFunctions.fact(bigInteger));
        }
        return MathFunctions.fact(sum).divide(product).longValue();
    }
}

