/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.http.server;

import com.github.fmjsjx.libnetty.example.http.server.TestController;
import com.github.fmjsjx.libnetty.example.http.server.TestExceptionHandler;
import com.github.fmjsjx.libnetty.handler.ssl.ChannelSslInitializer;
import com.github.fmjsjx.libnetty.handler.ssl.SslContextProvider;
import com.github.fmjsjx.libnetty.handler.ssl.SslContextProviders;
import com.github.fmjsjx.libnetty.http.HttpContentCompressorProvider;
import com.github.fmjsjx.libnetty.http.server.DefaultHttpServer;
import com.github.fmjsjx.libnetty.http.server.component.HttpServerComponent;
import com.github.fmjsjx.libnetty.http.server.middleware.AccessLogger;
import com.github.fmjsjx.libnetty.http.server.middleware.AuthBasic;
import com.github.fmjsjx.libnetty.http.server.middleware.Middleware;
import com.github.fmjsjx.libnetty.http.server.middleware.Router;
import com.github.fmjsjx.libnetty.http.server.middleware.ServeStatic;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDefaultServer {
    private static final Logger log = LoggerFactory.getLogger(TestDefaultServer.class);

    private static final Map<String, String> passwds() {
        return Collections.singletonMap("test", "123456");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        TestController controller = new TestController();
        CorsConfig corsConfig = CorsConfigBuilder.forAnyOrigin().allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE}).allowedRequestHeaders(new String[]{"*"}).allowNullOrigin().build();
        DefaultHttpServer server = new DefaultHttpServer("test", 8443).enableSsl(ChannelSslInitializer.of((SslContextProvider)SslContextProviders.selfSignedForServer())).neverTimeout().corsConfig(corsConfig).ioThreads(1).maxContentLength(0xA00000).supportJson().component((HttpServerComponent)new TestExceptionHandler()).soBackLog(1024).tcpNoDelay().applyCompressionOptions(HttpContentCompressorProvider.defaultOptions());
        server.defaultHandlerProvider().addLast(new Middleware[]{new AccessLogger((AccessLogger.LoggerWrapper)new AccessLogger.Slf4jLoggerWrapper("accessLogger"), AccessLogger.LogFormat.BASIC2)}).addLast("/static/auth", (Middleware)new AuthBasic(TestDefaultServer.passwds(), "test")).addLast(new Middleware[]{new ServeStatic("/static/", "src/main/resources/static/")}).addLast(new Middleware[]{new Router().register((Object)controller).init()});
        try {
            server.startup();
            log.info("Server {} started.", (Object)server);
            System.in.read();
        }
        catch (Exception e) {
            log.error("Unexpected error occurs when startup {}", (Object)server, (Object)e);
        }
        finally {
            if (server.isRunning()) {
                server.shutdown();
                log.info("Server {} stopped.", (Object)server);
            }
        }
    }
}

