/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.fastcgi;

import com.github.fmjsjx.libnetty.example.fastcgi.TestServer;
import com.github.fmjsjx.libnetty.fastcgi.FcgiAbortRequest;
import com.github.fmjsjx.libnetty.fastcgi.FcgiGetValues;
import com.github.fmjsjx.libnetty.fastcgi.FcgiGetValuesResult;
import com.github.fmjsjx.libnetty.fastcgi.FcgiMessage;
import com.github.fmjsjx.libnetty.fastcgi.FcgiRequest;
import com.github.fmjsjx.libnetty.fastcgi.FcgiResponse;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;

class TestServerHandler
extends SimpleChannelInboundHandler<FcgiMessage> {
    TestServerHandler() {
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        System.err.println(ctx.channel() + " connected");
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        System.err.println(ctx.channel() + " disconnected");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    protected void channelRead0(ChannelHandlerContext ctx, FcgiMessage msg) throws Exception {
        System.out.println("-- message received --");
        System.out.println(msg);
        if (msg instanceof FcgiRequest) {
            FcgiRequest req = (FcgiRequest)msg;
            String value = "X-Powered-By: JAVA/" + TestServer.JAVA_VERSION + "\r\ncontent-type: text/html;charset=UTF-8\r\n\r\n<!DOCTYPE html>\n</html>\n<meta charset=\"UTF-8\" />\n<head>\n<title>Test FastCGI</title>\n</head>\n<body>\n<h1>Test Fast-CGI</h1>\n</body>\n\n</html>";
            FcgiResponse resp = new FcgiResponse(req.protocolVersion(), req.requestId(), 0, Unpooled.copiedBuffer((CharSequence)value, (Charset)CharsetUtil.UTF_8));
            System.out.println("FCGI_RESPONSE ==>");
            System.out.println(resp);
            if (req.beginRequest().isKeepConn()) {
                ctx.writeAndFlush((Object)resp);
            } else {
                ctx.writeAndFlush((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        } else if (msg instanceof FcgiGetValues) {
            FcgiGetValuesResult result = new FcgiGetValuesResult(msg.protocolVersion());
            ((FcgiGetValues)msg).names().forEach(name -> result.put(name, (Object)"0"));
            ctx.writeAndFlush((Object)result);
        } else if (msg instanceof FcgiAbortRequest) {
            ctx.close();
        }
    }
}

